/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.crossapplication.sharedresources;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.crossapplication.sharedresources.DataSource;
import com.ez.report.application.ezreport.reports.crossapplication.sharedresources.ReportModel;
import com.ez.report.application.ezreport.reports.summary.ProgramSummaryScriptlet;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.utils.ProjectApplicationInput;
import com.ez.report.application.utils.SharedResourcesUtils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    @Deprecated
    private Boolean useApplications = SharedResourcesUtils.useApplications();
    private String dbName;
    int prjId = 1;
    int resId = 1;

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.singleProject = false;
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        params.put("showInputs1", Boolean.TRUE);
        this.parameters.put("appendixFirstLineLabel", null);
        params.put("resourcesSummary", Messages.getString(ReportBuilder.class, "appendix.projects.summary.lbl"));
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        ArrayList<Object> toRemove;
        Boolean showOnlySummary;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        DataSource dataSource = new DataSource((showOnlySummary = (Boolean)this.getReportModel().getProperty("show summary only")) != null ? showOnlySummary : false, csvWriter);
        List selectedProjects = ((ReportModel)this.report).getSelectedProjects();
        Set notAccessibleProjects = (Set)this.inputs.get("not accessible projects");
        List selectedApplications = (List)this.inputs.get("selected applications for shared resources");
        Set notAccessibleApplications = (Set)this.inputs.get("not accessible applications for shared resources");
        if (notAccessibleProjects != null) {
            toRemove = new ArrayList<Object>();
            for (EZSourceProjectInputType inputProject : selectedProjects) {
                if (!notAccessibleProjects.contains(inputProject.getName())) continue;
                toRemove.add(inputProject);
            }
            selectedProjects.removeAll(toRemove);
        }
        if (this.useApplications.booleanValue() && notAccessibleApplications != null) {
            toRemove = new ArrayList();
            for (ProjectApplicationInput inputApp : selectedApplications) {
                if (!notAccessibleApplications.contains(inputApp.getDisplayName())) continue;
                toRemove.add(inputApp);
            }
            selectedApplications.removeAll(toRemove);
        }
        this.dbName = this.generateName(this.report);
        dataSource.setDbName(this.dbName);
        Pair pair = SharedResourcesUtils.getDBData((IProgressMonitor)pmonitor, (List)selectedProjects, (List)selectedApplications, (Collection)this.getSelected(), (String)this.dbName);
        Set notAccessibleAfterProcessing = (Set)pair.getSecond();
        if (notAccessibleAfterProcessing != null && !notAccessibleAfterProcessing.isEmpty()) {
            ArrayList<Object> toRemove2;
            if (this.useApplications.booleanValue()) {
                toRemove2 = new ArrayList<Object>();
                for (ProjectApplicationInput appInput : selectedApplications) {
                    if (!notAccessibleAfterProcessing.contains(appInput.getDisplayName())) continue;
                    toRemove2.add(appInput);
                }
                selectedApplications.removeAll(toRemove2);
                if (notAccessibleApplications != null) {
                    notAccessibleApplications.addAll(notAccessibleAfterProcessing);
                } else {
                    notAccessibleApplications = notAccessibleAfterProcessing;
                    this.inputs.put("not accessible applications for shared resources", notAccessibleApplications);
                }
                ((ReportModel)this.report).setSelectedApplications(selectedApplications);
                ((ReportModel)this.report).setNotAccessibleApplications(notAccessibleApplications);
            } else {
                toRemove2 = new ArrayList();
                for (EZSourceProjectInputType inputProject : selectedProjects) {
                    if (!notAccessibleAfterProcessing.contains(inputProject.getName())) continue;
                    toRemove2.add(inputProject);
                }
                selectedProjects.removeAll(toRemove2);
                if (notAccessibleProjects != null) {
                    notAccessibleProjects.addAll(notAccessibleAfterProcessing);
                } else {
                    notAccessibleProjects = notAccessibleAfterProcessing;
                    this.inputs.put("not accessible projects", notAccessibleProjects);
                }
                ((ReportModel)this.report).setNotAccessibleProjects(notAccessibleProjects);
            }
        }
        this.writeCSVHeader(csvWriter);
        dataSource.setData((Map)pair.getFirst());
        this.parameters.put("title.projName", null);
        StringBuilder sb = new StringBuilder();
        if (this.useApplications.booleanValue()) {
            for (ProjectApplicationInput prjAppInput : selectedApplications) {
                sb.append(prjAppInput.getDisplayName());
                sb.append(", ");
            }
        } else {
            for (EZSourceProjectInputType inputProject : ((ReportModel)this.report).getSelectedProjects()) {
                sb.append(inputProject.getName());
                sb.append(", ");
            }
        }
        if (sb.length() >= 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        this.parameters.put("inputResources", sb.toString());
        if (this.useApplications.booleanValue()) {
            if (notAccessibleApplications != null && !notAccessibleApplications.isEmpty()) {
                sb = new StringBuilder();
                for (String appDisplayName : notAccessibleApplications) {
                    sb.append(appDisplayName);
                    sb.append(", ");
                }
                sb.delete(sb.length() - 2, sb.length());
                this.parameters.put("resourcesSummary.2", Messages.getString(ReportBuilder.class, "report.appendix.notAccessibleApplications.label"));
                this.parameters.put("inputResources.2", sb.toString());
            }
        } else if (notAccessibleProjects != null && !notAccessibleProjects.isEmpty()) {
            sb = new StringBuilder();
            for (String projectName : notAccessibleProjects) {
                sb.append(projectName);
                sb.append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            this.parameters.put("resourcesSummary.2", Messages.getString(ReportBuilder.class, "report.appendix.notAccessibleProjects.label"));
            this.parameters.put("inputResources.2", sb.toString());
        }
        sb = new StringBuilder();
        for (BaseResourceInput l : this.getSelected()) {
            sb.append(l.getName());
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        this.parameters.put("resourcesSummary.3", Messages.getString(ReportBuilder.class, "report.appendix.selectedTypes.label"));
        this.parameters.put("inputResources.3", sb.toString());
        monitor.done();
        return dataSource;
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    public Map getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        boolean showSummaryOnly = false;
        if (showSummaryOnly) {
            String externalized = Messages.getString(ReportBuilder.class, "onlySummaryReport.title");
            this.parameters.put("report.title", externalized);
        } else {
            String externalized = Messages.getString(ReportBuilder.class, "report.title");
            this.parameters.put("report.title", externalized);
        }
        this.parameters.put("group1.name", "");
        Utils.addScriptlet(this.parameters, ProgramSummaryScriptlet.class.getName());
        this.putSubreportStream("/reports/inventorySummary.jasper", "summarySubreportTemplate");
        this.putSubreportStream("/reports/subCols1.jasper", "summarySubreportTemplateS1");
        this.putSubreportStream("/reports/subCols2WithGroup.jasper", "summarySubreportTemplateS2");
        this.putSubreportStream("/reports/subBase.jasper", "detailsSubreportTemplate");
        monitor.worked(100);
        return this.parameters;
    }

    protected String getReportTemplatePath() {
        return "reports/summaryReport.jasper";
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            Collection inputs = (Collection)this.inputs.get("selected resources");
            ArrayList<BaseResourceInput> selectedResTypes = new ArrayList<BaseResourceInput>();
            for (Object obj : inputs) {
                if (obj instanceof BaseResourceInput) {
                    selectedResTypes.add((BaseResourceInput)obj);
                    continue;
                }
                if (!(obj instanceof BaseResourceInput4GUI)) continue;
                selectedResTypes.add(((BaseResourceInput4GUI)obj).getObject());
            }
            this.report.setInput(selectedResTypes);
            ((ReportModel)this.report).setSelectedProjects((Collection)this.inputs.get("selected projects"));
            ((ReportModel)this.report).setNotAccessibleProjects((Collection)this.inputs.get("not accessible projects"));
            ((ReportModel)this.report).setSelectedApplications((List)this.inputs.get("selected applications for shared resources"));
            ((ReportModel)this.report).setNotAccessibleApplications((Set)this.inputs.get("not accessible applications for shared resources"));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        } else {
            L.debug("reload?");
        }
        return this.report;
    }

    private Collection<String> getNotAccessibleProjects() {
        if (this.report == null) {
            return (Collection)this.inputs.get("not accessible projects");
        }
        return (Collection)this.report.getProperty("not accessible projects");
    }

    protected Collection getSelectedProjects() {
        if (this.report == null) {
            return (Collection)this.inputs.get("selected projects");
        }
        return (Collection)this.report.getProperty("selected projects");
    }

    protected String generateName(AbstractReport report) {
        return SharedResourcesUtils.generateName((String)this.getGenDate(report), (String)report.getTitle());
    }

    protected File createTempCSVFile() {
        String prefix;
        String relativePath = "csv" + File.separator + "sharedResources";
        File csvFile = ReportBuilder.createTempFile((String)relativePath, (String)(prefix = (String)this.parameters.get("report.title")), (String)".csv");
        if (csvFile == null) {
            L.error("could not create csv file. it will not be available");
        }
        return csvFile;
    }

    private void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            String reportTitle = Messages.getString(((Object)((Object)this)).getClass(), "report.title");
            if (reportTitle == null || reportTitle.isEmpty()) {
                reportTitle = (String)this.parameters.get("report.title");
            }
            csv.writeLine(reportTitle == null ? "" : reportTitle);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd' 'HH:mm");
            csv.writeLine(String.valueOf(Messages.getString(((Object)((Object)this)).getClass(), "csv.header.date")) + sdf.format(new Date()));
            StringBuilder sBuilder = new StringBuilder();
            if (!this.useApplications.booleanValue()) {
                List selectedProjects = (List)this.getSelectedProjects();
                for (EZSourceProjectInputType projectInputType : selectedProjects) {
                    if (sBuilder.length() > 0) {
                        sBuilder.append(", ");
                    }
                    sBuilder.append(projectInputType.getName());
                }
                csv.writeLine(Messages.getString(((Object)((Object)this)).getClass(), "csv.header.accessedProjects", new String[]{sBuilder.toString()}));
                sBuilder = new StringBuilder();
                Set notAccessibleProjects = (Set)this.inputs.get("not accessible projects");
                for (String prjName : notAccessibleProjects) {
                    if (sBuilder.length() > 0) {
                        sBuilder.append(", ");
                    }
                    sBuilder.append(prjName);
                }
                csv.writeLine(Messages.getString(((Object)((Object)this)).getClass(), "csv.header.notAccessedProjects", new String[]{sBuilder.toString()}));
            } else {
                List selectedApplications = (List)this.inputs.get("selected applications for shared resources");
                for (ProjectApplicationInput appInput : selectedApplications) {
                    if (sBuilder.length() > 0) {
                        sBuilder.append(", ");
                    }
                    sBuilder.append(appInput.getDisplayName());
                }
                csv.writeLine(Messages.getString(((Object)((Object)this)).getClass(), "csv.header.accessedApplications", new String[]{sBuilder.toString()}));
                sBuilder = new StringBuilder();
                Set notAccessibleApplications = (Set)this.inputs.get("not accessible applications for shared resources");
                for (String appName : notAccessibleApplications) {
                    if (sBuilder.length() > 0) {
                        sBuilder.append(", ");
                    }
                    sBuilder.append(appName);
                }
                csv.writeLine(Messages.getString(((Object)((Object)this)).getClass(), "csv.header.notAccessedApplications", new String[]{sBuilder.toString()}));
            }
            csv.writeLine("");
            String projectsOrAppsLabel = Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.projects");
            if (this.useApplications.booleanValue()) {
                projectsOrAppsLabel = Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.applications");
            }
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.resourceType"), Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.resourceName"), projectsOrAppsLabel});
        }
    }
}

