/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.crossapplication.sharedresources;

import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.AdabasUtils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.SummaryGenericDataSource;
import com.ez.report.application.reports.summary.StoredProcedureResults;
import com.ez.report.application.utils.SharedResourcesUtils;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SC2DataSourceWithGroup;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSource
extends SummaryGenericDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DataSource.class);
    private Map<Integer, Integer> data;
    private List<Integer> resTypeIds = new ArrayList<Integer>();
    private String dbName;
    private int countPrg = 0;

    public DataSource(boolean showOnlySummary, CSVWriter csvWriter) {
        super(null, showOnlySummary, csvWriter);
    }

    @Override
    protected void init() {
        if (this.isOnlySummary()) {
            this.list.add(new ElementGroupInfo(null));
        }
    }

    @Override
    public void setData(StoredProcedureResults data) {
    }

    void setData(Map<Integer, Integer> data) {
        this.data = data;
        if (!this.isOnlySummary() && data != null) {
            this.resTypeIds = new ArrayList<Integer>(data.keySet());
            Collections.sort(this.resTypeIds);
            if (this.resTypeIds.contains(5)) {
                this.resTypeIds.remove((Object)5);
                this.resTypeIds.add(0, 5);
            }
            this.buildDetails();
            if (this.list.isEmpty()) {
                this.list.add(new ElementGroupInfo(null));
            }
        }
    }

    public boolean nextItem() throws JRException {
        boolean vb = super.nextItem();
        if (!vb) {
            this.buildDetails();
            vb = super.nextItem();
        }
        if (!vb) {
            L.debug("dbName: {}", (Object)this.dbName);
            SharedResourcesUtils.closeHSqlServer((String)this.dbName);
            if (this.csvWriter != null) {
                this.csvWriter.close();
            }
        }
        return vb;
    }

    private void buildDetails() {
        DSFactory factory = new DSFactory();
        this.list.clear();
        ElementGroupInfo elem = null;
        ArrayList<ObjectForSubreport> objList = null;
        SC2DataSourceWithGroup elemDS = null;
        ObjectForSubreport obj = null;
        boolean contin = true;
        while (!this.resTypeIds.isEmpty() && contin) {
            Integer resTypeId = this.resTypeIds.remove(0);
            String resTypeName = SharedResourcesUtils.getResTypeNameByResTypeId((Integer)resTypeId);
            List sharedResources = SharedResourcesUtils.getSharedResByType((Integer)resTypeId, (String)this.dbName);
            if (sharedResources == null || sharedResources.isEmpty()) continue;
            elemDS = (SC2DataSourceWithGroup)factory.createDS(2);
            objList = new ArrayList<ObjectForSubreport>();
            elemDS.setList(objList);
            elem = new ElementGroupInfo(resTypeName);
            elem.addDataSource((SubreportDataSource)elemDS);
            Collections.sort(sharedResources);
            for (ProgramInputNoGUI resourceInput : sharedResources) {
                String hsqlUniqueResName;
                Set projs = resourceInput.getApplications();
                if (projs == null || projs.size() < 2) continue;
                String resDisplayName = hsqlUniqueResName = resourceInput.getName();
                if (resTypeId != null) {
                    boolean allowPrinting = SharedResourcesUtils.allowDrawing((ProgramInputNoGUI)resourceInput, (Integer)resTypeId);
                    if (!allowPrinting) continue;
                    String[] parts = null;
                    switch (resTypeId) {
                        case 18: {
                            parts = hsqlUniqueResName.split("##EZSRC##");
                            if (parts == null || parts.length < 2) {
                                L.warn("wrong name or path for an IMSDB file: {}", (Object)hsqlUniqueResName);
                                break;
                            }
                            resDisplayName = parts[0];
                            break;
                        }
                        case 56: {
                            parts = hsqlUniqueResName.split("##EZSRC##");
                            if (parts == null || parts.length != 2) {
                                L.warn("wrong name for an ADABAS file: {}", (Object)hsqlUniqueResName);
                                break;
                            }
                            resDisplayName = AdabasUtils.getListableName((String)parts[0], (String)parts[1]);
                            break;
                        }
                        case 13: 
                        case 60: 
                        case 67: 
                        case 99: {
                            parts = hsqlUniqueResName.split("##EZSRC##");
                            if (parts == null || parts.length != 2) {
                                L.warn("Invalid data for an Include: {}", (Object)hsqlUniqueResName);
                                break;
                            }
                            resDisplayName = parts[0];
                            break;
                        }
                    }
                    if (5 == resTypeId) {
                        boolean fileOnDisk = false;
                        for (Pair p : resourceInput.getResDbIdInPrj()) {
                            String[] info = ((String)p.getSecond()).split("##EZSRC##");
                            String path = info[4];
                            if (path == null || path.isEmpty() || path.equalsIgnoreCase("null")) continue;
                            fileOnDisk = true;
                            break;
                        }
                        if (!fileOnDisk) {
                            resDisplayName = String.valueOf(resDisplayName) + Messages.getString(DataSource.class, "missing.res");
                        }
                        L.debug("increase prg number to {}", (Object)this.countPrg);
                        ++this.countPrg;
                    }
                }
                for (String prjName : projs) {
                    obj = new ObjectForSubreport();
                    obj.setElGroup(Messages.getString(DataSource.class, "sharedFile.title", new String[]{resDisplayName}));
                    obj.setParent(resTypeName);
                    obj.setExp(prjName);
                    obj.setExpVal("");
                    objList.add(obj);
                }
                String[] rowArray = new String[projs.size() + 2];
                rowArray[0] = resTypeName;
                rowArray[1] = resDisplayName;
                int i = 2;
                Iterator iterator = projs.iterator();
                while (iterator.hasNext()) {
                    String projectOrAppName;
                    rowArray[i] = projectOrAppName = (String)iterator.next();
                    ++i;
                }
                if (this.csvWriter == null) continue;
                this.csvWriter.write(rowArray);
            }
            this.list.add(elem);
            contin = false;
            sharedResources = null;
        }
    }

    @Override
    protected SubreportDataSource getTotalSummaryDataSource(String appName) {
        SubreportDataSource subReportDS = null;
        ArrayList<ObjectForSubreport> lst = new ArrayList<ObjectForSubreport>();
        this.prgTotalsDS = new SC1DataSource(null, lst);
        if (this.data == null || this.data.keySet().size() == 0) {
            ObjectForSubreport obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(DataSource.class, "noData.message"));
            obj.setExpVal("");
            lst.add(obj);
        } else {
            int total = 0;
            ArrayList<Integer> rTypeIds = new ArrayList<Integer>(this.data.keySet());
            Collections.sort(rTypeIds);
            for (Integer resTypeId : rTypeIds) {
                String resTypeName = SharedResourcesUtils.getResTypeNameByResTypeId((Integer)resTypeId);
                ObjectForSubreport obj = new ObjectForSubreport();
                String totalString = Messages.getString(DataSource.class, "summary.total.entry", new String[]{resTypeName});
                obj.setExp(totalString);
                Integer prgNo = 5 == resTypeId ? this.countPrg : this.data.get(resTypeId);
                obj.setExpVal("" + prgNo);
                lst.add(obj);
                total += prgNo.intValue();
            }
        }
        return subReportDS;
    }

    @Override
    protected SubreportDataSource getAvgSummaryDataSource(String appName) {
        return null;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }
}

