/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules.ui;

import com.ez.common.ui.listselection.Listable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectCSInputPage<T extends Listable>
extends SelectProgramsPage<Listable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SelectCSInputPage.class);
    private static final String dialogTitle = Messages.getString(SelectCSInputPage.class, "dialog.title");
    private static final String btnLbl = Messages.getString(SelectCSInputPage.class, "button.lbl");
    private static final String withoutInputsDesc = Messages.getString(SelectCSInputPage.class, "without.inputs");
    private String[] rules = null;

    public SelectCSInputPage(String pageName, boolean useFilters) {
        super(pageName, useFilters);
        this.pageDescriptionWhenNoResources = withoutInputsDesc;
    }

    protected void createContent(Composite composite) {
        super.createContent(composite);
        if (this.rules != null) {
            Composite fakeParent = new Composite(composite, composite.getStyle());
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 131072;
            data.verticalAlignment = 128;
            fakeParent.setLayoutData((Object)data);
            GridLayout gl = new GridLayout();
            gl.horizontalSpacing = 100;
            gl.marginRight = 5;
            fakeParent.setLayout((Layout)gl);
            Button infoBtn = new Button(fakeParent, 8);
            infoBtn.addMouseListener((MouseListener)new InfoListener());
            infoBtn.setText(btnLbl);
        } else {
            L.warn("no rules for current inputs");
        }
    }

    public void setRules(String[] rules) {
        this.rules = rules;
    }

    public void fillUIWithProgress() {
        super.fillUIWithProgress();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                SelectCSInputPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    protected boolean acceptNoRes() {
        return true;
    }

    public boolean isPageComplete() {
        boolean ispagecomplete = super.isPageComplete();
        if (!ispagecomplete) {
            this.wizard = (PrepareReportWizard)this.getWizard();
            List available = this.wizard.getList(this.availablePropName);
            L.debug("{}", (Object)available);
            if (available != null && available.isEmpty()) {
                this.wizard.set(this.selectedPropName, (Object)available);
                ispagecomplete = true;
            }
        }
        return ispagecomplete;
    }

    class InfoListener
    extends MouseAdapter {
        InfoListener() {
        }

        public void mouseUp(MouseEvent e) {
            ShowInfoDialog dialog = new ShowInfoDialog(Display.getCurrent().getActiveShell());
            dialog.open();
        }
    }

    class ShowInfoDialog
    extends Dialog {
        public ShowInfoDialog(Shell parent) {
            super(parent);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite, 2816);
            GridData data = new GridData(768);
            data.grabExcessVerticalSpace = true;
            data.verticalAlignment = 4;
            data.minimumHeight = 60;
            data.heightHint = 100;
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            list.setLayoutData((Object)data);
            list.setItems(SelectCSInputPage.this.rules);
            list.deselectAll();
            list.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    org.eclipse.swt.widgets.List l = (org.eclipse.swt.widgets.List)event.widget;
                    l.deselectAll();
                }
            });
            list.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    org.eclipse.swt.widgets.List l = (org.eclipse.swt.widgets.List)e.widget;
                    l.deselectAll();
                }

                public void mouseDown(MouseEvent e) {
                    org.eclipse.swt.widgets.List l = (org.eclipse.swt.widgets.List)e.widget;
                    l.deselectAll();
                }

                public void mouseUp(MouseEvent e) {
                    org.eclipse.swt.widgets.List l = (org.eclipse.swt.widgets.List)e.widget;
                    l.deselectAll();
                }
            });
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(dialogTitle);
        }

        protected boolean isResizable() {
            return true;
        }
    }
}

