/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules.ui;

import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.SelectAbstractProgramsPage;
import com.ez.report.application.ui.wizard.SelectApplicationPage;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodingRulesWizardDialog
extends ReportWizardDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CodingRulesWizardDialog.class);

    public CodingRulesWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
    }

    public int open() {
        int ret;
        IWizardPage page = this.getCurrentPage();
        if (page.getName().equals("No DB resources page")) {
            this.setBlockOnOpen(false);
            ret = super.open();
            if (page instanceof SelectAbstractProgramsPage) {
                SelectAbstractProgramsPage pageSel = (SelectAbstractProgramsPage)page;
                pageSel.fillUIWithProgress();
                this.getWizard().getContainer().updateButtons();
            }
            this.runEventLoop(this.getShell());
        } else {
            ret = super.open();
        }
        return ret;
    }

    public void handlePageChanging(PageChangingEvent event) {
        L.debug("handlePageChanging()::{}", (Object)event);
        IWizardPage currentPage = (IWizardPage)event.getCurrentPage();
        IWizardPage nextPage = (IWizardPage)event.getTargetPage();
        ((PrepareReportWizard)this.getWizard()).setChangeDirection(currentPage, nextPage);
        if (currentPage.equals(((PrepareReportWizard)this.getWizard()).getPage("applications name page"))) {
            ((SelectApplicationPage)currentPage).setSelectedApplications();
        }
        if (currentPage.equals(((PrepareReportWizard)this.getWizard()).getPage("No DB resources page")) && nextPage.equals(((PrepareReportWizard)this.getWizard()).getPage("applications name page"))) {
            SelectApplicationPage appSelPage = (SelectApplicationPage)nextPage;
            appSelPage.fillApplicationsList();
        } else {
            L.debug("nextPage: {}", (Object)nextPage);
        }
    }

    public void showPage(IWizardPage page) {
        super.showPage(page);
        if (page.getName().startsWith("programs page")) {
            SelectProgramsPage pageSel = (SelectProgramsPage)page;
            pageSel.setRunSearch(true);
            pageSel.fillUIWithProgress();
        }
    }

    protected void nextPressed() {
        super.nextPressed();
    }
}

