/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules.ui;

import com.ez.codingrules.Rule;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.codingrules.RuleBasedUtils;
import com.ez.report.application.ezreport.reports.codingrules.ui.CSInputCollector;
import com.ez.report.application.ezreport.reports.codingrules.ui.SelectCSInputPage;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class CodingRulesWizard
extends PrepareReportWizard {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private List<IWizardPage> csPages = new ArrayList<IWizardPage>();
    List<String> keys = new ArrayList<String>();

    public CodingRulesWizard() {
        this.setForcePreviousAndNextButtons(true);
    }

    public boolean canFinish() {
        boolean ret = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage.getName().equals("No DB resources page")) {
            ret = currentPage.isPageComplete() && !currentPage.canFlipToNextPage();
        } else {
            IWizardPage[] pages = this.getPages();
            int i = 0;
            while (i < this.getPageCount()) {
                if (!pages[i].isPageComplete()) {
                    return false;
                }
                ++i;
            }
            ret = true;
        }
        return ret;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int index;
        if ("No DB resources page".equals(page.getName())) {
            this.csPages.clear();
            this.csPages.add(page);
            List selected = (List)this.getValue("input rules");
            Map queriesMap = RuleBasedUtils.prepareInputs((List)selected);
            if (!queriesMap.isEmpty()) {
                for (String queryKey : queriesMap.keySet()) {
                    Triplet info = (Triplet)queriesMap.get(queryKey);
                    String pageName = "programs page".concat(queryKey);
                    IWizardPage pageForQuery = this.getPage(pageName);
                    if (pageForQuery == null) {
                        SelectCSInputPage selectCSPage = new SelectCSInputPage(pageName, false);
                        String selPropName = RuleBasedUtils.getKeyForSelected((String)queryKey);
                        this.keys.add(selPropName);
                        String availPropName = queryKey;
                        if ("allCobolPrograms".equals(queryKey)) {
                            availPropName = "available resources";
                        }
                        selectCSPage.setAvailablePropName(availPropName);
                        selectCSPage.setLeftGroupLabel(Messages.getString(CodingRulesWizard.class, "av.object.type", new String[]{(String)info.getThird()}));
                        selectCSPage.setRightGroupLabel(Messages.getString(CodingRulesWizard.class, "sel.object.type", new String[]{(String)info.getThird()}));
                        String errMsg = Messages.getString(CodingRulesWizard.class, "wrongSQL.error");
                        selectCSPage.setErrMsgNoResource(errMsg);
                        selectCSPage.setSelectedPropName(selPropName);
                        this.computeRulesForQuery((Triplet<String, List<Rule>, String>)info, (IWizardPage)selectCSPage);
                        CSInputCollector pc = new CSInputCollector();
                        pc.setQuery((String)info.getFirst());
                        selectCSPage.setResourcesCollector((ResourcesCollector)pc);
                        this.addPage((IWizardPage)selectCSPage);
                        continue;
                    }
                    this.computeRulesForQuery((Triplet<String, List<Rule>, String>)info, pageForQuery);
                }
            }
        }
        if ((index = this.csPages.indexOf(page)) == this.csPages.size() - 1 || index == -1) {
            return null;
        }
        return this.csPages.get(index + 1);
    }

    private void computeRulesForQuery(Triplet<String, List<Rule>, String> info, IWizardPage pageForQuery) {
        List rules = (List)info.getSecond();
        ArrayList<String> ruleNames = new ArrayList<String>();
        for (Rule r : rules) {
            ruleNames.add(r.getName());
        }
        ((SelectCSInputPage)pageForQuery).setRules(ruleNames.toArray(new String[0]));
    }

    public void addPage(IWizardPage page) {
        super.addPage(page);
        this.csPages.add(page);
    }

    public void createPageControls(Composite pageContainer) {
        int i = 0;
        while (i < this.csPages.size()) {
            IWizardPage page = this.csPages.get(i);
            page.createControl(pageContainer);
            Assert.isNotNull((Object)page.getControl());
            ++i;
        }
    }

    public IWizardPage getPage(String name) {
        int i = 0;
        while (i < this.csPages.size()) {
            IWizardPage page = this.csPages.get(i);
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public int getPageCount() {
        return this.csPages.size();
    }

    public IWizardPage[] getPages() {
        return this.csPages.toArray(new IWizardPage[this.csPages.size()]);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.csPages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return this.csPages.get(index - 1);
    }

    public IWizardPage getStartingPage() {
        if (this.csPages.size() == 0) {
            return null;
        }
        return this.csPages.get(0);
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public boolean performFinish() {
        boolean ret = true;
        for (String key : this.keys) {
            List c = this.getList(key);
            if (c == null) continue;
            List newLst = BaseResourceInput4GUI.extractNonGUIObjects((Collection)c);
            this.set(key, newLst);
            c.clear();
            c = null;
        }
        return ret && super.performFinish();
    }
}

