/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules.ui;

import com.ez.codingrules.MainframeRuleBasedUtils;
import com.ez.codingrules.Rule;
import com.ez.codingrules.RuleInput;
import com.ez.codingrules.RuleParameter;
import com.ez.codingrules.RulesManager;
import com.ez.codingrules.cobol.CobolRule;
import com.ez.common.ui.listselection.ListChangeEvent;
import com.ez.common.ui.listselection.ListChangeListener;
import com.ez.common.ui.listselection.TreeSelectionUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import com.ez.report.application.ezreport.reports.codingrules.ui.AvailableFilter;
import com.ez.report.application.ezreport.reports.codingrules.ui.EZTreeContentProvider;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodingRulesPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CodingRulesPage.class);
    private static final String RULE_PARAMETER = "RULE_PARAMETER";
    private static final String RULE = "RULE";
    private PrepareReportWizard wizard;
    private RulesManager manager;
    private String availablePropName;
    private String selectedPropName;
    private Text weightText = null;
    private Label weightLabel = null;
    private Label ruleNameLbl = null;
    private Label ruleDescriptionLbl = null;
    private Group paramGroup = null;
    private ModifyListener paramModifyListener;
    private List<Label> paramNameLabelList = new LinkedList<Label>();
    private List<Text> paramValueTextList = new LinkedList<Text>();
    private Group infoComposite;
    private static final String errMsg = Messages.getString(CodingRulesPage.class, "nores.info");
    private Button btnAppendix;

    public CodingRulesPage(String pageName) {
        super(pageName);
        this.createRulesManager();
    }

    private void createRulesManager() {
        RulesManager rulesManager;
        File file;
        String customRulesFilePath = MainframeRuleBasedUtils.getRuleBasedPath();
        if (customRulesFilePath != null && !customRulesFilePath.isEmpty() && (file = new File(customRulesFilePath)).exists() && file.isFile() && (rulesManager = this.getRules(file)) != null) {
            this.manager = rulesManager;
        }
    }

    private RulesManager getRules(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("coding standards property file should not be a directory");
        }
        String charset = MainframeRuleBasedUtils.getRuleBasedEncoding();
        RulesManager rulesManager = new RulesManager();
        rulesManager.setFileEncoding(charset);
        rulesManager.setFilePath(file.getParentFile());
        FileInputStream istream = null;
        Reader reader = null;
        try {
            try {
                istream = new FileInputStream(file);
                reader = this.getReader(istream, charset);
                if (reader != null) {
                    rulesManager.initRules(reader);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("coding standards property file does not exist", e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    istream = null;
                }
                catch (IOException e) {
                    L.warn("could not close stream reader ", (Throwable)e);
                }
            }
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (IOException e) {
                    L.warn("could not close istream ", (Throwable)e);
                }
            }
        }
        if (rulesManager.getTopLevelGroups().size() == 0) {
            this.setErrorMessage(errMsg);
        }
        return rulesManager;
    }

    private Reader getReader(InputStream is, String charset) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(is, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            L.warn("could not use {} as encoding", (Object)charset);
        }
        return reader;
    }

    public void createControl(Composite parent) {
        this.wizard = (PrepareReportWizard)this.getWizard();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        composite.setLayoutData((Object)data);
        TreeSelectionUI<CobolRule> treeUi = this.createContent(composite);
        this.createRuleDescriptionComposite(composite);
        this.createReportOptionsGroup(composite);
        this.setControl((Control)composite);
        parent.getShell().layout();
        if (this.manager != null) {
            this.updateLists(treeUi, this.manager.getTopLevelGroups());
        } else {
            this.setErrorMessage(errMsg);
        }
    }

    private void createReportOptionsGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        optionsGroup.setText(Messages.getString(CodingRulesPage.class, "generationOptions.lbl"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 0x1000008;
        data.verticalAlignment = 128;
        optionsGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        optionsGroup.setLayout((Layout)gl);
        this.btnAppendix = new Button((Composite)optionsGroup, 32);
        this.btnAppendix.setText(Messages.getString(CodingRulesPage.class, "showAppendix.lbl"));
        Boolean showAppendix = PreferenceUtils.getPreferenceStore().getBoolean("showAppendix");
        this.btnAppendix.setSelection(showAppendix.booleanValue());
        this.checkAppendix();
        this.btnAppendix.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CodingRulesPage.this.checkAppendix();
            }
        });
        data = new GridData(4, 4, true, true);
        this.btnAppendix.setLayoutData((Object)data);
    }

    protected void checkAppendix() {
        boolean showAppendix = this.btnAppendix.getSelection();
        this.wizard.set("show appendix", (Object)showAppendix);
    }

    private void createRuleDescriptionComposite(Composite composite) {
        this.infoComposite = new Group(composite, composite.getStyle());
        this.infoComposite.setVisible(false);
        this.infoComposite.setText(Messages.getString(CodingRulesPage.class, "rule.desc.lbl"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 40;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1024;
        this.infoComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, true);
        layout.marginRight = 5;
        this.infoComposite.setLayout((Layout)layout);
        Composite leftComp = new Composite((Composite)this.infoComposite, composite.getStyle());
        layout = new GridLayout(2, false);
        leftComp.setLayout((Layout)layout);
        data = new GridData(1808);
        leftComp.setLayoutData((Object)data);
        this.ruleNameLbl = new Label(leftComp, 8);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.ruleNameLbl.setLayoutData((Object)data);
        this.ruleDescriptionLbl = new Label(leftComp, 584);
        data = new GridData(1808);
        data.horizontalIndent = 10;
        data.horizontalSpan = 2;
        this.ruleDescriptionLbl.setLayoutData((Object)data);
        this.weightLabel = new Label(leftComp, 16384);
        this.weightLabel.setText(Messages.getString(CodingRulesPage.class, "rule.weight.lbl"));
        this.weightText = new Text(leftComp, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.weightText.setLayoutData((Object)data);
        this.weightText.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                String text = CodingRulesPage.this.weightText.getText();
                try {
                    ((Rule)CodingRulesPage.this.weightText.getData(CodingRulesPage.RULE)).setWeight(Integer.valueOf(Integer.parseInt(text)));
                }
                catch (NumberFormatException e) {
                    L.info("Parse exception caused by invalid value", (Throwable)e);
                }
            }
        });
        this.paramGroup = new Group((Composite)this.infoComposite, composite.getStyle());
        this.paramGroup.setText(Messages.getString(CodingRulesPage.class, "rule.parameters.lbl"));
        layout = new GridLayout(2, false);
        this.paramGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        this.paramGroup.setLayoutData((Object)data);
        this.setParameters(null);
        this.paramModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                if (text.getData(CodingRulesPage.RULE_PARAMETER) != null) {
                    String oldValue;
                    RuleParameter parameter = (RuleParameter)text.getData(CodingRulesPage.RULE_PARAMETER);
                    String newValue = text.getText();
                    if (!newValue.equals(oldValue = parameter.getValue())) {
                        String msg = parameter.isValid(newValue);
                        if (msg == null || msg.isEmpty()) {
                            parameter.setValue(newValue);
                            text.setBackground(null);
                        } else {
                            Display display = Display.getCurrent();
                            Color red = display.getSystemColor(3);
                            text.setBackground(red);
                        }
                    }
                }
            }
        };
    }

    private TreeSelectionUI<CobolRule> createContent(Composite composite) {
        final AvailableFilter avfilter = new AvailableFilter();
        final TreeSelectionUI treeUi = new TreeSelectionUI(composite, Messages.getString(CodingRulesPage.class, "selectionlist.resource.type"), (IContentProvider)new EZTreeContentProvider(), (ViewerFilter)avfilter);
        treeUi.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                Object o = ((TreeSelection)sel).getFirstElement();
                CodingRulesPage.this.updateInfoSection(o);
                treeUi.updateAll();
            }
        });
        treeUi.addChangeListener(new ListChangeListener(){

            public void listChangeEventHappend(ListChangeEvent listChangeEv) {
                List selected = treeUi.getSelObjectList();
                avfilter.setToHide(selected);
                CodingRulesPage.this.wizard.set(CodingRulesPage.this.selectedPropName, (Object)selected);
                CodingRulesPage.this.getWizard().getContainer().updateButtons();
            }
        });
        return treeUi;
    }

    private void updateInfoSection(Object o) {
        String weightValue = "";
        String ruleName = "";
        String desc = "";
        CobolRule ruleForWeight = null;
        if (o instanceof CobolRule) {
            CobolRule rule = (CobolRule)o;
            weightValue = String.valueOf(rule.getWeight());
            desc = rule.getDescription();
            ruleName = rule.getListableName();
            ArrayList params = null;
            if (rule.getParameters() != null) {
                params = new ArrayList(rule.getParameters().values());
            }
            this.setParameters(params);
            ruleForWeight = rule;
        }
        if (ruleForWeight != null) {
            this.infoComposite.setVisible(true);
            boolean visible = !ruleForWeight.isGroup();
            this.weightText.setVisible(visible);
            this.weightLabel.setVisible(visible);
            this.weightText.setText(weightValue);
            this.weightText.setData(RULE, (Object)ruleForWeight);
            this.ruleNameLbl.setText(ruleName);
            this.ruleDescriptionLbl.setText(desc);
        } else {
            this.infoComposite.setVisible(false);
        }
    }

    private void setParameters(List<RuleParameter> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            this.paramGroup.setVisible(false);
            while (this.paramNameLabelList.size() > 0) {
                this.paramNameLabelList.remove(0).dispose();
                this.paramValueTextList.remove(0).dispose();
            }
        } else {
            this.paramGroup.setVisible(true);
            while (this.paramNameLabelList.size() > paramMap.size()) {
                this.paramNameLabelList.remove(0).dispose();
                this.paramValueTextList.remove(0).dispose();
            }
            while (this.paramNameLabelList.size() < paramMap.size()) {
                Label label = new Label((Composite)this.paramGroup, 0);
                Text text = new Text((Composite)this.paramGroup, 2048);
                text.addModifyListener(this.paramModifyListener);
                GridData data = new GridData(768);
                text.setLayoutData((Object)data);
                this.paramNameLabelList.add(label);
                this.paramValueTextList.add(text);
            }
            int i = 0;
            for (RuleParameter p : paramMap) {
                String paramName = p.getName();
                String paramValue = p.getValue();
                String paramPattern = p.getPattern();
                Integer paramLength = p.getLength();
                Integer paramValueGreater = p.getValueGreater();
                Integer paramValueLess = p.getValueLess();
                String paramPrefix = p.getPrefix();
                String paramSuffix = p.getSuffix();
                this.paramNameLabelList.get(i).setText(paramName);
                this.paramValueTextList.get(i).setData(RULE_PARAMETER, (Object)p);
                this.paramValueTextList.get(i).setText(paramValue);
                this.paramValueTextList.get(i).setBackground(null);
                this.paramValueTextList.get(i).setToolTipText("");
                StringBuilder infoStringBuider = new StringBuilder();
                if (paramPattern != null && !paramPattern.isEmpty()) {
                    infoStringBuider.append(Messages.getString(CodingRulesPage.class, "parameter.tooltip.patternPart", new String[]{paramPattern}));
                }
                if (paramLength != null) {
                    infoStringBuider.append(Messages.getString(CodingRulesPage.class, "parameter.tooltip.lengthPart", new Object[]{paramLength}));
                }
                if (paramValueGreater != null) {
                    infoStringBuider.append(Messages.getString(CodingRulesPage.class, "parameter.tooltip.greaterThanPart", new Object[]{paramValueGreater}));
                }
                if (paramValueLess != null) {
                    infoStringBuider.append(Messages.getString(CodingRulesPage.class, "parameter.tooltip.lessThanPart", new Object[]{paramValueLess}));
                }
                if (paramPrefix != null && !paramPrefix.isEmpty()) {
                    infoStringBuider.append(Messages.getString(CodingRulesPage.class, "parameter.tooltip.prefixPart", new Object[]{paramPrefix}));
                }
                if (paramSuffix != null && !paramSuffix.isEmpty()) {
                    infoStringBuider.append(Messages.getString(CodingRulesPage.class, "parameter.tooltip.suffixPart", new Object[]{paramSuffix}));
                }
                if (!infoStringBuider.toString().isEmpty()) {
                    this.paramValueTextList.get(i).setToolTipText(infoStringBuider.toString());
                }
                ++i;
            }
        }
        this.paramGroup.layout();
    }

    private void updateLists(TreeSelectionUI<CobolRule> listUi, List<Rule> available) {
        listUi.clearUILists();
        listUi.setAvailable(available);
        this.wizard.set(this.availablePropName, available);
    }

    public boolean canFlipToNextPage() {
        boolean isPageComplete = this.isPageComplete();
        boolean hasNext = false;
        if (isPageComplete) {
            List selected = (List)this.wizard.getValue("input rules");
            for (CobolRule r : selected) {
                Map inputs = r.getInputs();
                if (inputs == null) continue;
                for (RuleInput rule : inputs.values()) {
                    String queryKey = rule.getKey();
                    if (queryKey == null || rule.getQuery() == null) continue;
                    return true;
                }
            }
        }
        return isPageComplete && hasNext;
    }

    public boolean isPageComplete() {
        List sel = this.wizard.getList(this.selectedPropName);
        boolean ret = false;
        ret = sel != null && sel.size() >= 1;
        return ret;
    }

    public void dispose() {
        this.wizard = null;
        super.dispose();
    }

    public void setAvailablePropName(String propName) {
        this.availablePropName = propName;
    }

    public void setSelectedPropName(String propName) {
        this.selectedPropName = propName;
    }
}

