/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules.ui;

import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.report.application.ezreport.reports.codingrules.CSInput;
import com.ez.report.application.ezreport.reports.codingrules.ui.CSInput4GUI;
import com.ez.report.application.ui.collectors.InputsCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSInputCollector
extends InputsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CSInputCollector.class);
    private String appQuery = null;
    private String query = null;

    public void setQuery(String programsQuery) {
        this.query = programsQuery;
    }

    public void setAppQuery(String query) {
        this.appQuery = query;
    }

    public List<BaseResourceInput4GUI> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<CSInput4GUI> resources = null;
        boolean useApps = apps != null && !apps.isEmpty();
        try {
            if (!useApps) {
                String[][] results = conn.executeSQL(this.query);
                resources = new ArrayList<CSInput4GUI>();
                if (results != null && results.length > 0) {
                    if (results[0].length < 3) {
                        L.warn("Input query has invalid format. Expecting results to have 3 columns (id, name, path)");
                    }
                    String[][] stringArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] result = stringArray[n2];
                        CSInput inp = new CSInput(result[0]);
                        if (result.length > 1) {
                            String path = null;
                            if (result.length > 2) {
                                path = result[2];
                            }
                            String listablename = result[1].concat(" (").concat(path == null ? "N/A" : path).concat(")");
                            inp.setListableName(path == null ? result[1] : listablename);
                        }
                        resources.add(new CSInput4GUI(inp));
                        ++n2;
                    }
                }
            }
        }
        catch (EZSourceConnectionException e) {
            resources = null;
            L.error("connection error", (Throwable)e);
            throw new EZSourceConnectionException("sql query exception");
        }
        return resources;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }
}

