/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules.ui;

import com.ez.codingrules.Rule;
import com.ez.codingrules.cobol.CobolRule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;

public class AvailableFilter
extends ViewerFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Set toHide = new HashSet();
    private Set toShow = new HashSet();
    private Set<TreeViewer> viewers = new HashSet<TreeViewer>();

    public boolean isFilterProperty(Object element, String property) {
        return super.isFilterProperty(element, property);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (viewer.getData("AVAILABLE") != null) {
            return !this.toHide.contains(element);
        }
        return this.toShow.contains(element);
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        this.viewers.add((TreeViewer)viewer);
        return super.filter(viewer, parent, elements);
    }

    public void setToHide(List<CobolRule> selected) {
        HashSet<Rule> l;
        Set groupParents;
        Set parents;
        this.toShow.clear();
        this.toShow.addAll(selected);
        for (CobolRule s : selected) {
            parents = s.getParents();
            this.toShow.addAll(parents);
            for (Rule pp : parents) {
                HashSet localGroups = new HashSet();
                groupParents = pp.getParents();
                localGroups.addAll(groupParents);
                while (!localGroups.isEmpty()) {
                    l = new HashSet<Rule>();
                    this.toShow.addAll(localGroups);
                    for (Rule g : localGroups) {
                        l.addAll(g.getParents());
                    }
                    localGroups.clear();
                    localGroups.addAll(l);
                }
            }
        }
        this.toHide.clear();
        this.toHide.addAll(selected);
        for (CobolRule s : selected) {
            parents = s.getParents();
            for (Rule parent : parents) {
                if (!this.toHide.contains(parent) && this.toHide.containsAll(this.getVisibleChildren(parent))) {
                    this.toHide.add(parent);
                }
                HashSet localParents = new HashSet();
                groupParents = parent.getParents();
                localParents.addAll(groupParents);
                while (!localParents.isEmpty()) {
                    l = new HashSet();
                    for (Rule p : localParents) {
                        if (this.toHide.contains(p) || !this.toHide.containsAll(this.getVisibleChildren(p))) continue;
                        this.toHide.add(p);
                        l.add(p);
                    }
                    localParents.clear();
                    localParents.addAll(l);
                }
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (TreeViewer viewer : AvailableFilter.this.viewers) {
                    if (viewer == null) continue;
                    viewer.refresh();
                    viewer.expandAll();
                }
            }
        });
    }

    private Set<Rule> getVisibleChildren(Rule parent) {
        HashSet<Rule> visible;
        Set children = parent.getChildren();
        HashSet<Rule> hashSet = visible = parent.isGroup() && children != null && children.size() > 0 ? new HashSet<Rule>() : null;
        if (visible != null) {
            for (Rule child : children) {
                if (child.isGroup()) {
                    Set<Rule> v = this.getVisibleChildren(child);
                    if (v == null) continue;
                    visible.addAll(v);
                    continue;
                }
                visible.add(child);
            }
        }
        return visible;
    }
}

