/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules;

import com.ez.codingrules.Rule;
import com.ez.codingrules.RuleInput;
import com.ez.common.model.LogMessage;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.codingrules.CSInput;
import com.ez.report.application.ezreport.reports.codingrules.Datasource;
import com.ez.report.application.ezreport.reports.codingrules.ReportModel;
import com.ez.report.application.ezreport.reports.codingrules.RuleBasedUtils;
import com.ez.report.application.ezreport.reports.codingrules.RulesComparator;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC3DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String RULES_FOR_REPORT_KEY = "rulesForReport";
    private static final String PROGRAM_IDS_KEY = "cobPrgIds";
    JasperPrint print;
    private static final String NEWLINE_STRING = "\n";
    private String summary = null;

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
    }

    public IStatus build(IProgressMonitor pmonitor) {
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        BuildWithLock runn = new BuildWithLock();
        try {
            ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pmonitor));
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        return runn.status;
    }

    private IStatus runBuild(EZSourceConnection connection, IProgressMonitor monitor) {
        return super.build(monitor);
    }

    protected String getReportTemplatePath() {
        return "reports/codeStyle.jasper";
    }

    public Map getReportParameters(IProgressMonitor monitor) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.addLocaleParameter(this.parameters);
        boolean isUCMDB = false;
        if (this.pInfo != null) {
            isUCMDB = this.pInfo.isUMCDB();
        } else {
            L.warn("pInfo null for project {}", (Object)this.project);
        }
        Utils.setParamsForTitle((Map)this.parameters, (String)this.project, (boolean)isUCMDB, (Map)this.inputs);
        this.parameters.put("title.appFieldValues", this.applicationsName);
        this.parameters.put("report.title", Messages.getString(ReportBuilder.class, "report.title"));
        this.parameters.put("group1.name", null);
        this.parameters.put("showAppendix", this.getReportModel().getProperty("show appendix"));
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/subBase_impact.jasper", (String)"summarySubreport", (Map)this.parameters);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/codeStyle_details_subreport.jasper", (String)"detailsSubreport", (Map)this.parameters);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/subCols7_links.jasper", (String)"detailsLinesSubreport", (Map)this.parameters);
        return this.parameters;
    }

    protected void initialize(IProgressMonitor monitor) {
        Collection rules = (Collection)this.getReportModel().getProperty("input rules");
        if (rules == null) {
            L.warn("no rules were loaded! initialization of the report is skiped");
            return;
        }
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * rules.size() + 50));
        HashSet rulesForReport = new HashSet();
        HashSet rulesForCVS = new HashSet();
        boolean hasPredefinedRule = RuleBasedUtils.resolveRules((Collection)rules, rulesForReport, rulesForCVS, (Map)this.inputs);
        this.getReportModel().addProperty(RULES_FOR_REPORT_KEY, rulesForReport);
        pmonitor.worked(10 * rulesForReport.size());
        boolean onAllResources = this.getReportModel().useAllResources();
        Collection cobPrgIds = null;
        if (hasPredefinedRule && !onAllResources) {
            List prgList = (List)this.inputs.get("selected resources");
            this.report.setInput((Object)prgList);
            cobPrgIds = this.filterSelectedIDs();
        }
        this.getReportModel().addProperty(PROGRAM_IDS_KEY, cobPrgIds);
        pmonitor.worked(50);
        pmonitor.subTask(Messages.getString(ReportBuilder.class, "exportInCSV.monitor.subtask"));
        List notExported = RuleBasedUtils.exportInCSV(rulesForCVS, (Collection)cobPrgIds, (IProgressMonitor)pmonitor.newChild(rulesForCVS.size() * 10), (Map)this.inputs, (String)this.project, (Queue)this.messages);
        rulesForCVS.removeAll(notExported);
        if (rulesForCVS.size() > 0 || notExported.size() > 0) {
            RulesComparator ruleComparator = new RulesComparator();
            this.summary = null;
            StringBuilder sb = new StringBuilder();
            if (rulesForCVS.size() > 0) {
                ArrayList rulesInFiles = new ArrayList(rulesForCVS);
                Collections.sort(rulesInFiles, ruleComparator);
                sb.append(Messages.getString(ReportBuilder.class, "summary.rulesWrittenInfiles.part"));
                for (Rule r : rulesInFiles) {
                    sb.append("\n\t" + r.getName());
                }
            }
            if (notExported.size() > 0) {
                Collections.sort(notExported, ruleComparator);
                if (sb.length() == 0) {
                    sb.append(Messages.getString(ReportBuilder.class, "summary.rulesNotApplied.startpart"));
                } else {
                    sb.append(Messages.getString(ReportBuilder.class, "summary.rulesNotApplied.part"));
                }
                for (Rule r : notExported) {
                    sb.append("\n\t" + r.getName());
                }
            }
            if (rulesForReport.size() > 0) {
                ArrayList rulesForReportList = new ArrayList(rulesForReport);
                Collections.sort(rulesForReportList, ruleComparator);
                sb.append(Messages.getString(ReportBuilder.class, "summary.rulesInReport.part"));
                for (Rule r : rulesForReportList) {
                    sb.append("\n\t" + r.getName());
                }
            }
            this.summary = sb.toString();
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor monitor) {
        Set rulesForReport = (Set)this.getReportModel().getProperty(RULES_FOR_REPORT_KEY);
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * rulesForReport.size() + 50));
        pmonitor.setTaskName(Messages.getString(ReportBuilder.class, "applyRules.monitor.subtask"));
        boolean onAllResources = this.getReportModel().useAllResources();
        Collection cobPrgIds = (Collection)this.getReportModel().getProperty(PROGRAM_IDS_KEY);
        pmonitor.worked(50);
        if (rulesForReport.isEmpty()) {
            L.info("all rules in csv, so report is canceled");
            this.messages.add(new LogMessage(Messages.getString(ReportBuilder.class, "noPrintedReport.message"), 1, "com.ez.mainframe.reports.core", null));
            throw new CanceledException("all rules in csv, so report is canceled");
        }
        pmonitor.setTaskName(Messages.getString(ReportBuilder.class, "computeResults.monitor.task"));
        Boolean val = (Boolean)this.getReportModel().getProperty("show appendix");
        if (val != null && val.booleanValue()) {
            this.prepareAppendix(rulesForReport);
        }
        this.ds = new Datasource((Collection)rulesForReport, cobPrgIds, onAllResources, (IProgressMonitor)pmonitor.newChild(10 * rulesForReport.size()), this.messages);
        this.parameters.put("summaryDataSource", ((Datasource)this.ds).getSummaryElement());
        this.parameters.put("rules.summary.toc", ((Datasource)this.ds).getSummaryElement().getRulesTOC());
        return this.ds;
    }

    protected Collection filterSelectedIDs() {
        if (this.selectedIds == null) {
            this.selectedIds = new HashSet();
            Collection selectedResources = this.getSelected();
            for (CSInput inpt : selectedResources) {
                String name = inpt.getName();
                try {
                    Integer resId = Integer.parseInt(name);
                    this.selectedIds.add(resId);
                }
                catch (NumberFormatException numberFormatException) {
                    L.warn("param query without resource id");
                }
            }
        }
        return this.selectedIds;
    }

    protected void prepareAppendix(Set rulesForReport) {
        this.parameters.put("showInputs", true);
        HashMap<String, ArrayList<String>> appInfo = new HashMap<String, ArrayList<String>>();
        String ruleWithoutInput = Messages.getString(ReportBuilder.class, "without.input");
        for (Object obj : rulesForReport) {
            Rule rule = (Rule)obj;
            Map ruleinputs = rule.getInputs();
            if (ruleinputs != null) {
                for (RuleInput input : ruleinputs.values()) {
                    String inputkey = input.getKey();
                    String keyFromWizard = RuleBasedUtils.getKeyForSelected((String)inputkey);
                    List selectedInputs = (List)this.inputs.get(keyFromWizard);
                    if (selectedInputs != null) {
                        String key = selectedInputs.toString();
                        ArrayList<String> ruleValues = (ArrayList<String>)appInfo.get(key);
                        String ruleNameToPrint = ReportsUtils.stripNonValidXMLCharacters((String)rule.getName(), (boolean)true);
                        if (ruleValues == null) {
                            ruleValues = new ArrayList<String>();
                            appInfo.put(key, ruleValues);
                        }
                        ruleValues.add(ruleNameToPrint);
                        continue;
                    }
                    L.warn("null inputs for key={}! skip it!", (Object)keyFromWizard);
                }
                continue;
            }
            ArrayList<String> ruleValues = (ArrayList<String>)appInfo.get(ruleWithoutInput);
            String ruleNameToPrint = ReportsUtils.stripNonValidXMLCharacters((String)rule.getName(), (boolean)true);
            if (ruleValues == null) {
                ruleValues = new ArrayList<String>();
                appInfo.put(ruleWithoutInput, ruleValues);
            }
            ruleValues.add(ruleNameToPrint);
        }
        ArrayList tmp = new ArrayList(rulesForReport);
        Collections.sort(tmp, new Comparator<Rule>(){

            @Override
            public int compare(Rule o1, Rule o2) {
                String r1 = ReportsUtils.stripNonValidXMLCharacters((String)o1.getName(), (boolean)true);
                String r2 = ReportsUtils.stripNonValidXMLCharacters((String)o2.getName(), (boolean)true);
                return r1.compareToIgnoreCase(r2);
            }
        });
        ElementGroupInfo ds = new ElementGroupInfo("");
        DSFactory factory = new DSFactory();
        SC3DataSource elemDS = null;
        ArrayList<ObjectForSubreport> objList = null;
        ObjectForSubreport obj = null;
        HashSet printed = new HashSet();
        for (Rule r : tmp) {
            Map ruleinputs;
            String r1 = ReportsUtils.stripNonValidXMLCharacters((String)r.getName(), (boolean)true);
            if (printed.contains(r1) || (ruleinputs = r.getInputs()) == null) continue;
            for (RuleInput input : ruleinputs.values()) {
                String inputkey = input.getKey();
                String keyFromWizard = RuleBasedUtils.getKeyForSelected((String)inputkey);
                List selectedInputs = (List)this.inputs.get(keyFromWizard);
                if (selectedInputs == null) continue;
                String key = selectedInputs.toString();
                List ruleValues = (List)appInfo.remove(key);
                Collections.sort(ruleValues);
                StringBuilder title = new StringBuilder();
                for (String rName : ruleValues) {
                    title.append(rName);
                    title.append(NEWLINE_STRING);
                }
                title.delete(title.length() - 1, title.length());
                printed.addAll(ruleValues);
                elemDS = new SC3DataSource();
                elemDS.setLayout(4);
                objList = new ArrayList();
                elemDS.setList(objList);
                ds.addDataSource((SubreportDataSource)elemDS);
                elemDS.setTitle(title.toString());
                for (CSInput inpt : selectedInputs) {
                    String[] results = new String[]{"", inpt.getListableName()};
                    obj = factory.createObj(1, results, "");
                    objList.add(obj);
                }
            }
        }
        List rulesNoInputs = (List)appInfo.get(ruleWithoutInput);
        if (rulesNoInputs != null && !rulesNoInputs.isEmpty()) {
            elemDS = new SC3DataSource();
            elemDS.setLayout(4);
            objList = new ArrayList<ObjectForSubreport>();
            elemDS.setList(objList);
            ds.addDataSource((SubreportDataSource)elemDS);
            elemDS.setTitle(ruleWithoutInput);
            for (String r : rulesNoInputs) {
                String[] results = new String[]{"", r};
                obj = factory.createObj(1, results, "");
                objList.add(obj);
            }
        }
        this.parameters.put("inputs4Appendix", ds);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/subBase.jasper", (String)"inputs4appendixTemplate", (Map)this.parameters);
    }

    protected void customizeJasperPrint(JasperPrint print) {
        this.print = print;
    }

    protected void moveTableOfContents(JasperPrint jasperPrint) {
        ReportsUtils.moveTableOfContents((JasperPrint)jasperPrint, (boolean)true);
    }

    public JasperPrint getReportDocument() {
        JasperPrint print;
        JasperPrint jasperPrint = print = this.report != null ? this.report.print : null;
        if (print != null) {
            this.report.print.setProperty("pdf_hyperlink_export", "true");
        }
        return print;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.setOwnerInfos(this.inputs);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            Collection allselectedRules = (Collection)this.inputs.get("input rules");
            this.report.addProperty("input rules", (Object)allselectedRules);
            Boolean val = (Boolean)this.inputs.get("show appendix");
            this.report.addProperty("show appendix", (Object)val);
        }
        return this.report;
    }

    public void cleanMemory() {
        this.print = null;
        if (this.ds != null) {
            ((Datasource)this.ds).cleanMemory();
        }
        super.cleanMemory();
    }

    protected void initStopCode(IProgressMonitor monitor) {
        this.stopCode = new StopCode(monitor);
    }

    private class BuildWithLock
    implements IMFRunnable {
        IStatus status;

        private BuildWithLock() {
        }

        public void run(EZSourceConnection conn, IProgressMonitor monitor) {
            this.status = ReportBuilder.this.runBuild(conn, monitor);
        }
    }

    class StopCode
    implements Runnable {
        private IProgressMonitor monitor;

        public StopCode(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void run() {
            if (this.monitor.isCanceled()) {
                L.trace("canceled; before close ds");
                if (ReportBuilder.this.ds != null) {
                    ((Datasource)ReportBuilder.this.ds).closeTransfer();
                }
                L.trace("canceled; after close ds");
                ReportBuilder.this.cleanMemory();
                L.trace("canceled; after clean memory");
                ReportBuilder.this.canceled = true;
                throw new CanceledException("report canceled");
            }
        }
    }
}

