/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.codingrules;

import com.ez.codingrules.Rule;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.codingrules.CodingRulesJob;
import com.ez.report.application.ezreport.reports.codingrules.ui.CodingRulesPage;
import com.ez.report.application.ezreport.reports.codingrules.ui.CodingRulesWizard;
import com.ez.report.application.ezreport.reports.codingrules.ui.CodingRulesWizardDialog;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.viewer.execution.EZReportAnalysis;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class CodingRulesAnalysis
extends EZReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String AVAILABLE_RULES = "available rules";

    public CodingRulesAnalysis() {
        this(null);
    }

    public CodingRulesAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    protected PrepareReportWizard getWizard() {
        CodingRulesWizard wizard = new CodingRulesWizard();
        wizard.setWindowTitle(Messages.getString(CodingRulesAnalysis.class, "wizard.title"));
        String rulesPageName = "No DB resources page";
        String rulesPageTitle = Messages.getString(CodingRulesAnalysis.class, "wizard.rules.page.title");
        String rulesPageDescription = Messages.getString(CodingRulesAnalysis.class, "wizard.rules.page.description");
        CodingRulesPage crPage = new CodingRulesPage(rulesPageName);
        crPage.setTitle(rulesPageTitle);
        crPage.setDescription(rulesPageDescription);
        crPage.setAvailablePropName(AVAILABLE_RULES);
        crPage.setSelectedPropName("input rules");
        wizard.addPage((IWizardPage)crPage);
        return wizard;
    }

    @Override
    protected boolean checkInputs(List inputs) {
        return true;
    }

    protected AbstractAnalysisJob getJob(EZEntityID arg0) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(this.id, CodingRulesJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_RULE_BASED_ANALYSIS;
    }

    @Override
    protected boolean parametersEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = super.parametersEquals(params1, params2);
        if (ret) {
            List lst1 = (List)params1.get("input rules");
            List lst2 = (List)params2.get("input rules");
            ret = lst1 != null ? lst1.equals(lst2) : lst2 == null;
        }
        return ret;
    }

    @Override
    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        CodingRulesWizardDialog dialog = new CodingRulesWizardDialog(shell, (IWizard)wiz);
        return dialog;
    }

    @Override
    protected void completeSelectedPrograms(PrepareReportWizard wizard) {
        List sel = wizard.getList("input rules");
        if (sel != null) {
            HashSet<String> inputNames = new HashSet<String>();
            for (Rule rule : sel) {
                if (!rule.isSourceBased()) continue;
                inputNames.add(rule.getName());
            }
            this.addContextValue("inputs name string", inputNames);
        }
    }
}

