/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.calltree.ddcl;

import com.ez.ddcl.callgraph.ApplicationMasterGraphModel;
import com.ez.ddcl.callgraph.DDCLGraphBuilder;
import com.ez.ddcl.callgraph.nodes.AMBaseNode;
import com.ez.ddcl.callgraph.nodes.AMNodesFactory;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.callgraph.GraphNode;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.calltree.ReportBuilder;
import com.ez.report.application.ezreport.reports.calltree.ddcl.DDCLCalltreeDataSource;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.model.DDCLElementInput;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DDCLCalltreeReportBuilder
extends ReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DDCLCalltreeReportBuilder.class);
    protected Map<Integer, AMBaseNode> inptNodes;
    protected Direction direction;
    private ProjectInfo prjInfo;

    public DDCLCalltreeReportBuilder(String graphDirection) {
        this.report = null;
        this.chainDirection = graphDirection;
        this.runWithLock = false;
        this.summaryChartTitle = Messages.getString(DDCLCalltreeReportBuilder.class, "report.chartTitle");
        this.xAxisLbl = Messages.getString(DDCLCalltreeReportBuilder.class, "chart.xAxis");
        this.yAxisLbl = Messages.getString(DDCLCalltreeReportBuilder.class, "chart.yAxis");
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = this.instantiateReportModel(this.project, this.getSelectionFlagFromInputs());
            List prgList = (List)this.inputs.get("selected resources");
            this.report.setInput((Object)prgList);
            this.report.addProperty("graph direction: forward or backward or both", (Object)this.chainDirection);
            Boolean cgLimited = (Boolean)this.inputs.get("is graph limited");
            if (cgLimited != null && cgLimited.booleanValue()) {
                Integer limit = (Integer)this.inputs.get("limit number for graph levels");
                this.report.addProperty("limit number for graph levels", (Object)limit);
            }
            Boolean continueCG = Boolean.FALSE;
            if (Direction.FORWARD.equals((Object)this.direction) && this.inputs.get("continue with program callgraph") != null) {
                continueCG = (Boolean)this.inputs.get("continue with program callgraph");
            }
            this.report.addProperty("continue with program callgraph", (Object)continueCG);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected abstract AbstractReport instantiateReportModel(String var1, boolean var2);

    protected Collection filterSelectedIDs() {
        if (this.selectedIds == null) {
            this.selectedIds = new HashSet();
            this.inptNodes = new HashMap<Integer, AMBaseNode>();
            Collection selectedResources = this.getSelected();
            for (DDCLElementInput inpt : selectedResources) {
                this.selectedIds.add(inpt.getResourceID());
                String name = inpt.getName();
                Integer typeId = inpt.getTypeCode();
                Integer id = inpt.getResourceID();
                AMBaseNode amInput = AMNodesFactory.createNode((Integer)typeId, (String)name, (Integer)id);
                this.inptNodes.put(id, amInput);
            }
        }
        return this.selectedIds;
    }

    public void setEzProjectInfo(ProjectInfo pInfo) {
        this.prjInfo = pInfo;
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        Collection selected = this.filterSelectedIDs();
        this.parameters.put("report.sum2", new Integer(selected.size()));
        this.csvFile = this.createTempCSVFile();
        this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        Integer graphLimitation = null;
        Boolean cgLimited = (Boolean)this.inputs.get("is graph limited");
        if (cgLimited != null && cgLimited.booleanValue()) {
            graphLimitation = (Integer)this.report.getProperty("limit number for graph levels");
        }
        Boolean doCgOnPrograms = Direction.FORWARD.equals((Object)this.direction) ? (Boolean)this.report.getProperty("continue with program callgraph") : false;
        ApplicationMasterGraphModel graphModel = new ApplicationMasterGraphModel(new AnalysisGraphManager(), this.direction, graphLimitation, false);
        graphModel.setEzsourcePrj(this.prjInfo);
        DDCLGraphBuilder builder = new DDCLGraphBuilder(null, graphModel, this.direction, graphLimitation, false);
        builder.setInputNodes(this.inptNodes);
        builder.setContinueWithPrograms(doCgOnPrograms);
        builder.setContinueWithResources(false);
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        RunWithLock runn = new RunWithLock(builder, (Set)selected);
        try {
            ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, (IProgressMonitor)monitor.newChild(100));
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        Map<Integer, AMBaseNode> nodes = runn.nodes;
        if (!monitor.isCanceled() && nodes != null) {
            graphModel.setInputNodes(nodes);
            this.ds = this.instantiateDS(monitor, nodes, graphModel.getProgramNodes());
        } else {
            L.info("no nodes in DDCL graph");
        }
        monitor.done();
        return this.ds;
    }

    protected DDCLCalltreeDataSource instantiateDS(SubMonitor monitor, Map<Integer, AMBaseNode> nodes, Map<String, GraphNode> cobolNodes) {
        return new DDCLCalltreeDataSource(monitor, this, nodes, cobolNodes);
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(DDCLCalltreeReportBuilder.class, "report.sum2");
        params.put("report.sum2.lbl", externalized);
        externalized = Messages.getString(DDCLCalltreeReportBuilder.class, "report.sum3");
        params.put("report.sum3.lbl", externalized);
        externalized = Messages.getString(DDCLCalltreeReportBuilder.class, "report.sum3.1");
        params.put("report.sum3.1.lbl", externalized);
        externalized = Messages.getString(DDCLCalltreeReportBuilder.class, "report.sum3.2");
        params.put("report.sum3.2.lbl", externalized);
        params.put("group.name", "");
        externalized = Messages.getString(DDCLCalltreeReportBuilder.class, "group.summary.label");
        params.put("group.summary.lbl", externalized);
    }

    @Override
    public void cleanMemory() {
        if (this.inptNodes != null) {
            this.inptNodes.clear();
            this.inptNodes = null;
        }
        super.cleanMemory();
    }

    @Override
    protected String getProcedure() {
        return null;
    }

    @Override
    protected String getSelectiveProcedure() {
        return null;
    }

    public String getChainDirection() {
        return this.chainDirection;
    }

    @Override
    public void writeCSVHeader(CSVWriter csv) {
    }

    class RunWithLock
    implements IMFRunnable {
        DDCLGraphBuilder builder;
        Set<Integer> inputs;
        Map<Integer, AMBaseNode> nodes;

        public RunWithLock(DDCLGraphBuilder builder, Set<Integer> selected) {
            this.builder = builder;
            this.inputs = selected;
        }

        public void run(EZSourceConnection conn, IProgressMonitor monitor) {
            this.nodes = this.builder.buildGraph((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor), this.inputs, conn);
        }
    }
}

