/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.calltree.ddcl;

import com.ez.ddcl.callgraph.ComponentRelationship;
import com.ez.ddcl.callgraph.nodes.AMBaseNode;
import com.ez.ddcl.callgraph.nodes.AMCobol;
import com.ez.mainframe.data.callgraph.GraphNode;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.calltree.DataSource;
import com.ez.report.application.ezreport.reports.calltree.Group;
import com.ez.report.application.ezreport.reports.calltree.ddcl.DDCLCalltreeReportBuilder;
import com.ez.report.application.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDCLCalltreeDataSource
extends DataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DDCLCalltreeDataSource.class);
    List<AMBaseNode> gNodes;
    private String prevElementName = null;
    private String currentGroupName = null;
    Map<String, GraphNode> prgNodes;

    public DDCLCalltreeDataSource(SubMonitor monitor, DDCLCalltreeReportBuilder builder, Map<Integer, AMBaseNode> nodes, Map<String, GraphNode> cobolNodes) {
        super(builder, new ArrayList<Integer>(nodes.keySet()), (IProgressMonitor)monitor, builder.getChainDirection());
        this.prgNodes = cobolNodes;
        this.init(nodes);
    }

    private void init(Map<Integer, AMBaseNode> inputs) {
        this.gNodes = new ArrayList<AMBaseNode>(inputs.values());
        Collections.sort(this.gNodes, new NodeComparator());
    }

    @Override
    protected Group getGroup() {
        if (this.gNodes != null && !this.gNodes.isEmpty()) {
            boolean peekNext = false;
            do {
                AMBaseNode node = this.gNodes.remove(0);
                L.trace("input: {}", (Object)this.getStringToPrint(node.getDisplayName(), node.getAMType().toString()));
                List<String[]> rows = this.buildChains(node);
                if (!rows.isEmpty()) {
                    AMBaseNode nextNode;
                    this.currentGroup = new Group(this.direction);
                    this.currentGroupName = this.currentGroup.prgName = node.getDisplayName();
                    this.currentGroup.type = com.ez.mainframe.data.utils.Utils.getExternalizedType4DDCLComponent((Integer)node.getAMType());
                    this.currentGroup.rows.addAll(rows);
                    AMBaseNode aMBaseNode = nextNode = this.gNodes.isEmpty() ? null : this.gNodes.get(0);
                    if (this.currentGroupName.equalsIgnoreCase(this.prevElementName)) {
                        this.currentGroup.prgName = this.getLongName(this.currentGroup);
                        continue;
                    }
                    if (nextNode == null || !this.currentGroupName.equalsIgnoreCase(nextNode.getDisplayName())) continue;
                    this.currentGroup.prgName = this.getLongName(this.currentGroup);
                    continue;
                }
                this.currentGroup = null;
            } while (peekNext = this.currentGroup == null && !this.gNodes.isEmpty());
        } else {
            this.currentGroup = null;
        }
        return this.currentGroup;
    }

    @Override
    protected void changeGroup() {
        this.prevElementName = this.currentGroup != null ? this.currentGroupName : null;
        super.changeGroup();
    }

    private List<String[]> buildChains(AMBaseNode node) {
        LinkedList<String[]> rows = new LinkedList<String[]>();
        LinkedList<StackObject> toExpand = new LinkedList<StackObject>();
        Stack<StackObject> stack = new Stack<StackObject>();
        toExpand.add(new StackObject(node));
        HashMap<StackObject, Integer> childrenNo = new HashMap<StackObject, Integer>();
        Integer no = null;
        while (!toExpand.isEmpty()) {
            boolean endChain;
            StackObject cNode = (StackObject)toExpand.poll();
            if (!stack.isEmpty()) {
                boolean isRelated = no == null || no > 0;
                boolean ignoreNextDep = false;
                while (!isRelated) {
                    StackObject head = (StackObject)stack.peek();
                    if (head.equals(cNode)) {
                        ignoreNextDep = true;
                    } else if (!ignoreNextDep) {
                        isRelated = no > 0;
                    } else {
                        ignoreNextDep = false;
                        if (!ignoreNextDep) {
                            boolean bl = isRelated = no > 0;
                        }
                    }
                    if (isRelated) continue;
                    no = this.removeFromStack(stack, childrenNo);
                }
            }
            boolean bl = endChain = stack.contains(cNode) || !cNode.hasRelations();
            if (stack.contains(cNode)) {
                L.trace("cycle; chain ends here: {}", (Object)cNode.getName());
            }
            stack.push(cNode);
            if (!endChain) {
                no = (Integer)childrenNo.get(cNode);
                if (no == null) {
                    no = cNode.getFollowingNumber();
                    childrenNo.put(cNode, no);
                }
                this.addChildren(cNode, toExpand);
                continue;
            }
            if (stack.size() <= 1) continue;
            int i = 0;
            int j = 0;
            Object[] entries = new String[stack.size() * 2];
            while (i < stack.size()) {
                StackObject n = (StackObject)stack.get(i);
                String typeToPrint = n.getType();
                entries[j] = this.getStringToPrint(n.getName(), typeToPrint);
                entries[j + 1] = "";
                ++i;
                j += 2;
            }
            L.trace(Arrays.toString(entries));
            rows.add((String[])entries);
            no = this.removeFromStack(stack, childrenNo);
        }
        return rows;
    }

    private Integer removeFromStack(Stack<StackObject> stack, Map<StackObject, Integer> childrenNo) {
        StackObject removed = stack.pop();
        if (removed != null && !stack.contains(removed)) {
            childrenNo.remove(removed);
        }
        removed.clean();
        StackObject h = stack.peek();
        Integer no = childrenNo.get(h);
        int newNo = -1;
        if (no == null) {
            L.warn("no children for {}? {} was just removed from stack", (Object)h, (Object)removed);
            newNo = 0;
        } else {
            newNo = no - 1;
        }
        childrenNo.put(h, newNo);
        removed = null;
        return newNo;
    }

    private String getStringToPrint(String name, String type) {
        return Messages.getString(DDCLCalltreeDataSource.class, "element.stringToPrint", new String[]{name, type});
    }

    private String getLongName(Group gr) {
        return this.getStringToPrint(gr.prgName, gr.type.toLowerCase());
    }

    private void addChildren(StackObject cNode, LinkedList<StackObject> toExpand) {
        List toAdd = cNode.getFollowing();
        Collections.sort(toAdd);
        toExpand.addAll(0, toAdd);
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("prg_name_type")) {
            if (this.currentGroup.prgName.equals(this.prevElementName)) {
                value = this.getLongName(this.currentGroup);
            }
        } else {
            Object val = super.getFieldValue(field);
            value = val != null ? val : null;
        }
        return value;
    }

    @Override
    protected void getFirstElement() {
    }

    @Override
    protected void closeOperation() {
    }

    @Override
    public void clear() {
        if (this.gNodes != null) {
            this.gNodes.clear();
            this.gNodes = null;
        }
        if (this.prgNodes != null) {
            this.prgNodes.clear();
            this.prgNodes = null;
        }
        super.clear();
    }

    class NodeComparator
    implements Comparator<AMBaseNode> {
        NodeComparator() {
        }

        @Override
        public int compare(AMBaseNode arg0, AMBaseNode arg1) {
            int ret = arg0.getName().compareToIgnoreCase(arg1.getName());
            if (ret == 0) {
                ret = arg0.getAMType().compareTo(arg1.getAMType());
            }
            return ret;
        }
    }

    class StackObject
    implements Comparable<StackObject> {
        AMBaseNode ddclNode;
        GraphNode prgNode;
        Boolean prgHasRelations = null;
        List<Object> related = new ArrayList<Object>();
        private Integer no = null;

        public StackObject(AMBaseNode cNode) {
            this.ddclNode = cNode;
            if (cNode == null) {
                L.warn("ddclNode null");
            }
        }

        public StackObject(GraphNode cNode) {
            this.prgNode = cNode;
            if (cNode == null) {
                L.warn("prgNode null");
            }
        }

        private List<StackObject> getFollowing() {
            L.trace("getFollowing() for {}", (Object)this);
            ArrayList<StackObject> lst = new ArrayList<StackObject>();
            if (this.related.isEmpty()) {
                this.fillRelated(lst);
            } else {
                for (Object node : this.related) {
                    if (node instanceof AMBaseNode) {
                        lst.add(new StackObject((AMBaseNode)node));
                        continue;
                    }
                    lst.add(new StackObject((GraphNode)node));
                }
            }
            return lst;
        }

        private void fillRelated(List<StackObject> lst) {
            block10: {
                block9: {
                    GraphNode gNode;
                    L.trace("fillRelated() for {}", (Object)this);
                    if (this.ddclNode == null) break block9;
                    if (this.ddclNode.hasRelations()) {
                        for (ComponentRelationship key : this.ddclNode.getRelationKeys()) {
                            List components = this.ddclNode.getNodes(key);
                            for (AMBaseNode n : components) {
                                if (lst != null) {
                                    lst.add(new StackObject(n));
                                }
                                this.related.add(n);
                            }
                        }
                    }
                    if (DDCLCalltreeDataSource.this.prgNodes == null || !this.continueCallgraph(this.ddclNode) || (gNode = DDCLCalltreeDataSource.this.prgNodes.get(this.ddclNode.getID().toString())) == null) break block10;
                    List children = gNode.getFollowings();
                    for (GraphNode n : children) {
                        if (lst != null) {
                            lst.add(new StackObject(n));
                        }
                        this.related.add(n);
                    }
                    break block10;
                }
                if (this.prgNode != null) {
                    List children = this.prgNode.getFollowings();
                    for (GraphNode n : children) {
                        if (lst != null) {
                            lst.add(new StackObject(n));
                        }
                        this.related.add(n);
                    }
                }
            }
        }

        Integer getFollowingNumber() {
            L.trace("getFollowingNumber() for {}", (Object)this);
            if (this.no == null) {
                this.no = new Integer(0);
                if (this.related.isEmpty()) {
                    this.fillRelated(null);
                }
                this.no = this.related.size();
            }
            return this.no;
        }

        private boolean continueCallgraph(AMBaseNode ddclNode) {
            boolean ret;
            boolean bl = ret = ddclNode != null;
            if (ret) {
                Boolean isSCL = (Boolean)ddclNode.getProperty("is a scl program");
                boolean bl2 = ret = isSCL != null && isSCL != false;
                if (!ret) {
                    ret = ddclNode instanceof AMCobol;
                }
                if (ret) {
                    ret = ddclNode.getID() != null;
                }
            }
            return ret;
        }

        private boolean hasRelations() {
            GraphNode gNode;
            boolean ret;
            boolean bl = ret = this.ddclNode != null ? this.ddclNode.hasRelations() : false;
            if (!ret && DDCLCalltreeDataSource.this.prgNodes != null && this.continueCallgraph(this.ddclNode) && (gNode = DDCLCalltreeDataSource.this.prgNodes.get(this.ddclNode.getID().toString())) != null) {
                List children = gNode.getFollowings();
                boolean bl2 = ret = children != null && !children.isEmpty();
                if (this.related.isEmpty()) {
                    this.related.addAll(children);
                }
            }
            if (this.prgNode != null) {
                if (this.prgHasRelations == null) {
                    List children = this.prgNode.getFollowings();
                    this.prgHasRelations = children != null && !children.isEmpty();
                    if (this.related.isEmpty()) {
                        this.related.addAll(children);
                    }
                }
                ret = this.prgHasRelations;
            }
            L.trace("hasRelations={} for {}", (Object)ret, (Object)this);
            return ret;
        }

        public String getName() {
            return this.ddclNode != null ? this.ddclNode.getDisplayName() : (this.prgNode != null ? this.prgNode.getName() : "null program node");
        }

        public String getType() {
            String type = null;
            if (this.ddclNode != null) {
                Boolean isSCL = (Boolean)this.ddclNode.getProperty("is a scl program");
                type = isSCL != null && isSCL.booleanValue() ? ProgramType.SCL.toString() : (this.ddclNode instanceof AMCobol ? ProgramType.COBOL.toString() : Utils.getExternalizedShortType4DDCLComponent((Integer)this.ddclNode.getAMType()));
            } else {
                Object val = this.prgNode.getProperty("PROGRAM_TYPE_ID");
                if (val != null) {
                    type = com.ez.mainframe.data.utils.Utils.getPrgType((String)((String)val));
                }
            }
            if (type != null) {
                type = type.toLowerCase();
            }
            return type;
        }

        @Override
        public int compareTo(StackObject arg0) {
            int ret = this.getName().compareToIgnoreCase(arg0.getName());
            if (ret == 0) {
                ret = this.getType().compareTo(arg0.getType());
            }
            return ret;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.ddclNode == null ? 0 : this.ddclNode.hashCode());
            result = 31 * result + (this.prgNode == null ? 0 : this.prgNode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StackObject other = (StackObject)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.ddclNode == null ? other.ddclNode != null : !this.ddclNode.equals((Object)other.ddclNode)) {
                return false;
            }
            return !(this.prgNode == null ? other.prgNode != null : !this.prgNode.equals((Object)other.prgNode));
        }

        private DDCLCalltreeDataSource getOuterType() {
            return DDCLCalltreeDataSource.this;
        }

        public String toString() {
            return "StackObject [" + this.getName() + "]";
        }

        void clean() {
            this.related = null;
            this.ddclNode = null;
            this.prgNode = null;
        }
    }
}

