/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.calltree.ddcl;

import com.ez.common.ui.listselection.Listable;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.model.DDCLElementInput;
import com.ez.report.application.ui.collectors.DDCLElementCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.report.application.viewer.execution.EZReportAnalysis;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DDCLCalltreeAnalysis
extends EZReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DDCLCalltreeAnalysis.class);
    protected static final String CONTINUE_PROGRAM_CALLGRAPH = "continue with program callgraph";
    protected String wizardName = "";
    protected boolean isForward = false;

    public DDCLCalltreeAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = null;
        if (wizard == null) {
            wizard = new PrepareReportWizard();
            wizard.setWindowTitle(this.wizardName);
            DDCLChainsWizardPage selectInputsPage = new DDCLChainsWizardPage("programs page", true, this.isForward);
            selectInputsPage.setLeftGroupLabel(Messages.getString(DDCLCalltreeAnalysis.class, "av.wizard.objectType"));
            selectInputsPage.setRightGroupLabel(Messages.getString(DDCLCalltreeAnalysis.class, "sel.wizard.objectType"));
            String filesQuery = "SELECT DDCLElement.Id, DDCLElement.Name, DDCLElement.DdsTypeId FROM DDCLElement WHERE DDCLElement.isLocal='false' AND (\t DDCLElement.DdsTypeId IN (4,11,12,14,16,24,25,26,27,28)\t or (\t\tDDCLElement.DdsTypeId IN (3,10) \t\tand DDCLElement.Name in (\t\t\tselect distinct ElementName from cacheEZViewer_IDMSX_View)\t ) )ORDER BY DDCLElement.DdsTypeId, DDCLElement.Name ";
            DDCLElementCollector pc = new DDCLElementCollector("EZViewer_IDMSX_View");
            pc.setResourcesQuery(filesQuery);
            selectInputsPage.setResourcesCollector((ResourcesCollector)pc);
            wizard.addPage(selectInputsPage);
        }
        return wizard;
    }

    @Override
    protected void processSpecificInput(EZObjectType inpObj, List<EZEntityID> list, List<BaseMainframeResourceInput> sel, Set<String> inputNames) {
        EZObjectType objType = inpObj;
        EZEntityID entity = objType.getEntID();
        list.add(entity);
        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
        if (prjSg != null) {
            EZEntityID entityId;
            if (!prjSg.getProjectName().equals(this.projectName)) {
                this.setPrjName(prjSg.getProjectName());
                this.addContextValue("input_project_names", prjSg.getProjectName());
                ProjectInfo pInfo = prjSg.getProjectInfo();
                com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
            }
            if ((entityId = objType.getEntID()) != null) {
                EZSourceDDCLElementIDSg ddclSg = (EZSourceDDCLElementIDSg)entityId.getSegment(EZSourceDDCLElementIDSg.class);
                if (ddclSg != null) {
                    String name = ddclSg.getName();
                    L.debug("input is an ddcl element {}", (Object)name);
                    Integer type = ddclSg.getType();
                    Integer dbID = ddclSg.getId();
                    sel.add((BaseMainframeResourceInput)new DDCLElementInput(name, type, dbID));
                    inputNames.add(name);
                }
            } else {
                L.debug("resource or ddcl segment id null for: {}", (Object)objType.getName());
            }
        }
    }

    @Override
    protected boolean parametersEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = super.parametersEquals(params1, params2);
        if (ret) {
            Boolean pBool1 = (Boolean)params1.get("is graph limited");
            Boolean pBool2 = (Boolean)params2.get("is graph limited");
            if (pBool1 != null) {
                ret = pBool1.equals(pBool2);
            } else {
                boolean bl = ret = pBool2 == null;
            }
            if (ret) {
                Integer p1 = (Integer)params1.get("limit number for graph levels");
                Integer p2 = (Integer)params2.get("limit number for graph levels");
                if (p1 != null) {
                    ret = p1.equals(p2);
                } else {
                    boolean bl = ret = p2 == null;
                }
                if (ret) {
                    pBool1 = (Boolean)params1.get(CONTINUE_PROGRAM_CALLGRAPH);
                    pBool2 = (Boolean)params2.get(CONTINUE_PROGRAM_CALLGRAPH);
                    ret = pBool1 != null ? pBool1.equals(pBool2) : pBool2 == null;
                }
            }
        }
        return ret;
    }

    @Override
    protected void setParams(List<BaseMainframeResourceInput> selInputs) {
        super.setParams(selInputs);
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        this.params.put("is graph limited", isLimited);
        if (isLimited) {
            int levelLimit = store.getInt("callgraphLimitExceed");
            this.params.put("limit number for graph levels", levelLimit);
        }
        if (this.isForward) {
            this.params.put(CONTINUE_PROGRAM_CALLGRAPH, Boolean.FALSE);
        }
    }

    class DDCLChainsWizardPage<T extends Listable>
    extends SelectProgramsPage<T> {
        private Button btnlimited;
        private Text thresholdLimit;
        private Label thresholdLimitLbl;
        private Button btnContinueCG;
        private boolean analysisIsForward;
        private final String errorMsg;

        public DDCLChainsWizardPage(String pageName, boolean useFilters, boolean isForward) {
            super(pageName, useFilters);
            this.analysisIsForward = false;
            this.errorMsg = Messages.getString(DDCLCalltreeAnalysis.class, "level.thresold.error");
            this.analysisIsForward = isForward;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            composite.setLayoutData((Object)data);
            super.createControl(composite);
            this.createFilteredGroup(composite);
            composite.pack();
            parent.layout();
            this.setControl((Control)composite);
            parent.getShell().setMinimumSize(700, 550);
        }

        private void createFilteredGroup(Composite parent) {
            Composite fakeParent = new Composite(parent, parent.getStyle());
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = false;
            data.horizontalAlignment = 0x1000008;
            data.verticalAlignment = 0x1000008;
            fakeParent.setLayoutData((Object)data);
            GridLayout gl = new GridLayout();
            gl.marginRight = 10;
            fakeParent.setLayout((Layout)gl);
            Group summGroup = new Group(fakeParent, 0);
            summGroup.setText(Messages.getString(DDCLCalltreeAnalysis.class, "generationOptions.lbl"));
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 0x1000008;
            data.verticalAlignment = 0x1000008;
            summGroup.setLayoutData((Object)data);
            gl = new GridLayout(2, false);
            gl.marginWidth = 10;
            gl.marginBottom = 7;
            summGroup.setLayout((Layout)gl);
            if (this.analysisIsForward) {
                this.wizard.set(DDCLCalltreeAnalysis.CONTINUE_PROGRAM_CALLGRAPH, (Object)Boolean.FALSE);
                this.btnContinueCG = new Button((Composite)summGroup, 32);
                this.btnContinueCG.setText(Messages.getString(DDCLCalltreeAnalysis.class, "continueGraphOnPrograms.lbl"));
                this.btnContinueCG.setSelection(false);
                this.btnContinueCG.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        boolean continueCG = DDCLChainsWizardPage.this.btnContinueCG.getSelection();
                        DDCLChainsWizardPage.this.wizard.set(DDCLCalltreeAnalysis.CONTINUE_PROGRAM_CALLGRAPH, (Object)continueCG);
                    }
                });
                data = new GridData();
                data.horizontalSpan = 2;
                this.btnContinueCG.setLayoutData((Object)data);
            }
            IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
            int levelLimit = store.getInt("callgraphLimitExceed");
            boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
            this.wizard.set("is graph limited", (Object)isLimited);
            this.btnlimited = new Button((Composite)summGroup, 32);
            this.btnlimited.setText(Messages.getString(DDCLCalltreeAnalysis.class, "showFiltered.lbl"));
            this.btnlimited.setSelection(isLimited);
            this.btnlimited.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean isCgLimited = DDCLChainsWizardPage.this.btnlimited.getSelection();
                    DDCLChainsWizardPage.this.wizard.set("is graph limited", (Object)isCgLimited);
                    DDCLChainsWizardPage.this.thresholdLimitLbl.setEnabled(isCgLimited);
                    DDCLChainsWizardPage.this.thresholdLimit.setEnabled(isCgLimited);
                    if (isCgLimited) {
                        DDCLChainsWizardPage.this.catchThresholdLimit();
                    } else {
                        DDCLChainsWizardPage.this.wizard.set("limit number for graph levels", null);
                        DDCLChainsWizardPage.this.setErrorMessage(null);
                    }
                }
            });
            data = new GridData();
            data.horizontalSpan = 2;
            this.btnlimited.setLayoutData((Object)data);
            this.thresholdLimitLbl = new Label((Composite)summGroup, 0);
            this.thresholdLimitLbl.setText(Messages.getString(DDCLCalltreeAnalysis.class, "level.threshold.txt"));
            data = new GridData();
            data.grabExcessVerticalSpace = false;
            this.thresholdLimitLbl.setLayoutData((Object)data);
            this.thresholdLimit = new Text((Composite)summGroup, 2048);
            this.thresholdLimit.setText("" + levelLimit);
            this.wizard.set("limit number for graph levels", (Object)(isLimited ? Integer.valueOf(levelLimit) : null));
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.minimumWidth = 120;
            this.thresholdLimit.setLayoutData((Object)data);
            this.thresholdLimit.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DDCLChainsWizardPage.this.catchThresholdLimit();
                    DDCLChainsWizardPage.this.setPageComplete(DDCLChainsWizardPage.this.isPageComplete());
                }
            });
            this.thresholdLimitLbl.setEnabled(isLimited);
            this.thresholdLimit.setEnabled(isLimited);
            if (isLimited) {
                this.catchThresholdLimit();
            }
        }

        private void catchThresholdLimit() {
            block6: {
                String text = this.thresholdLimit.getText();
                Integer threshold = null;
                try {
                    try {
                        threshold = Integer.valueOf(text);
                        if (threshold < 0) {
                            this.setErrorMessage(this.errorMsg);
                            break block6;
                        }
                        this.setErrorMessage(null);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setErrorMessage(this.errorMsg);
                        this.wizard.set("limit number for graph levels", (Object)threshold);
                    }
                }
                finally {
                    this.wizard.set("limit number for graph levels", (Object)threshold);
                }
            }
        }
    }
}

