/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.calltree;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.calltree.DataSource;
import com.ez.report.application.ezreport.reports.calltree.EZXYLabelItemGenerator;
import com.ez.report.application.ezreport.reports.calltree.EZXYZDataset;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.all.EZNumberAxis;
import com.ez.report.application.reports.all.EZNumberTickUnit;
import com.ez.report.application.reports.calltree.Holder;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    protected static final String BACKWARD_CHAIN_DIRECTION = " <- ";
    protected static final String FORWARD_CHAIN_DIRECTION = " -> ";
    public Holder h;
    protected Font tickFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)8, (boolean)false);
    protected Font labelFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)10, (boolean)false);
    protected Font titleFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)14, (boolean)true);
    protected String yAxisLbl;
    protected String xAxisLbl;
    protected String summaryChartTitle;
    protected String chainDirection;
    protected boolean openTransaction = false;
    protected boolean considerToFilterSCL = false;
    protected boolean runWithLock = true;
    protected SC1DataSource appendixNote = null;
    protected boolean addLimitNoteInAppendix = false;
    protected boolean addNameRestrictionNoteInAppendix = false;
    protected boolean markOnlyExpandable = false;

    protected abstract String getProcedure();

    protected abstract String getSelectiveProcedure();

    public Collection getFilteredIds() {
        return super.filterSelectedIDs();
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        params.put("summary", params.get("report.summary"));
        params.put("detail", params.get("report.details"));
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    public Map getReportParameters(IProgressMonitor monitor) {
        this.addLocaleParameter(this.parameters);
        this.putExternalizedParameters(this.parameters);
        this.h = new Holder();
        this.parameters.put("holder", this.h);
        return this.parameters;
    }

    protected abstract void putExternalizedParameters(Map var1);

    protected String getReportTemplatePath() {
        return "reports/calledTrees.jasper";
    }

    protected JFreeChart createScatterPlot(String title, String xAxisLabel, String yAxisLabel, XYDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        EZNumberAxis xAxis = new EZNumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        xAxis.setAutoTickUnitSelection(false);
        xAxis.setLowerMargin(0.1);
        xAxis.setLabelFont(this.labelFont);
        xAxis.setTickLabelFont(this.tickFont);
        List values = ((EZXYZDataset)dataset).getXValues();
        Collections.sort(values);
        Integer minVal = (Integer)values.get(0);
        Integer maxVal = (Integer)values.get(values.size() - 1);
        int range = maxVal - minVal;
        L.info("range of values={}(min={}, max={})", new Object[]{range, minVal, maxVal});
        Locale loc = Locale.getDefault();
        L.debug("locale: {}", (Object)loc);
        NumberFormat format = NumberFormat.getIntegerInstance(loc);
        format.setParseIntegerOnly(true);
        format.setGroupingUsed(false);
        if (range > 20) {
            xAxis.setTickUnit((NumberTickUnit)new EZNumberTickUnit(1.0, format, values));
        } else {
            xAxis.setTickUnit(new NumberTickUnit(1.0, format));
        }
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setAutoRangeIncludesZero(false);
        yAxis.setAutoTickUnitSelection(false);
        yAxis.setTickUnit(new NumberTickUnit(1.0, NumberFormat.getIntegerInstance()));
        yAxis.setUpperMargin(0.1);
        yAxis.setLowerMargin(0.1);
        yAxis.setLabelFont(this.labelFont);
        yAxis.setTickLabelFont(this.tickFont);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setForegroundAlpha(0.65f);
        StandardXYToolTipGenerator toolTipGenerator = null;
        if (tooltips) {
            toolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator urlGenerator = null;
        if (urls) {
            urlGenerator = new StandardXYURLGenerator();
        }
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true);
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
        renderer.setURLGenerator((XYURLGenerator)urlGenerator);
        renderer.setItemLabelFont(this.tickFont);
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setOrientation(orientation);
        if (range < 200) {
            renderer.setItemLabelGenerator((XYItemLabelGenerator)new EZXYLabelItemGenerator());
            renderer.setItemLabelsVisible(true);
        }
        renderer.setShape((Shape)new Ellipse2D.Double(-6.0, -6.0, 12.0, 12.0));
        JFreeChart chart = new JFreeChart(title, this.titleFont, (Plot)plot, legend);
        return chart;
    }

    public void cleanMemory() {
        this.cleanDataSource();
        this.h = null;
        this.appendixNote = null;
        this.labelFont = null;
        this.tickFont = null;
        this.titleFont = null;
        super.cleanMemory();
    }

    protected void cleanDataSource() {
        if (this.ds != null) {
            ((DataSource)this.ds).clear();
            this.ds = null;
        }
    }

    public void noMoreData() {
        EZXYZDataset dataset = (EZXYZDataset)((DataSource)this.ds).getDistributionDataset();
        if (!dataset.isEmpty()) {
            JFreeChart jfreechart = this.createScatterPlot(this.summaryChartTitle, this.xAxisLbl, this.yAxisLbl, (XYDataset)dataset, PlotOrientation.VERTICAL, false, false, false);
            jfreechart.setBackgroundPaint((Paint)Color.white);
            BufferedImage img = jfreechart.createBufferedImage(1040, 700, 520.0, 350.0, null);
            this.h.setImage(img);
            dataset.clear();
        }
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.parameters.put("report.sum2", new Integer(prgList.size()));
        this.csvFile = this.createTempCSVFile();
        this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        Collection selected = this.filterSelectedIDs(pmonitor);
        this.instantiateDS(pmonitor, selected);
        ((DataSource)this.ds).openTransaction = this.openTransaction;
        ((DataSource)this.ds).considerToFilterSCL = this.considerToFilterSCL;
        ((DataSource)this.ds).useAncestorFunction = this.useFunction();
        Set apps = (Set)this.getReportModel().getProperty("selected app names");
        if (apps != null) {
            this.setApplicationName(apps);
        }
        this.parameters.put("title.appFieldValues", this.applicationsName);
        return this.ds;
    }

    protected void instantiateDS(IProgressMonitor pmonitor, Collection selected) {
        this.ds = new DataSource(this, selected, pmonitor, this.chainDirection);
    }

    protected boolean useFunction() {
        return true;
    }

    protected boolean hasSCL(EZSourceConnection conn) {
        return false;
    }

    protected void initStopCode(IProgressMonitor monitor) {
        this.stopCode = new StopCode(monitor);
    }

    public String getProject() {
        return this.project;
    }

    protected JasperPrint prepareDocument(JasperReport jReport, Map params, JRDataSource ds, IProgressMonitor monitor, IStatus status) {
        if (this.runWithLock) {
            IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
            RunWithLock runn = new RunWithLock(jReport, params, ds, monitor, status);
            try {
                ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, monitor);
            }
            catch (InterruptedException interruptedException) {
                throw new CanceledException("connection interrupted");
            }
            catch (ExecutionException e) {
                ErrorUtils.handleExecutionException((ExecutionException)e);
            }
            return runn.print;
        }
        return super.prepareDocument(jReport, params, ds, monitor, status);
    }

    JasperPrint prepDocument(JasperReport jReport, Map params, JRDataSource ds, EZSourceConnection conn, IProgressMonitor monitor, IStatus status) {
        ((DataSource)this.ds).setConnection(conn);
        ((DataSource)ds).hasSCL = this.hasSCL(conn);
        return super.prepareDocument(jReport, params, ds, monitor, status);
    }

    public void writeCSVHeader(CSVWriter csv) {
    }

    public static void fillAppendixDS4Notes(SC1DataSource ds, boolean addLimitNoteInAppendix, boolean markOnlyExpandable, boolean addNameRestrictionNoteInAppendix) {
        ObjectForSubreport obj;
        ds.setExtraTitle(Messages.getString(ReportBuilder.class, "appendix.datasource.notes.title"));
        ds.setLayout(6);
        ArrayList<ObjectForSubreport> list = new ArrayList<ObjectForSubreport>();
        if (addLimitNoteInAppendix) {
            obj = new ObjectForSubreport();
            obj.setExp(" *");
            obj.setExpVal(Utils.getLevelLimitNoteText((boolean)markOnlyExpandable));
            list.add(obj);
        }
        if (addNameRestrictionNoteInAppendix) {
            obj = new ObjectForSubreport();
            obj.setExp(" !");
            obj.setExpVal(Utils.getPatternNameLimitText());
            list.add(obj);
        }
        ds.setList(list);
    }

    public static SC1DataSource buildAppendixDS4Notes(DSFactory factory, boolean addLimitNoteInAppendix, boolean markOnlyExpandable, boolean addNameRestrictionNoteInAppendix) {
        SC1DataSource dataSource = (SC1DataSource)factory.createDS(3);
        ReportBuilder.fillAppendixDS4Notes(dataSource, addLimitNoteInAppendix, markOnlyExpandable, addNameRestrictionNoteInAppendix);
        return dataSource;
    }

    public void addLimitNoteInAppendix(boolean add) {
        this.addLimitNoteInAppendix = add;
    }

    public void addNameRestrictionNoteInAppendix(boolean add) {
        this.addNameRestrictionNoteInAppendix = add;
    }

    public boolean isMarkOnlyExpandable() {
        return this.markOnlyExpandable;
    }

    class RunWithLock
    implements IMFRunnable {
        JasperPrint print;
        AbstractReportBuilder builder;
        JasperReport jReport;
        Map params;
        JRDataSource ds;
        IProgressMonitor monitor;
        IStatus status;

        public RunWithLock(JasperReport jReport, Map params, JRDataSource ds, IProgressMonitor monitor, IStatus status) {
            this.jReport = jReport;
            this.params = params;
            this.ds = ds;
            this.monitor = monitor;
            this.status = status;
        }

        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
            this.print = ReportBuilder.this.prepDocument(this.jReport, this.params, this.ds, conn, this.monitor, this.status);
        }
    }

    class StopCode
    implements Runnable {
        private IProgressMonitor monitor;

        public StopCode(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void run() {
            if (this.monitor.isCanceled()) {
                L.trace("canceled; before close handler");
                if (ReportBuilder.this.ds != null) {
                    ReportBuilder.this.ds.closeDatasource();
                }
                L.trace("canceled; after close handler");
                ReportBuilder.this.cleanMemory();
                L.trace("canceled; after clean memory");
                ReportBuilder.this.canceled = true;
                throw new CanceledException("report canceled");
            }
        }
    }
}

