/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.calltree;

import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Group {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected String direction;
    public String prgName;
    public int index = 0;
    public List rows = new LinkedList();
    public String type;

    public Group(String direction) {
        this.direction = direction;
    }

    public boolean isParsed() {
        return this.index == this.rows.size() - 1;
    }

    public String getRowAsString() {
        StringBuffer buf = new StringBuffer();
        String[] row = this.getRow();
        String pName = row[0];
        String parentName = row[1];
        pName = parentName != null && !parentName.isEmpty() ? String.valueOf(parentName) + ": " + pName : pName;
        buf.append(pName);
        int i = 2;
        while (i < row.length) {
            pName = row[i];
            if (pName == null) break;
            parentName = row[i + 1];
            pName = parentName != null && !parentName.isEmpty() ? String.valueOf(parentName) + ": " + pName : pName;
            buf.append(this.direction).append(pName);
            i += 2;
        }
        String s = buf.toString();
        return ReportsUtils.stripNonValidXMLCharacters((String)s, (boolean)true);
    }

    public List<String> getRowAsList() {
        String[] row = this.getRow();
        ArrayList<String> rowAsList = new ArrayList<String>();
        String pName = row[0];
        String parentName = row[1];
        pName = parentName != null && !parentName.isEmpty() ? String.valueOf(parentName) + ": " + pName : pName;
        rowAsList.add(pName);
        int i = 2;
        while (i < row.length) {
            pName = row[i];
            if (pName == null) break;
            parentName = row[i + 1];
            pName = parentName != null && !parentName.isEmpty() ? String.valueOf(parentName) + ": " + pName : pName;
            rowAsList.add(pName);
            i += 2;
        }
        return rowAsList;
    }

    protected String[] getRow() {
        return (String[])this.rows.get(this.index);
    }

    private String[] peekRow(int delta) {
        String[] row = null;
        try {
            row = (String[])this.rows.get(this.index + delta);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return row;
    }

    public void selectRow() {
        String[] row = this.getRow();
        int delta = 1;
        while (true) {
            String[] nextRow;
            if (!this.subchain(row, nextRow = this.peekRow(delta))) {
                this.index += delta - 1;
                break;
            }
            row = nextRow;
            ++delta;
        }
    }

    boolean subchain(String[] row1, String[] row2) {
        boolean ret = false;
        if (row1 == null || row2 == null) {
            ret = false;
        } else {
            ret = true;
            int i = 0;
            while (i < row1.length) {
                if (row1[i] != null && !row1[i].equals(row2[i])) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    public void clear() {
        this.rows.clear();
        this.rows = null;
    }
}

