/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.calltree;

import com.ez.report.application.reports.all.EZXYDataset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZXYZDataset
extends EZXYDataset {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(EZXYZDataset.class);
    Map<String, Integer> zValues = new HashMap<String, Integer>();

    public void addData(EZXYDataset.PlotGroup group) {
        super.addData(group);
        String key = group.getKey();
        Integer size = this.zValues.get(key);
        if (size == null) {
            this.zValues.put(key, new Integer(1));
        } else {
            this.zValues.put(key, new Integer(size + 1));
        }
    }

    public Number getZ(int series, int item) {
        EZXYDataset.PlotGroup plotGroup = (EZXYDataset.PlotGroup)this.data.get(item);
        String key = plotGroup.getKey();
        Integer size = this.zValues.get(key);
        if (size == null) {
            L.warn("no size for plotgroup: {}", (Object)plotGroup);
        }
        L.debug("Zvalue for {}: {}", (Object)key, (Object)size);
        return size;
    }

    public double getZValue(int series, int item) {
        return this.getZ(series, item).doubleValue();
    }

    public void clear() {
        if (this.zValues != null) {
            this.zValues.clear();
            this.zValues = null;
        }
    }
}

