/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.calltree;

import com.ez.common.model.BaseResourceInput;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.NonBlockingOperationHandle;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.calltree.EZXYZDataset;
import com.ez.report.application.ezreport.reports.calltree.Group;
import com.ez.report.application.ezreport.reports.calltree.ReportBuilder;
import com.ez.report.application.reports.all.EZXYDataset;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jfree.data.xy.XYZDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSource
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DataSource.class);
    protected Group currentGroup = null;
    protected EZXYZDataset xydataset = new EZXYZDataset();
    protected List programs = null;
    protected Set calledPrograms = new HashSet();
    protected List resultPool = new LinkedList();
    protected IProgressMonitor monitor;
    protected int nrChain = 0;
    protected int maxLength = 1;
    protected int max = 1;
    protected int nrPrgs = 0;
    protected int i = 0;
    protected boolean queryOk = false;
    protected NonBlockingOperationHandle handler;
    protected EZSourceConnection bridge;
    protected String direction;
    protected ReportBuilder builder;
    protected int nrRows = 40;
    protected boolean openTransaction = false;
    boolean considerToFilterSCL = false;
    boolean hasSCL = false;
    private String tempTableName = "calling_string_param_temp";
    boolean useAncestorFunction = true;
    private String callTempTable;
    protected CSVWriter csvWriter;

    public DataSource(ReportBuilder builder, Collection programs, IProgressMonitor pmonitor, String chainDirection) {
        this.builder = builder;
        this.programs = new ArrayList(programs);
        this.queryOk = true;
        this.monitor = pmonitor;
        this.direction = chainDirection;
        this.csvWriter = this.builder.initTempCSVFile();
        this.builder.writeCSVHeader(this.csvWriter);
    }

    public Object getFieldValue(JRField arg0) throws JRException {
        Object value = null;
        if (arg0.getName().equals("prg_name")) {
            value = this.currentGroup.prgName;
        } else if (arg0.getName().equals("chain")) {
            value = this.currentGroup.getRowAsString();
            this.writeRowToCSV();
        } else if (arg0.getName().equals("count")) {
            value = Boolean.TRUE;
        }
        L.debug("fieldName: {} = ({}) {}", new Object[]{arg0.getName(), this.currentGroup.prgName, value});
        return value;
    }

    protected void writeRowToCSV() {
        if (this.csvWriter != null) {
            this.csvWriter.write(this.currentGroup.getRowAsList().toArray(new String[0]));
        }
    }

    public XYZDataset getDistributionDataset() {
        return this.xydataset;
    }

    public void clear() {
        if (this.calledPrograms != null) {
            this.calledPrograms.clear();
            this.calledPrograms = null;
        }
        if (this.currentGroup != null) {
            this.currentGroup.clear();
            this.currentGroup = null;
        }
        if (this.programs != null) {
            this.programs.clear();
            this.programs = null;
        }
        if (this.resultPool != null) {
            this.resultPool.clear();
            this.resultPool = null;
        }
        if (this.xydataset != null) {
            this.xydataset.clear();
            this.xydataset = null;
        }
    }

    protected EZXYDataset.PlotGroup getPlotGroup(Group group) {
        EZXYZDataset eZXYZDataset = this.xydataset;
        ((Object)((Object)eZXYZDataset)).getClass();
        EZXYDataset.PlotGroup gr = new EZXYDataset.PlotGroup((EZXYDataset)eZXYZDataset, group.prgName);
        gr.nrChain = this.nrChain;
        gr.maxDeep = this.maxLength;
        L.debug("groupPlot: {} :: maxDeep - {}; chains: {}", new Object[]{gr.prgName, gr.maxDeep, gr.nrChain});
        return gr;
    }

    protected boolean getData() {
        List rows = null;
        if (rows == null && this.handler.dataAvailable()) {
            L.debug("get more data");
            this.monitor.subTask(Messages.getString(DataSource.class, "monitor.getMoreData.subtask"));
            rows = this.handler.getAvailableData();
        }
        if (rows != null) {
            int i = 0;
            while (i < rows.size()) {
                int columns = 18;
                String[] oldRow = (String[])rows.get(i);
                String[] row = new String[columns];
                int k = 0;
                while (k < columns) {
                    row[k] = Utils.filterNullValue((String)oldRow[k]) == null ? null : oldRow[k];
                    ++k;
                }
                this.resultPool.add(row);
                ++i;
            }
        }
        return rows != null;
    }

    protected Group getGroup() {
        boolean groupComplete = false;
        Group group = null;
        boolean moreData = true;
        while (!groupComplete) {
            if (this.resultPool.size() == 0) {
                moreData = this.getData();
            }
            if (this.resultPool.size() > 0) {
                String[] entries = (String[])this.resultPool.get(0);
                String prgName = entries[0];
                String parentName = entries[1];
                if (parentName != null && !parentName.isEmpty()) {
                    prgName = parentName;
                }
                if (group == null) {
                    group = new Group(this.direction);
                    group.prgName = prgName;
                }
                if (prgName.equals(group.prgName)) {
                    this.resultPool.remove(0);
                    group.rows.add(entries);
                } else {
                    groupComplete = true;
                }
            }
            if (moreData) continue;
            groupComplete = true;
        }
        return group;
    }

    public boolean nextItem() throws JRException {
        if (!this.queryOk) {
            return false;
        }
        if (this.i == 0) {
            this.monitor.subTask(Messages.getString(DataSource.class, "monitor.getFirstData.subtask"));
            this.getFirstElement();
        }
        this.monitor.subTask(Messages.getString(DataSource.class, "monitor.preparingData.subtask"));
        if (this.currentGroup == null || this.currentGroup.isParsed()) {
            if (this.currentGroup != null && this.currentGroup.isParsed()) {
                this.calledPrograms.add(this.currentGroup.prgName);
                this.xydataset.addData(this.getPlotGroup(this.currentGroup));
            }
            this.changeGroup();
            try {
                this.currentGroup = this.getGroup();
                if (this.currentGroup != null) {
                    L.debug("new group: {} : {} row(s): {}", new Object[]{this.currentGroup.prgName, this.currentGroup.rows.size(), this.currentGroup.rows});
                }
            }
            catch (EZSourceNativeException e) {
                L.error("getGroup()", (Throwable)e);
            }
        } else {
            ++this.currentGroup.index;
        }
        if (this.currentGroup != null) {
            this.monitor.subTask(Messages.getString(DataSource.class, "monitor.preparingData4Group.subtask", new String[]{this.currentGroup.prgName}));
            this.currentGroup.selectRow();
            ++this.nrChain;
            String[] currentRow = (String[])this.currentGroup.rows.get(this.currentGroup.index);
            L.debug("currentGroup.index={}; currentRow={}", (Object)this.currentGroup.index, (Object)currentRow);
            int length = currentRow.length;
            String val = currentRow[length - 2];
            if (val != null) {
                length -= 2;
            }
            while (val == null) {
                val = currentRow[length -= 2];
            }
            if (length > this.maxLength * 2) {
                this.maxLength = length / 2;
                if (this.maxLength > this.max) {
                    this.max = this.maxLength;
                    this.nrPrgs = 1;
                } else if (this.maxLength == this.max) {
                    ++this.nrPrgs;
                }
            }
        } else {
            L.debug("currentGroup is NULL");
            if (this.bridge != null && this.handler.finished()) {
                this.closeOperation();
            }
            if (this.hasSCL) {
                Utils.cleanTable((EZSourceConnection)this.bridge, (String)this.tempTableName);
                Utils.dropTempTable((EZSourceConnection)this.bridge, (String)this.tempTableName);
                L.debug("clear SCL procs table");
            }
            this.monitor.subTask(Messages.getString(DataSource.class, "monitor.finishData.subtask"));
            this.builder.noMoreData();
            this.addFinalParams();
            if (this.csvWriter != null) {
                this.csvWriter.close();
            }
        }
        return this.currentGroup != null;
    }

    protected void changeGroup() {
        this.currentGroup = null;
        this.nrChain = 0;
        this.maxLength = 1;
    }

    protected void addFinalParams() {
        if (this.programs == null || this.programs.isEmpty()) {
            this.builder.h.setMax(new Integer(0));
            this.builder.h.setPrgs(new Integer(0));
            this.builder.h.setNotCalled(new Integer(0));
        } else {
            this.builder.h.setMax(new Integer(this.max));
            if (this.max == 1) {
                int noCalledPrgs = this.calledPrograms.size();
                this.builder.h.setPrgs(new Integer(noCalledPrgs));
                if (noCalledPrgs == 0) {
                    this.builder.h.setMax(new Integer(0));
                }
            } else {
                this.builder.h.setPrgs(new Integer(this.nrPrgs));
            }
            int notCalled = this.getNotCallednumber();
            this.builder.h.setNotCalled(new Integer(notCalled));
        }
    }

    protected int getNotCallednumber() {
        int notCalled = 0;
        Collection prgs = (Collection)this.builder.getReportModel().getProperty("inputs");
        for (BaseResourceInput inpt : prgs) {
            String prg = inpt.getName();
            boolean isCalled = this.calledPrograms.contains(prg);
            if (inpt instanceof ProgramInputNoGUI && (15 == inpt.getTypeCode() || 16 == inpt.getTypeCode())) {
                isCalled = this.calledPrograms.contains(((ProgramInputNoGUI)inpt).getAncestorName());
            }
            if (isCalled) continue;
            L.debug("program {} is not called!", (Object)prg);
            ++notCalled;
        }
        return notCalled;
    }

    protected void getFirstElement() {
        block12: {
            String[] procParam = new String[]{};
            EZSourceConnectionException ex = null;
            try {
                try {
                    if (this.considerToFilterSCL && this.hasSCL) {
                        Utils.createTempTable((EZSourceConnection)this.bridge, (String)this.tempTableName);
                        com.ez.report.application.ezreport.utils.Utils.insertSCLProcs(this.bridge, this.tempTableName);
                    }
                    L.trace("after consider SCL");
                    if (this.openTransaction) {
                        L.trace("before begin transaction");
                        this.bridge.beginTransaction();
                        L.trace("after begin transaction");
                        this.callTempTable = com.ez.report.application.ezreport.utils.Utils.createCallingTempTable(this.bridge, L);
                    }
                    if (this.builder.getReportModel().useAllResources()) {
                        String proc = this.builder.getProcedure();
                        Assert.isNotNull((Object)proc);
                        this.handler = this.bridge.beginNonTransactionalStoredProc(proc, procParam, this.nrRows);
                        L.debug("queryForDataAsync() after execStoredProcAsync() for all resources");
                    } else {
                        Collection selected = this.builder.getFilteredIds();
                        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[selected.size()]);
                        Collections.fill(types, EZSourceDataType.Integer);
                        String selectiveProc = this.builder.getSelectiveProcedure();
                        Assert.isNotNull((Object)selectiveProc);
                        this.handler = this.bridge.beginNonTransactionalStoredProc(selectiveProc, procParam, types, new ArrayList(selected), this.nrRows);
                        L.debug("queryForDataAsync() after execStoredProcAsync() for {} resources", (Object)selected.size());
                    }
                    L.trace("after getting handler");
                }
                catch (EZSourceConnectionException e) {
                    L.error("exception at getting first element of datasource", (Throwable)e);
                    EZReportErrorLog.err(Messages.getString(DataSource.class, "storedProcedureError.logMessage"), e);
                    ex = e;
                    L.trace("begin finally");
                    if (this.bridge != null && (ex != null || this.handler.finished())) {
                        this.closeOperation();
                    }
                    L.trace("end finally");
                    break block12;
                }
            }
            catch (Throwable throwable) {
                L.trace("begin finally");
                if (this.bridge != null && (ex != null || this.handler.finished())) {
                    this.closeOperation();
                }
                L.trace("end finally");
                throw throwable;
            }
            L.trace("begin finally");
            if (this.bridge != null && (ex != null || this.handler.finished())) {
                this.closeOperation();
            }
            L.trace("end finally");
        }
        this.i = 1;
    }

    public void closeDatasource() {
        this.closeOperation();
    }

    protected void closeOperation() {
        L.trace("begin of closeOp");
        if (this.handler != null) {
            this.handler.close();
            L.trace("after close handler");
        }
        if (this.openTransaction) {
            String delQ = String.format("delete from %s", this.callTempTable);
            this.bridge.executeUpdate(delQ);
            L.trace("after delete temp {} table", (Object)this.callTempTable);
            this.bridge.endTransaction();
            L.trace("after end transaction");
        }
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
    }

    public void setConnection(EZSourceConnection conn) {
        this.bridge = conn;
    }
}

