/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.aauto.networkdependency;

import com.ez.mainframe.model.Direction;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import com.ez.report.application.ui.wizard.AbstractWizardPage;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectOptionsForNetwPage
extends AbstractWizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Text thresholdLimit;
    private Button limitButton;
    private Button backwardButton;
    private Button forwardButton;

    public SelectOptionsForNetwPage(String pageName) {
        super(pageName);
        this.showReportsOptionGroup = true;
        this.showInputsOption = true;
        this.optionValue = PreferenceUtils.getPreferenceStore().getBoolean("showInputDetails");
    }

    protected boolean getShowAppendixValue() {
        Boolean showAppendix = PreferenceUtils.getPreferenceStore().getBoolean("showAppendix");
        return showAppendix;
    }

    protected void createContent(Composite composite) {
        Composite parentComposite = new Composite(composite, composite.getStyle());
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalIndent = 35;
        parentComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        parentComposite.setLayout((Layout)gridLayout);
        Group reportOptionsGroup = this.getReportOptionsGroup(parentComposite);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        reportOptionsGroup.getParent().setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        reportOptionsGroup.getParent().setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        reportOptionsGroup.setLayoutData((Object)gridData);
        Composite fakeParent = new Composite((Composite)reportOptionsGroup, reportOptionsGroup.getStyle());
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalSpan = 2;
        data.horizontalAlignment = 1;
        data.verticalAlignment = 1;
        data.horizontalIndent = -5;
        fakeParent.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, false);
        gl.marginRight = 5;
        fakeParent.setLayout((Layout)gl);
        this.createDirectionGroup(fakeParent);
        this.createLimitGroup(fakeParent);
        composite.getShell().setMinimumSize(500, 300);
    }

    protected void addShowAppendixOptions(Composite optionsGroup) {
        this.defaultAddAppendixOptions(optionsGroup);
    }

    private void createLimitGroup(Composite parent) {
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isLimited = SelectOptionsForNetwPage.this.limitButton.getSelection();
                SelectOptionsForNetwPage.this.thresholdLimit.setEnabled(isLimited);
                if (isLimited) {
                    SelectOptionsForNetwPage.this.catchThresholdLimit();
                } else {
                    SelectOptionsForNetwPage.this.wizard.set("limitLevel", (Object)-1);
                    SelectOptionsForNetwPage.this.setErrorMessage(null);
                }
                SelectOptionsForNetwPage.this.setPageComplete(SelectOptionsForNetwPage.this.isPageComplete());
            }
        };
        this.limitButton = new Button(parent, 32);
        GridData data = new GridData();
        data.verticalAlignment = 1024;
        data.horizontalSpan = 2;
        this.limitButton.setLayoutData((Object)data);
        this.limitButton.addSelectionListener((SelectionListener)selectionListener);
        this.limitButton.setText(Messages.getString(SelectOptionsForNetwPage.class, "limit.lbl"));
        this.limitButton.setSelection(isLimited);
        this.thresholdLimit = new Text(parent, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.minimumWidth = 120;
        this.thresholdLimit.setLayoutData((Object)data);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectOptionsForNetwPage.this.catchThresholdLimit();
                SelectOptionsForNetwPage.this.setPageComplete(SelectOptionsForNetwPage.this.isPageComplete());
            }
        });
        this.thresholdLimit.setEnabled(isLimited);
        if (isLimited) {
            this.catchThresholdLimit();
        } else {
            this.wizard.set("limitLevel", (Object)-1);
        }
    }

    private void catchThresholdLimit() {
        block8: {
            String text = this.thresholdLimit.getText();
            String errorMsg = Messages.getString(SelectOptionsForNetwPage.class, "level.thresold.error");
            Integer newThreshold = null;
            try {
                try {
                    newThreshold = Integer.valueOf(text);
                    if (newThreshold <= 0) {
                        this.setErrorMessage(errorMsg);
                        newThreshold = null;
                        break block8;
                    }
                    this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsg);
                    if (newThreshold != null) {
                        this.wizard.set("limitLevel", (Object)newThreshold);
                    }
                }
            }
            finally {
                if (newThreshold != null) {
                    this.wizard.set("limitLevel", (Object)newThreshold);
                }
            }
        }
    }

    protected void checkOnlySummary() {
        super.checkOnlySummary();
    }

    private void createDirectionGroup(Composite parent) {
        ChoiceSelection cs = new ChoiceSelection();
        Label lbl = new Label(parent, 0);
        lbl.setText(Messages.getString(SelectOptionsForNetwPage.class, "direction.lbl"));
        GridData data = new GridData();
        data.horizontalAlignment = 1;
        data.horizontalIndent = 15;
        lbl.setLayoutData((Object)new GridData());
        this.forwardButton = new Button(parent, 16);
        this.forwardButton.setText(Messages.getString(SelectOptionsForNetwPage.class, "direction.forward.lbl"));
        this.forwardButton.setLayoutData((Object)new GridData());
        this.forwardButton.addSelectionListener((SelectionListener)cs);
        this.forwardButton.setData((Object)Direction.FORWARD);
        this.forwardButton.setSelection(true);
        this.wizard.set("direction", this.forwardButton.getData());
        this.backwardButton = new Button(parent, 16);
        this.backwardButton.setText(Messages.getString(SelectOptionsForNetwPage.class, "direction.backward.lbl"));
        this.backwardButton.setLayoutData((Object)new GridData());
        this.backwardButton.addSelectionListener((SelectionListener)cs);
        this.backwardButton.setData((Object)Direction.BACKWARD);
    }

    public boolean isPageComplete() {
        boolean ret = true;
        ret = this.wizard.getValue("direction") == null ? false : this.getErrorMessage() == null;
        return ret;
    }

    protected void checkAppendix() {
        super.checkAppendix();
        boolean showAppendix = this.btnAppendix.getSelection();
        if (this.btnShowInputs != null) {
            this.btnShowInputs.setEnabled(showAppendix);
        }
    }

    class ChoiceSelection
    implements SelectionListener {
        ChoiceSelection() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if (b.getSelection()) {
                Direction direction = (Direction)b.getData();
                SelectOptionsForNetwPage.this.wizard.set("direction", (Object)direction);
            }
            SelectOptionsForNetwPage.this.setPageComplete(SelectOptionsForNetwPage.this.isPageComplete());
        }
    }
}

