/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.aauto.networkdependency;

import com.ez.common.ui.listselection.Listable;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectNetworkDepsInputsPage<T extends Listable>
extends SelectProgramsPage<T> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Text thresholdLimit;

    public SelectNetworkDepsInputsPage(String pageName) {
        super(pageName);
        this.showReportsOptionGroup = true;
        this.showInputsOption = true;
        this.optionValue = PreferenceUtils.getPreferenceStore().getBoolean("showInputDetails");
    }

    protected void createSummaryGroup(Composite parent) {
        Group optionsGroup = this.getReportOptionsGroup(parent);
        GridLayout gl = new GridLayout(3, false);
        optionsGroup.setLayout((Layout)gl);
        this.createLeftComposite((Composite)optionsGroup);
        Label l = new Label((Composite)optionsGroup, 514);
        GridData data = new GridData();
        l.setLayoutData((Object)data);
        Composite rightC = new Composite((Composite)optionsGroup, optionsGroup.getStyle());
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 0x1000008;
        data.verticalAlignment = 0x1000008;
        rightC.setLayoutData((Object)data);
        gl = new GridLayout();
        rightC.setLayout((Layout)gl);
        this.btnAppendix = new Button(rightC, 32);
        this.btnAppendix.setText(Messages.getString(SelectNetworkDepsInputsPage.class, "showAppendix.lbl"));
        this.btnAppendix.setSelection(this.getShowAppendixValue());
        this.checkAppendix();
        this.btnAppendix.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectNetworkDepsInputsPage.this.checkAppendix();
            }
        });
        data = new GridData();
        data.horizontalAlignment = 1;
        data.verticalAlignment = 3;
        data.grabExcessVerticalSpace = true;
        this.btnAppendix.setLayoutData((Object)data);
        this.defaultAddAppendixOptions(rightC);
    }

    private void createLeftComposite(Composite optionsGroup) {
        Composite leftC = new Composite(optionsGroup, optionsGroup.getStyle());
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 1;
        data.verticalAlignment = 0x1000008;
        leftC.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, false);
        leftC.setLayout((Layout)gl);
        Label lbl = new Label(leftC, 0);
        lbl.setText(Messages.getString(SelectNetworkDepsInputsPage.class, "direction.lbl"));
        data = new GridData();
        data.horizontalAlignment = 1;
        lbl.setLayoutData((Object)data);
        Button succ = new Button(leftC, 16);
        succ.setText(Messages.getString(SelectNetworkDepsInputsPage.class, "direction.forward.lbl"));
        succ.setData((Object)Direction.FORWARD);
        succ.setSelection(true);
        this.wizard.set("direction", succ.getData());
        data = new GridData();
        succ.setLayoutData((Object)data);
        Button pred = new Button(leftC, 16);
        pred.setText(Messages.getString(SelectNetworkDepsInputsPage.class, "direction.backward.lbl"));
        pred.setData((Object)Direction.BACKWARD);
        data = new GridData();
        pred.setLayoutData((Object)data);
        SelectionListener lst = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.getSource();
                if (b.getSelection()) {
                    Direction direction = (Direction)b.getData();
                    SelectNetworkDepsInputsPage.this.wizard.set("direction", (Object)direction);
                }
                SelectNetworkDepsInputsPage.this.setPageComplete(SelectNetworkDepsInputsPage.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        succ.addSelectionListener(lst);
        pred.addSelectionListener(lst);
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        final Button limitButton = new Button(leftC, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        limitButton.setLayoutData((Object)data);
        limitButton.setText(Messages.getString(SelectNetworkDepsInputsPage.class, "limit.lbl"));
        limitButton.setSelection(isLimited);
        this.thresholdLimit = new Text(leftC, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.minimumWidth = 120;
        this.thresholdLimit.setLayoutData((Object)data);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectNetworkDepsInputsPage.this.catchThresholdLimit();
                SelectNetworkDepsInputsPage.this.setPageComplete(SelectNetworkDepsInputsPage.this.isPageComplete());
            }
        });
        this.thresholdLimit.setEnabled(isLimited);
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isLimited = limitButton.getSelection();
                SelectNetworkDepsInputsPage.this.thresholdLimit.setEnabled(isLimited);
                if (isLimited) {
                    SelectNetworkDepsInputsPage.this.catchThresholdLimit();
                } else {
                    SelectNetworkDepsInputsPage.this.wizard.set("limitLevel", (Object)-1);
                    SelectNetworkDepsInputsPage.this.setErrorMessage(null);
                }
                SelectNetworkDepsInputsPage.this.setPageComplete(SelectNetworkDepsInputsPage.this.isPageComplete());
            }
        };
        limitButton.addSelectionListener((SelectionListener)sa);
        if (isLimited) {
            this.catchThresholdLimit();
        } else {
            this.wizard.set("limitLevel", (Object)-1);
        }
    }

    private void catchThresholdLimit() {
        block8: {
            String text = this.thresholdLimit.getText();
            String errorMsg = Messages.getString(SelectNetworkDepsInputsPage.class, "level.threshold.error");
            Integer newThreshold = null;
            try {
                try {
                    newThreshold = Integer.valueOf(text);
                    if (newThreshold <= 0) {
                        this.setErrorMessage(errorMsg);
                        newThreshold = null;
                        break block8;
                    }
                    this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsg);
                    if (newThreshold != null) {
                        this.wizard.set("limitLevel", (Object)newThreshold);
                    }
                }
            }
            finally {
                if (newThreshold != null) {
                    this.wizard.set("limitLevel", (Object)newThreshold);
                }
            }
        }
    }

    public boolean isPageComplete() {
        boolean ret = super.isPageComplete();
        if (ret) {
            ret = this.wizard.getValue("direction") == null ? false : this.getErrorMessage() == null;
        }
        return ret;
    }
}

