/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.aauto.networkdependency;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.ParameterDirection;
import com.ez.ezdao.api.ParameterInfo;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.AAutoUtils;
import com.ez.mainframe.data.utils.CloseTestRunnable;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.aauto.networkdependency.Datasource;
import com.ez.report.application.ezreport.reports.aauto.networkdependency.JobNetRelashionshipReport;
import com.ez.report.application.model.AAutoNetwork;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.application.reports.calltree.Holder;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SC3DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends com.ez.report.application.ezreport.reports.calltree.ReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String FORWARD_NETWORK_PROC_NAME = "EZViewer_AAuto_Graph_Forward";
    private static final String BACKWARD_NETWORK_PROC_NAME = "EZViewer_AAuto_Graph_Backward";
    private static final String NETWORK_DETAILS_PROC_NAME = "EZViewer_AAuto_Network_Details";
    int step = 0;

    public ReportBuilder(String reportName) {
        this.report = null;
        this.summaryChartTitle = Messages.getString(ReportBuilder.class, "report.chartTitle");
        this.xAxisLbl = Messages.getString(ReportBuilder.class, "chart.xAxis");
        this.yAxisLbl = Messages.getString(ReportBuilder.class, "chart.yAxis");
        this.runWithLock = false;
        this.markOnlyExpandable = WorkspacePrefUtils.getPreferenceStore().getBoolean("graphHighlightedOnlyExpandableAtLimit");
    }

    @Override
    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        this.parameters.put("report.title", externalized);
        this.parameters.put("group.name", "");
        this.parameters.put("group.summary.lbl", Messages.getString(ReportBuilder.class, "groupSummaryLbl"));
        externalized = Messages.getString(ReportBuilder.class, "report.sum1");
        this.parameters.put("report.sum1.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum2");
        this.parameters.put("report.sum2.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum3");
        this.parameters.put("report.sum3.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum3.1");
        this.parameters.put("report.sum3.1.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum3.2");
        this.parameters.put("report.sum3.2.lbl", externalized);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/subBase.jasper", (String)"detailsSubreportTemplate", (Map)this.parameters);
        this.h = new Holder();
        this.parameters.put("holder", this.h);
        monitor.worked(100);
        return this.parameters;
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        Direction d = (Direction)this.getReportModel().getProperty("direction");
        this.chainDirection = Direction.FORWARD.equals((Object)d) ? " -> " : " <- ";
        this.csvFile = this.createTempCSVFile();
        this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        Integer levelLimit = (Integer)this.getReportModel().getProperty("limitLevel");
        Datasource dds = null;
        pmonitor.subTask(Messages.getString(ReportBuilder.class, "collectingData.subtaskname"));
        boolean noLimit = levelLimit == null || -1 == levelLimit;
        ParameterInfo[] pInfo = new ParameterInfo[]{ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4)};
        Object[] params = new Object[]{noLimit ? null : levelLimit};
        SingleQueryResult queryResult = this.queryForData((Runnable)new CloseTestRunnable(pmonitor), params, pInfo, EZSourceDataType.Integer, this.filterSelectedIDs());
        String[][] results = queryResult.data;
        ArrayList<AAutoNetwork> inpts = new ArrayList<AAutoNetwork>((Collection)this.getReportModel().getProperty("inputs"));
        Collections.sort(inpts);
        Integer inptsNo = new Integer(inpts.size());
        this.parameters.put("report.sum2", inptsNo);
        if (results != null && results.length > 0) {
            String[][] prevNetworkIdInt;
            HashMap<Integer, HashSet<Integer>> ends = null;
            if (!noLimit) {
                ends = new HashMap<Integer, HashSet<Integer>>();
            }
            HashMap<Object, AAutoNetwork> netwks = new HashMap<Object, AAutoNetwork>();
            HashMap graph = new HashMap();
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                this.checkStop();
                String prevNetworkId = Direction.FORWARD.equals((Object)d) ? result[0] : result[1];
                String tgtNetworkId = Direction.FORWARD.equals((Object)d) ? result[1] : result[0];
                Integer tgtNetworkIdInt = Integer.valueOf(tgtNetworkId);
                if (ends != null) {
                    HashSet<Integer> st = (HashSet<Integer>)ends.get(tgtNetworkIdInt);
                    if (st == null) {
                        st = new HashSet<Integer>();
                        ends.put(tgtNetworkIdInt, st);
                    }
                    st.add(Integer.valueOf(result[2]));
                }
                if (prevNetworkId == null) {
                    netwks.put(tgtNetworkIdInt, null);
                    if (!graph.containsKey(tgtNetworkIdInt)) {
                        graph.put(tgtNetworkIdInt, new ArrayList());
                    }
                } else {
                    prevNetworkIdInt = Integer.valueOf(prevNetworkId);
                    netwks.put(prevNetworkIdInt, null);
                    netwks.put(tgtNetworkIdInt, null);
                    ArrayList<Integer> children = (ArrayList<Integer>)graph.get(prevNetworkIdInt);
                    if (children == null) {
                        children = new ArrayList<Integer>();
                        graph.put(prevNetworkIdInt, children);
                    }
                    if (!children.contains(tgtNetworkIdInt)) {
                        children.add(tgtNetworkIdInt);
                    }
                }
                ++n2;
            }
            L.debug("graph: {}", graph);
            L.info("graph.keys.size={}", (Object)graph.keySet().size());
            this.checkStop();
            ArrayList<Object> tmp = new ArrayList<Object>();
            if (!noLimit) {
                tmp.addAll(netwks.keySet());
                tmp.removeAll(graph.keySet());
                if (ends != null) {
                    for (Integer s : ends.keySet()) {
                        Set st = (Set)ends.get(s);
                        if (st.contains(levelLimit)) {
                            if (st.size() <= 1) continue;
                            tmp.remove(s);
                            continue;
                        }
                        boolean removeIt = true;
                        for (Integer l1 : st) {
                            if (l1 <= levelLimit) continue;
                            removeIt = false;
                        }
                        if (!removeIt) continue;
                        tmp.remove(s);
                    }
                    ends.clear();
                }
                L.trace("end nodes: {}", (Object)((Object)tmp).toString());
            }
            if (this.markOnlyExpandable) {
                HashSet tmpst = new HashSet(tmp);
                SingleQueryResult sqlRes = this.querySQLForData(EZSourceDataType.Integer, tmpst, pmonitor);
                String[][] aautoNetworksWithChildren = sqlRes != null ? sqlRes.data : null;
                tmp.clear();
                tmpst.clear();
                if (!pmonitor.isCanceled() && aautoNetworksWithChildren != null) {
                    prevNetworkIdInt = aautoNetworksWithChildren;
                    int tgtNetworkIdInt = aautoNetworksWithChildren.length;
                    int l1 = 0;
                    while (l1 < tgtNetworkIdInt) {
                        String[] result = prevNetworkIdInt[l1];
                        tmp.add(Integer.valueOf(result[0]));
                        ++l1;
                    }
                }
            }
            HashMap graph1 = null;
            HashSet<AAutoNetwork> toMark = new HashSet<AAutoNetwork>();
            this.step = 1;
            queryResult = this.queryForData((Runnable)new CloseTestRunnable(pmonitor), new String[0], EZSourceDataType.Integer, netwks.keySet());
            results = queryResult.data;
            if (results != null && results.length > 0) {
                String[][] tgtNetworkIdInt = results;
                int l1 = results.length;
                int n3 = 0;
                while (n3 < l1) {
                    String[] detail = tgtNetworkIdInt[n3];
                    Integer ntwId = Integer.valueOf(detail[0]);
                    AAutoNetwork ntw = new AAutoNetwork(ntwId, detail[1], detail[2]);
                    netwks.put(ntwId, ntw);
                    if (!noLimit && tmp.contains(ntwId)) {
                        toMark.add(ntw);
                    }
                    ++n3;
                }
                tmp.clear();
                this.checkStop();
                graph1 = new HashMap();
                for (Integer ntId : graph.keySet()) {
                    List children = (List)graph.get(ntId);
                    ArrayList<AAutoNetwork> names = new ArrayList<AAutoNetwork>();
                    for (Integer cId : children) {
                        names.add((AAutoNetwork)netwks.get(cId));
                    }
                    Collections.sort(names);
                    graph1.put(ntId, names);
                }
            }
            netwks.clear();
            netwks = null;
            graph.clear();
            graph = null;
            dds = new Datasource(this, inpts, graph1, this.chainDirection, toMark, pmonitor);
        } else {
            this.h.setMax(new Integer(0));
            this.h.setPrgs(inptsNo);
            this.h.setNotCalled(inptsNo);
        }
        Boolean showApp = (Boolean)this.getReportModel().getProperty("show appendix");
        if (showApp != null && showApp.booleanValue()) {
            this.parameters.put("appendixDS", this.buildAppendix(new DSFactory(), (IProgressMonitor)new NullProgressMonitor()));
        }
        return dds;
    }

    protected String getSQLQuery() {
        ServerType serverType = this.pInfo.getDbEngine();
        Direction d = (Direction)this.getReportModel().getProperty("direction");
        boolean fw = Direction.FORWARD.equals((Object)d);
        return fw ? AAutoUtils.getNetworksUsedFwQuery((ServerType)serverType) : AAutoUtils.getNetworksUsedBwQuery((ServerType)serverType);
    }

    protected String getSQLQuerySelective() {
        return this.getSQLQuery();
    }

    @Override
    public void noMoreData() {
        super.noMoreData();
        if (this.addLimitNoteInAppendix) {
            ReportBuilder.fillAppendixDS4Notes(this.appendixNote, true, this.markOnlyExpandable, false);
        }
    }

    private ElementGroupInfo buildAppendix(DSFactory factory, IProgressMonitor pMonitor) {
        pMonitor.subTask(Messages.getString(ReportBuilder.class, "buildAppendix.subtaskname"));
        ElementGroupInfo appendixDS = new ElementGroupInfo("appxDS");
        Integer levelLimit = (Integer)this.getReportModel().getProperty("limitLevel");
        if (levelLimit != null && -1 != levelLimit) {
            this.appendixNote = (SC1DataSource)factory.createDS(3);
            this.appendixNote.setList(new ArrayList());
            appendixDS.addDataSource((SubreportDataSource)this.appendixNote);
        }
        SC1DataSource dataSource = (SC1DataSource)factory.createDS(3);
        dataSource.setExtraTitle(Messages.getString(ReportBuilder.class, "rep.inputs.descr"));
        dataSource.setLayout(6);
        ArrayList<ObjectForSubreport> list = new ArrayList<ObjectForSubreport>();
        Collection workerInputs = (Collection)this.getReportModel().getProperty("inputs");
        Direction d = (Direction)this.getReportModel().getProperty("direction");
        ObjectForSubreport obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportBuilder.class, "report.direction"));
        obj.setExpVal(d.toString());
        list.add(obj);
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportBuilder.class, "report.depth.appendix.text"));
        if (levelLimit != null && -1 != levelLimit) {
            obj.setExpVal(String.valueOf(levelLimit));
        } else {
            obj.setExpVal(Messages.getString(ReportBuilder.class, "report.depth.appendix.unlimtedvalue"));
        }
        list.add(obj);
        Boolean showInputs = (Boolean)this.report.getProperty("showInputDetails");
        obj = new ObjectForSubreport();
        if (showInputs.booleanValue()) {
            obj.setExp(Messages.getString(ReportBuilder.class, "report.inputs"));
            SC3DataSource appDS = new SC3DataSource();
            appDS.setLayout(5);
            ArrayList<ObjectForSubreport> subreportLst = new ArrayList<ObjectForSubreport>();
            for (AAutoNetwork ntw : workerInputs) {
                String[] results = new String[]{"", ReportsUtils.stripNonValidXMLCharacters((String)ntw.getListableName(), (boolean)true)};
                ObjectForSubreport o = factory.createObj(1, results, "");
                subreportLst.add(o);
            }
            appDS.setList(subreportLst);
            obj.setSubreportDS((BaseSubreportDataSource)appDS);
            obj.setSubreportName("reports/subCols3-layout5.jasper");
        } else {
            obj.setExp(Messages.getString(ReportBuilder.class, "dataset.report.inputs.short"));
            obj.setExpVal("" + workerInputs.size());
        }
        list.add(obj);
        dataSource.setList(list);
        appendixDS.addDataSource((SubreportDataSource)dataSource);
        pMonitor.subTask("");
        return appendixDS;
    }

    @Override
    protected String getProcedure() {
        if (this.step == 0) {
            Direction d = (Direction)this.getReportModel().getProperty("direction");
            return Direction.FORWARD.equals((Object)d) ? FORWARD_NETWORK_PROC_NAME : BACKWARD_NETWORK_PROC_NAME;
        }
        return NETWORK_DETAILS_PROC_NAME;
    }

    @Override
    protected String getSelectiveProcedure() {
        return this.getProcedure();
    }

    protected Collection getSelected() {
        return (Collection)this.getReportModel().getProperty("inputs");
    }

    @Override
    protected void customizeJasperPrint(JasperPrint print) {
    }

    protected Collection filterSelectedIDs(IProgressMonitor monitor) {
        if (this.selectedIds == null) {
            this.selectedIds = new HashSet();
            Collection selectedResources = this.getSelected();
            for (AAutoNetwork inpt : selectedResources) {
                this.selectedIds.add(inpt.getNetwkId());
            }
        }
        return this.selectedIds;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new JobNetRelashionshipReport(this.project, false);
            this.report.setInput(this.inputs.get("selected resources"));
            this.report.addProperty("limitLevel", this.inputs.get("limitLevel"));
            Direction direction = (Direction)this.inputs.get("direction");
            this.report.addProperty("direction", (Object)direction);
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    protected void putGenericParameters(Map params) {
        super.putGenericParams(params);
        this.parameters.put("showInputs1", this.parameters.get("showInputs"));
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(((Object)((Object)this)).getClass(), "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "group1.name");
        params.put("group1.name", externalized);
    }

    @Override
    public void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            Direction d = (Direction)this.getReportModel().getProperty("direction");
            String secondColumnHeader = "";
            secondColumnHeader = Direction.FORWARD.equals((Object)d) ? Messages.getString(((Object)((Object)this)).getClass(), "csv.header.successors") : Messages.getString(((Object)((Object)this)).getClass(), "csv.header.predecessors");
            Integer levelLimit = (Integer)this.getReportModel().getProperty("limitLevel");
            boolean hasLimit = levelLimit != null && -1 != levelLimit;
            Utils.writeNotePartInCSV((CSVWriter)csv, (boolean)hasLimit, (boolean)this.markOnlyExpandable, (boolean)false);
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.input"), secondColumnHeader});
        }
    }

    protected int getMaxCachedPages() {
        return 10;
    }
}

