/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.aauto.networkdependency;

import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.aauto.networkdependency.NtkwGroup;
import com.ez.report.application.ezreport.reports.aauto.networkdependency.ReportBuilder;
import com.ez.report.application.ezreport.reports.calltree.DataSource;
import com.ez.report.application.model.AAutoNetwork;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Datasource
extends DataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Datasource.class);
    private static final int MAX_NO_OF_CHAINS = 200;
    int no = 0;
    Map<Integer, Integer> pos = new HashMap<Integer, Integer>();
    ArrayList<AAutoNetwork> lRow = null;
    ArrayList<String> lastRow = null;
    private List<AAutoNetwork> inputs;
    private Map<Integer, List<AAutoNetwork>> graph;
    int noResults = 0;
    Set<AAutoNetwork> endsToMark;

    public Datasource(ReportBuilder builder, List<AAutoNetwork> inpts, Map<Integer, List<AAutoNetwork>> graph, String direction, Set<AAutoNetwork> markedEnds, IProgressMonitor pmonitor) {
        super(builder, inpts, pmonitor, direction);
        this.inputs = inpts;
        this.graph = graph;
        this.endsToMark = markedEnds;
    }

    @Override
    public Object getFieldValue(JRField arg0) throws JRException {
        Object value = null;
        if (arg0.getName().equals("prg_name")) {
            value = this.currentGroup.prgName;
        } else if (arg0.getName().equals("chain")) {
            value = this.currentGroup.getRowAsString();
            this.writeRowToCSV();
            ((NtkwGroup)this.currentGroup).emptyRow();
        } else if (arg0.getName().equals("count")) {
            value = Boolean.TRUE;
        }
        L.debug("fieldName: {} = ({}) {} ", new Object[]{arg0.getName(), this.currentGroup.prgName, value});
        return value;
    }

    @Override
    public boolean nextItem() throws JRException {
        if (this.monitor.isCanceled()) {
            throw new CanceledException("report was canceled");
        }
        if (this.currentGroup == null || this.currentGroup.isParsed() && this.isComplete()) {
            this.finishGroup();
            this.getNextGroup();
        } else if (this.currentGroup != null) {
            if (this.currentGroup.isParsed() && !this.isComplete()) {
                Integer last = this.lRow.get(this.lRow.size() - 1).getNetwkId();
                boolean added = this.fillrows(this.lastRow, last);
                this.no = 0;
                if (!added) {
                    this.finishGroup();
                    this.getNextGroup();
                }
            }
            if (this.currentGroup != null) {
                ++this.currentGroup.index;
            }
        }
        if (this.currentGroup != null) {
            this.currentGroup.selectRow();
            ++this.nrChain;
            Object[] currentRow = (String[])this.currentGroup.rows.get(this.currentGroup.index);
            L.debug("currentGroup.index={} ;currentRow={}", (Object)this.currentGroup.index, (Object)Arrays.toString(currentRow));
            int length = currentRow.length;
            Object val = currentRow[length - 2];
            if (val != null) {
                length -= 2;
            }
            while (val == null) {
                val = currentRow[length -= 2];
            }
            if (length > this.maxLength * 2) {
                this.maxLength = length / 2;
                if (this.maxLength > this.max) {
                    this.max = this.maxLength;
                    this.nrPrgs = 1;
                } else if (this.maxLength == this.max) {
                    ++this.nrPrgs;
                }
            }
        } else {
            this.graph.clear();
            this.graph = null;
            this.monitor.subTask(Messages.getString(Datasource.class, "preparesummary.subtaskname"));
            this.builder.noMoreData();
            this.addFinalParams();
            if (this.csvWriter != null) {
                this.csvWriter.close();
            }
            this.monitor.subTask("");
        }
        return this.currentGroup != null;
    }

    private void getNextGroup() {
        if (this.inputs != null & this.inputs.size() > 0) {
            boolean peekNext = true;
            while (peekNext) {
                AAutoNetwork ntwk = this.inputs.remove(0);
                L.debug("{}={}", (Object)ntwk.getNetwkId(), (Object)ntwk.getListableName());
                List<AAutoNetwork> children = this.graph.get(ntwk.getNetwkId());
                if (children != null && !children.isEmpty()) {
                    this.currentGroup = new NtkwGroup(this.direction, true);
                    this.currentGroup.prgName = ReportsUtils.stripNonValidXMLCharacters((String)ntwk.getListableName(), (boolean)true);
                    this.monitor.subTask(Messages.getString(Datasource.class, "preparingData.subtaskname", new String[]{this.currentGroup.prgName}));
                    this.buildChains(ntwk);
                    this.monitor.subTask(Messages.getString(Datasource.class, "printingData.subtaskname", new String[]{this.currentGroup.prgName}));
                    peekNext = false;
                    continue;
                }
                L.info("input with no children: {}", (Object)ntwk.getListableName());
                peekNext = this.inputs != null & this.inputs.size() > 0;
                ++this.noResults;
            }
        }
    }

    private void finishGroup() {
        if (this.currentGroup != null && this.currentGroup.isParsed() && this.isComplete()) {
            this.calledPrograms.add(this.currentGroup.prgName);
            this.xydataset.addData(this.getPlotGroup(this.currentGroup));
            this.currentGroup.clear();
            this.currentGroup = null;
            this.nrChain = 0;
            this.maxLength = 1;
        }
    }

    private void buildChains(AAutoNetwork ntwk) {
        Integer id = ntwk.getNetwkId();
        ArrayList<String> row = new ArrayList<String>();
        row.add(ntwk.getListableName());
        row.add(null);
        this.lRow = new ArrayList();
        this.lRow.add(ntwk);
        this.lastRow = null;
        this.no = 0;
        this.fillrows(row, id);
    }

    private boolean fillrows(ArrayList<String> row, Integer id) {
        boolean ret = false;
        Object c = this.getNextChild(id);
        while (c == null && row != null && !row.isEmpty()) {
            row.remove(row.size() - 1);
            row.remove(row.size() - 1);
            this.lRow.remove(this.lRow.size() - 1);
            if (row.isEmpty()) continue;
            AAutoNetwork prev = this.lRow.get(this.lRow.size() - 1);
            c = this.getNextChild(prev.getNetwkId());
        }
        while (c != null) {
            AAutoNetwork prev;
            boolean cycle = row.contains(c.getListableName());
            row.add(c.getListableName());
            row.add(null);
            this.lRow.add((AAutoNetwork)c);
            c = cycle ? null : this.getNextChild(c.getNetwkId());
            if (c != null) continue;
            if (cycle) {
                L.debug("cycle: {}", row);
            }
            if (this.endsToMark != null && !this.endsToMark.isEmpty() && this.endsToMark.contains(prev = this.lRow.get(this.lRow.size() - 1))) {
                int idx = row.size() - 2;
                String tmp = row.get(idx);
                row.set(idx, String.valueOf(tmp) + " *");
                this.builder.addLimitNoteInAppendix(true);
            }
            ((NtkwGroup)this.currentGroup).addRow(row.toArray(new String[0]));
            ret = true;
            ++this.no;
            if (this.no < 200) {
                while (c == null && !row.isEmpty()) {
                    row.remove(row.size() - 1);
                    row.remove(row.size() - 1);
                    this.lRow.remove(this.lRow.size() - 1);
                    if (!row.isEmpty()) {
                        prev = this.lRow.get(this.lRow.size() - 1);
                        c = this.getNextChild(prev.getNetwkId());
                        continue;
                    }
                    this.lastRow = null;
                }
                continue;
            }
            if (!row.isEmpty()) {
                row.remove(row.size() - 1);
                row.remove(row.size() - 1);
                this.lRow.remove(this.lRow.size() - 1);
            }
            this.lastRow = row;
            c = null;
        }
        return ret;
    }

    boolean isComplete() {
        return this.lastRow == null || this.lastRow.isEmpty();
    }

    private AAutoNetwork getNextChild(Integer id) {
        List<AAutoNetwork> children = this.graph.get(id);
        Integer idx = this.pos.get(id);
        if (idx == null) {
            idx = new Integer(0);
            this.pos.put(id, idx);
        }
        AAutoNetwork ret = children == null || children.size() == 0 || idx >= children.size() ? null : children.get(idx);
        idx = new Integer(idx + 1);
        this.pos.put(id, idx);
        if (children != null && idx == children.size() + 1) {
            this.pos.put(id, new Integer(0));
        }
        return ret != null ? ret : null;
    }

    @Override
    public void clear() {
        if (this.graph != null) {
            this.graph.clear();
            this.graph = null;
        }
        if (this.inputs != null) {
            this.inputs.clear();
            this.inputs = null;
        }
        if (this.lastRow != null) {
            this.lastRow.clear();
            this.lastRow = null;
        }
        if (this.lRow != null) {
            this.lRow.clear();
            this.lRow = null;
        }
        if (this.pos != null) {
            this.pos.clear();
            this.pos = null;
        }
        if (this.endsToMark != null) {
            this.endsToMark.clear();
            this.endsToMark = null;
        }
        super.clear();
    }

    @Override
    protected int getNotCallednumber() {
        return this.noResults;
    }
}

