/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.aauto.networkdependency;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceAAUTONetworkInputType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.aauto.networkdependency.NetwDependencyJob;
import com.ez.report.application.ezreport.reports.aauto.networkdependency.SelectNetworkDepsInputsPage;
import com.ez.report.application.ezreport.reports.aauto.networkdependency.SelectOptionsForNetwPage;
import com.ez.report.application.model.AAutoNetwork;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.collectors.AAutoNetworkCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.viewer.execution.EZReportAnalysis;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AAUTONetworkIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;

public class AAutoNetworkDependencyAnalysis
extends EZReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String DIRECTION = "direction";
    public static final String LIMIT = "limitLevel";
    public static final int NO_LIMIT = -1;
    boolean isNtwkInput = false;

    public AAutoNetworkDependencyAnalysis() {
        this(null);
    }

    public AAutoNetworkDependencyAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            if (inputs.size() > 0 && inputs.get(0) instanceof EZSourceProjectInputType) {
                super.setInputs(inputs);
            } else {
                ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
                this.params = new HashMap();
                ArrayList<AAutoNetwork> sel = new ArrayList<AAutoNetwork>();
                HashSet<String> inputNames = new HashSet<String>();
                for (Object inpObj : inputs) {
                    if (inpObj instanceof EZSourceAAUTONetworkInputType) {
                        EZEntityID entity = ((EZObjectType)inpObj).getEntID();
                        list.add(entity);
                        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
                        if (prjSg != null) {
                            if (!prjSg.getProjectName().equals(this.projectName)) {
                                this.setPrjName(prjSg.getProjectName());
                                this.addContextValue("input_project_names", prjSg.getProjectName());
                                ProjectInfo pInfo = prjSg.getProjectInfo();
                                com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                                this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                            }
                            AAUTONetworkIDSg networkIDSg = (AAUTONetworkIDSg)entity.getSegment(AAUTONetworkIDSg.class);
                            String name = networkIDSg.getResourceName();
                            String expandedNetworkName = networkIDSg.getExpandedNetworkName();
                            sel.add(new AAutoNetwork(networkIDSg.getNetworkId(), name, expandedNetworkName));
                            inputNames.add(name);
                        }
                    }
                    this.isNtwkInput = true;
                }
                if (!sel.isEmpty()) {
                    this.params.put("selected resources", sel);
                    this.params.put("show summary only", Boolean.FALSE);
                    this.addContextValue("input_list", list);
                    this.addContextValue("inputs name string", inputNames);
                }
            }
        }
    }

    @Override
    protected void processSpecificInput(EZObjectType objType, List<EZEntityID> list, List<BaseMainframeResourceInput> sel, Set<String> inputNames) {
        EZEntityID entity = objType.getEntID();
        list.add(entity);
        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
        if (prjSg != null) {
            AAUTONetworkIDSg networkIDSg;
            if (!prjSg.getProjectName().equals(this.projectName)) {
                this.setPrjName(prjSg.getProjectName());
                this.addContextValue("input_project_names", prjSg.getProjectName());
                ProjectInfo pInfo = prjSg.getProjectInfo();
                com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
            }
            if ((networkIDSg = (AAUTONetworkIDSg)objType.getProperty("mainframe resource id sg")) == null) {
                networkIDSg = (AAUTONetworkIDSg)entity.getSegment(AAUTONetworkIDSg.class);
            }
            if (networkIDSg != null) {
                String name = networkIDSg.getResourceName();
                String expandedNetworkName = networkIDSg.getExpandedNetworkName();
                sel.add((BaseMainframeResourceInput)new AAutoNetwork(networkIDSg.getNetworkId(), name, expandedNetworkName));
                inputNames.add(name);
            }
        }
    }

    @Override
    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(AAutoNetworkDependencyAnalysis.class, "wizard.title");
        wizard.setWindowTitle(wizardName);
        String pageTitle = Messages.getString(AAutoNetworkDependencyAnalysis.class, "wizardpage.title");
        if (this.isNtwkInput) {
            SelectOptionsForNetwPage pg = new SelectOptionsForNetwPage("programs page");
            pg.setTitle(pageTitle);
            pg.setDescription(Messages.getString(AAutoNetworkDependencyAnalysis.class, "wizardpage.options.description"));
            wizard.addPage((IWizardPage)pg);
        } else {
            SelectNetworkDepsInputsPage pg = new SelectNetworkDepsInputsPage("programs page");
            AAutoNetworkCollector collector = new AAutoNetworkCollector();
            pg.setResourcesCollector((ResourcesCollector)collector);
            pg.setLeftGroupLabel(Messages.getString(AAutoNetworkDependencyAnalysis.class, "av.resourceType.name"));
            pg.setRightGroupLabel(Messages.getString(AAutoNetworkDependencyAnalysis.class, "sel.resourceType.name"));
            pg.setTitle(pageTitle);
            pg.setDescription(Messages.getString(AAutoNetworkDependencyAnalysis.class, "wizardpage.inputsAndoptions.description"));
            wizard.addPage(pg);
        }
        return wizard;
    }

    @Override
    protected boolean checkInputs(List inputs) {
        return inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType || this.isNtwkInput;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, NetwDependencyJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_AAUTO_REPORT_ANALYSIS;
    }

    @Override
    protected boolean parametersEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = super.parametersEquals(params1, params2);
        if (ret) {
            Direction v1 = (Direction)params1.get(DIRECTION);
            Direction v2 = (Direction)params2.get(DIRECTION);
            if (v1 != null) {
                ret = v1.equals((Object)v2);
            } else {
                boolean bl = ret = v2 == null;
            }
            if (ret) {
                Object limit1 = params1.get(LIMIT);
                Object limit2 = params2.get(LIMIT);
                ret = limit1 != null ? (limit2 != null ? limit1.equals(limit2) : false) : limit2 == null;
            }
        }
        return ret;
    }
}

