/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.aauto.netVsJob;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.aauto.AAutoDataSource;
import com.ez.report.application.ezreport.reports.aauto.netVsJob.NetworkVsJobReport;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.application.model.AAutoNetwork;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.scriptlets.HeadingsScriptlet;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkVsJobReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(NetworkVsJobReportBuilder.class);
    private static final String STRING_FOR_ = " - ";
    private static final String EZ_VIEWER_NETWORK_VS_JOB_SELECTIVE_PROC_NAME = "EZViewer_NetworkVsJob_Selective";
    private static final String EZ_VIEWER_NETWORK_VS_JOB_PROC_NAME = "EZViewer_NetworkVsJob";
    private static final String SELECTED_NETWORK_IDS = "selected network ids";
    private static final String JOBS_TITLE = Messages.getString(NetworkVsJobReportBuilder.class, "jobs.group");
    private static final String JOBS_DS_KEY = "jobsDSkey";

    public NetworkVsJobReportBuilder(String reportName) {
    }

    protected String getReportTemplatePath() {
        return "reports/summaryReport.jasper";
    }

    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(NetworkVsJobReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        this.putGenericParameters(this.parameters);
        this.putExternalizedParameters(this.parameters);
        Utils.addScriptlet(this.parameters, HeadingsScriptlet.class.getName());
        this.putSubreportStream("/reports/subBase.jasper", "detailsSubreportTemplate");
        monitor.worked(100);
        return this.parameters;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) throws Exception {
        AAutoDataSource dataSource = null;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(NetworkVsJobReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        this.writeCSVHeader(csvWriter);
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        try {
            Set netList = (Set)this.getReportModel().getProperty("inputs");
            HashMap<Integer, String[]> netIds = new HashMap<Integer, String[]>();
            for (AAutoNetwork net : netList) {
                String nameWithExpanded = net.getListableName();
                String name = ReportsUtils.stripNonValidXMLCharacters((String)nameWithExpanded, (boolean)true);
                netIds.put(net.getResourceID(), new String[]{name, net.getNetwkName(), net.getNetwkExpandedName()});
            }
            this.getReportModel().addProperty(SELECTED_NETWORK_IDS, netIds.keySet());
            this.parameters.put("appendixFirstLineValue", String.valueOf(netList.size()));
            SingleQueryResult qResults = this.queryForData((IProgressMonitor)monitor, EZSourceDataType.Integer);
            String[][] data = qResults.data;
            HashMap<String, ElementGroupInfo> inputNetworkMap = new HashMap<String, ElementGroupInfo>();
            if (data != null && data.length > 0) {
                DSFactory factory = new DSFactory();
                monitor.setWorkRemaining(data.length);
                String[][] stringArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    ArrayList<ObjectForSubreport> objList;
                    SC1DataSource elemDS;
                    String[] result = stringArray[n2];
                    if (monitor.isCanceled()) break;
                    String[] names = (String[])netIds.get(Integer.valueOf(result[0]));
                    monitor.subTask(names[0]);
                    ElementGroupInfo elemGroupInfo = (ElementGroupInfo)inputNetworkMap.get(names[0]);
                    if (elemGroupInfo == null) {
                        elemGroupInfo = new ElementGroupInfo(names[0]);
                        inputNetworkMap.put(names[0], elemGroupInfo);
                    }
                    if ((elemDS = (SC1DataSource)elemGroupInfo.getDS(JOBS_DS_KEY)) == null) {
                        elemDS = (SC1DataSource)factory.createDS(3);
                        elemDS.setLayout(3);
                        elemDS.setKey(JOBS_DS_KEY);
                        elemDS.setTitle(JOBS_TITLE);
                        elemDS.setColumn1Name(Messages.getString(NetworkVsJobReportBuilder.class, "number.column.title"));
                        elemDS.setColumn2Name(Messages.getString(NetworkVsJobReportBuilder.class, "name.column.title"));
                        elemGroupInfo.addDataSource((SubreportDataSource)elemDS);
                    }
                    if ((objList = elemDS.getList()) == null) {
                        objList = new ArrayList<ObjectForSubreport>();
                        elemDS.setList(objList);
                    }
                    ObjectForSubreport objectForSubreport = new ObjectForSubreport();
                    String jobNumber = String.format("%03d", Integer.valueOf(result[3]));
                    String jobName = result[2];
                    jobName = ReportsUtils.stripNonValidXMLCharacters((String)jobName, (boolean)true);
                    objectForSubreport.setExp(jobNumber);
                    objectForSubreport.setExpVal(jobName);
                    objectForSubreport.setElGroup(JOBS_TITLE);
                    objList.add(objectForSubreport);
                    if (csvWriter != null) {
                        csvWriter.write(new String[]{names[1], names[2] != null ? names[2] : "", jobNumber, jobName});
                    }
                    monitor.worked(1);
                    ++n2;
                }
            }
            monitor.done();
            dataSource = new AAutoDataSource(inputNetworkMap);
            this.buildInputs4Appendix(netList);
        }
        finally {
            if (csvWriter != null) {
                csvWriter.close();
            }
        }
        return dataSource;
    }

    protected String getProcedure() {
        return EZ_VIEWER_NETWORK_VS_JOB_PROC_NAME;
    }

    protected String getSelectiveProcedure() {
        return EZ_VIEWER_NETWORK_VS_JOB_SELECTIVE_PROC_NAME;
    }

    protected Collection getSelected() {
        return (Collection)this.getReportModel().getProperty(SELECTED_NETWORK_IDS);
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new NetworkVsJobReport(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    protected void putGenericParameters(Map params) {
        super.putGenericParams(params);
        this.parameters.put("showInputs1", this.parameters.get("showInputs"));
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(((Object)((Object)this)).getClass(), "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "group1.name");
        params.put("group1.name", externalized);
    }

    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.networkName"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.networkExpandedName"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.jobNumber"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.jobName")});
        }
    }
}

