/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.aauto.jobVsNet;

import com.ez.common.model.BaseResourceInput;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.aauto.AAutoDataSource;
import com.ez.report.application.ezreport.reports.aauto.jobVsNet.JobVsNetworkReport;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.scriptlets.HeadingsScriptlet;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobVsNetworkReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(JobVsNetworkReportBuilder.class);
    private static final String EZ_VIEWER_JOB_VS_NETWORK_SELECTIVE_PROC_NAME = "EZViewer_JobVsNetwork_Selective";
    private static final String EZ_VIEWER_JOB_VS_NETWORK_PROC_NAME = "EZViewer_JobVsNetwork";
    private static final String SELECTED_JOB_IDS = "selected job ids";
    private static final String NETWORKS_TITLE = Messages.getString(JobVsNetworkReportBuilder.class, "networks.group");
    private static final String NETWORKS_DS_KEY = "netwkDSkey";

    public JobVsNetworkReportBuilder(String reportName) {
    }

    private static final String getAAutoJobDetailsProc(ServerType serverType) {
        return "select JobId, JobName from AAUTOJobs where jobName in (select * from  " + com.ez.mainframe.data.utils.Utils.getTempTableName((ServerType)serverType, (String)"string_param_temp") + ")";
    }

    protected String getReportTemplatePath() {
        return "reports/summaryReport.jasper";
    }

    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(JobVsNetworkReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        this.putGenericParameters(this.parameters);
        this.putExternalizedParameters(this.parameters);
        Utils.addScriptlet(this.parameters, HeadingsScriptlet.class.getName());
        this.putSubreportStream("/reports/subBase.jasper", "detailsSubreportTemplate");
        monitor.worked(100);
        return this.parameters;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) throws Exception {
        AAutoDataSource dataSource = null;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(JobVsNetworkReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        this.writeCSVHeader(csvWriter);
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        try {
            String[] result;
            int n;
            int n2;
            String[][] stringArray;
            HashMap<String, ElementGroupInfo> inputJobMap = new HashMap<String, ElementGroupInfo>();
            Set jobList = (Set)this.getReportModel().getProperty("inputs");
            Boolean mustCompleteInformation = false;
            for (BaseResourceInput inp : jobList) {
                if (inp.getResourceID() != null) continue;
                mustCompleteInformation = true;
                break;
            }
            if (mustCompleteInformation.booleanValue()) {
                HashSet<String> jobNames = new HashSet<String>();
                for (BaseResourceInput inp : jobList) {
                    jobNames.add(inp.getName());
                }
                IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
                String[][] aautoJobs = null;
                try {
                    ComputeWithLock runn = new ComputeWithLock(jobNames);
                    ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, (IProgressMonitor)monitor);
                    aautoJobs = runn.results;
                }
                catch (InterruptedException interruptedException) {
                    throw new CanceledException("connection interrupted");
                }
                catch (ExecutionException e) {
                    ErrorUtils.handleExecutionException((ExecutionException)e);
                }
                if (aautoJobs != null) {
                    stringArray = aautoJobs;
                    n2 = aautoJobs.length;
                    n = 0;
                    while (n < n2) {
                        result = stringArray[n];
                        for (BaseResourceInput job : jobList) {
                            if (!job.getName().equals(result[1]) || job.getResourceID() != null) continue;
                            job.setResourceID(Integer.valueOf(result[0]));
                            L.debug("jcl job {} was matched with an aauto job having id {}", (Object)result[1], (Object)result[0]);
                            break;
                        }
                        ++n;
                    }
                }
            }
            HashMap<Integer, String> jobIds = new HashMap<Integer, String>();
            for (BaseResourceInput job : jobList) {
                String name = job.getListableName();
                name = ReportsUtils.stripNonValidXMLCharacters((String)name, (boolean)true);
                if (job.getResourceID() == null) continue;
                jobIds.put(job.getResourceID(), name);
            }
            this.getReportModel().addProperty(SELECTED_JOB_IDS, jobIds.keySet());
            this.parameters.put("appendixFirstLineValue", String.valueOf(jobList.size()));
            SingleQueryResult qResults = this.queryForData((IProgressMonitor)monitor, EZSourceDataType.Integer);
            String[][] data = qResults.data;
            if (data != null && data.length > 0) {
                DSFactory factory = new DSFactory();
                monitor.setWorkRemaining(data.length);
                stringArray = data;
                n2 = data.length;
                n = 0;
                while (n < n2) {
                    result = stringArray[n];
                    if (!monitor.isCanceled()) {
                        ArrayList<ObjectForSubreport> objList;
                        SC1DataSource elemDS;
                        String name = (String)jobIds.get(Integer.valueOf(result[0]));
                        monitor.subTask(name);
                        ElementGroupInfo elemGroupInfo = (ElementGroupInfo)inputJobMap.get(name);
                        if (elemGroupInfo == null) {
                            elemGroupInfo = new ElementGroupInfo(name);
                            inputJobMap.put(name, elemGroupInfo);
                        }
                        if ((elemDS = (SC1DataSource)elemGroupInfo.getDS(NETWORKS_DS_KEY)) == null) {
                            elemDS = (SC1DataSource)factory.createDS(3);
                            elemDS.setLayout(3);
                            elemDS.setKey(NETWORKS_DS_KEY);
                            elemDS.setTitle(NETWORKS_TITLE);
                            elemGroupInfo.addDataSource((SubreportDataSource)elemDS);
                            elemDS.setColumn1Name(Messages.getString(JobVsNetworkReportBuilder.class, "networkName.column.title"));
                            elemDS.setColumn2Name(Messages.getString(JobVsNetworkReportBuilder.class, "jobName.column.title"));
                        }
                        if ((objList = elemDS.getList()) == null) {
                            objList = new ArrayList<ObjectForSubreport>();
                            elemDS.setList(objList);
                        }
                        ObjectForSubreport objectForSubreport = new ObjectForSubreport();
                        String network = result[2];
                        if (result[3] != null && !result[3].isEmpty()) {
                            network = network.concat(" (").concat(result[3]).concat(")");
                        }
                        String jobNumberFormat = String.format("%03d", Integer.valueOf(result[1]));
                        objectForSubreport.setExpVal(jobNumberFormat);
                        objectForSubreport.setExp(ReportsUtils.stripNonValidXMLCharacters((String)network, (boolean)true));
                        objectForSubreport.setElGroup(NETWORKS_TITLE);
                        objList.add(objectForSubreport);
                        if (csvWriter != null) {
                            csvWriter.write(new String[]{name, result[2], result[3] != null && !result[3].isEmpty() ? result[3] : "", jobNumberFormat});
                        }
                        monitor.worked(1);
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                ElementGroupInfo elemGroupInfo = new ElementGroupInfo("");
                inputJobMap.put("", elemGroupInfo);
                this.parameters.put("separateColumn", Boolean.FALSE);
            }
            monitor.done();
            dataSource = new AAutoDataSource(inputJobMap);
            this.buildInputs4Appendix(jobList);
        }
        finally {
            if (csvWriter != null) {
                csvWriter.close();
            }
        }
        return dataSource;
    }

    protected String getProcedure() {
        return EZ_VIEWER_JOB_VS_NETWORK_PROC_NAME;
    }

    protected String getSelectiveProcedure() {
        return EZ_VIEWER_JOB_VS_NETWORK_SELECTIVE_PROC_NAME;
    }

    protected Collection getSelected() {
        return (Collection)this.getReportModel().getProperty(SELECTED_JOB_IDS);
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new JobVsNetworkReport(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    protected void putGenericParameters(Map params) {
        super.putGenericParams(params);
        this.parameters.put("showInputs1", this.parameters.get("showInputs"));
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(((Object)((Object)this)).getClass(), "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "group1.name");
        params.put("group1.name", externalized);
    }

    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.jobName"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.networkName"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.networkExpandedName"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.jobNumber")});
        }
    }

    class ComputeWithLock
    implements IMFRunnable {
        String[][] results;
        private Set params;
        private Map<Integer, ProgramInputNoGUI> inputMap;

        public ComputeWithLock(Set params) {
            this.params = params;
        }

        public void run(EZSourceConnection conn, IProgressMonitor monitor) {
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[this.params.size()]);
            Collections.fill(types, EZSourceDataType.String);
            this.results = conn.executeSQL(JobVsNetworkReportBuilder.getAAutoJobDetailsProc(conn.getProjectInfo().getDbEngine()), types, new ArrayList(this.params));
        }
    }
}

