/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.aauto.jobVsNet;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.report.application.ezreport.reports.aauto.AAutoReportWizard;
import com.ez.report.application.ezreport.reports.aauto.AAutoWizardDialog;
import com.ez.report.application.ezreport.reports.aauto.jobVsNet.JobVsNetworkJob;
import com.ez.report.application.model.AAutoJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.collectors.AAutoJobCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.viewer.execution.EZReportAnalysis;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class JobVsNetworkAnalysis
extends EZReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static String JOBS_PAGE_NAME = "aauto.job.page.name";

    public JobVsNetworkAnalysis() {
        this(null);
    }

    public JobVsNetworkAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    protected void processSpecificInput(EZObjectType objType, List<EZEntityID> list, List<BaseMainframeResourceInput> sel, Set<String> inputNames) {
        EZEntityID entity = objType.getEntID();
        list.add(entity);
        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
        if (prjSg != null) {
            EZSourceAAUTOJobIDSg jobIDSg;
            if (!prjSg.getProjectName().equals(this.projectName)) {
                this.setPrjName(prjSg.getProjectName());
                this.addContextValue("input_project_names", prjSg.getProjectName());
                ProjectInfo pInfo = prjSg.getProjectInfo();
                com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
            }
            if ((jobIDSg = (EZSourceAAUTOJobIDSg)objType.getEntID().getSegment(EZSourceAAUTOJobIDSg.class)) != null) {
                String name = jobIDSg.getResourceName();
                sel.add((BaseMainframeResourceInput)new AAutoJob(jobIDSg.getJobId(), name));
                inputNames.add(name);
            }
        }
    }

    @Override
    protected PrepareReportWizard getWizard() {
        AAutoReportWizard wizard = new AAutoReportWizard();
        String wizardName = Messages.getString(JobVsNetworkAnalysis.class, "wizard.title");
        wizard.setWindowTitle(wizardName);
        GenericSelectInputPage4Report selectPage = new GenericSelectInputPage4Report(JOBS_PAGE_NAME);
        AAutoJobCollector collector = new AAutoJobCollector();
        selectPage.setResourcesCollector((ResourcesCollector)collector);
        selectPage.setSelectedPropName("selected resources");
        selectPage.setLeftGroupLabel(Messages.getString(JobVsNetworkAnalysis.class, "av.resourceType.name"));
        selectPage.setRightGroupLabel(Messages.getString(JobVsNetworkAnalysis.class, "sel.resourceType.name"));
        wizard.addPage((IWizardPage)selectPage);
        return wizard;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, JobVsNetworkJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_JOBVSNETWORK_REPORT_ANALYSIS;
    }

    @Override
    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        AAutoWizardDialog dialog = new AAutoWizardDialog(shell, (IWizard)wiz);
        return dialog;
    }
}

