/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports;

import com.ez.common.model.BaseResourceInput;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.programSummary.SummaryDS;
import com.ez.report.application.reports.summary.StoredProcedureResults;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SC2DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.Triplet;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryGenericDataSource
extends com.ez.report.generation.common.datasource.SummaryGenericDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SummaryGenericDataSource.class);
    private Map prgSummaryEntriesMap = new HashMap();
    protected boolean showOnlySummary = false;
    private StoredProcedureResults data;
    protected Map<String, Set<String>> globalTotalsLists = new HashMap<String, Set<String>>();
    private static final String fileNameString = Messages.getString(SummaryGenericDataSource.class, "file.name");
    private static final String sqlTableNameString = Messages.getString(SummaryGenericDataSource.class, "sql.table.name");
    private static final String smartScreenNameString = Messages.getString(SummaryGenericDataSource.class, "smart.screen.name");
    private static final String logicalFileNameString = Messages.getString(SummaryGenericDataSource.class, "logical.file.name");
    private static final String printerFileNameString = Messages.getString(SummaryGenericDataSource.class, "printer.file.name");
    private static final String clFileNameString = Messages.getString(SummaryGenericDataSource.class, "cl.file.name");
    protected String idmsRecordNameString = Messages.getString(SummaryGenericDataSource.class, "idms.record.name");
    protected String idmsSetNameString = Messages.getString(SummaryGenericDataSource.class, "idms.set.name");
    private static final String includeNameString = Messages.getString(SummaryGenericDataSource.class, "include.name");
    private static final String smartTableNameString = Messages.getString(SummaryGenericDataSource.class, "smart.table.name");
    private static final String datacomTableNameString = Messages.getString(SummaryGenericDataSource.class, "datacom.table.name");
    private static final String imsdbNameString = Messages.getString(SummaryGenericDataSource.class, "imsdb.name");
    private static final String fileTocEntry = Messages.getString(SummaryGenericDataSource.class, "file.tocEntry");
    private static final String sqlTableTocEntry = Messages.getString(SummaryGenericDataSource.class, "sql.table.tocEntry");
    private static final String smartScreenTocEntry = Messages.getString(SummaryGenericDataSource.class, "smart.screen.tocEntry");
    private static final String logicalFileTocEntry = Messages.getString(SummaryGenericDataSource.class, "logical.file.tocEntry");
    private static final String printerFileTocEntry = Messages.getString(SummaryGenericDataSource.class, "printer.file.tocEntry");
    private static final String clFileTocEntry = Messages.getString(SummaryGenericDataSource.class, "cl.file.tocEntry");
    protected String includeTocEntry = Messages.getString(SummaryGenericDataSource.class, "include.tocEntry");
    private static final String smartTableTocEntry = Messages.getString(SummaryGenericDataSource.class, "smart.table.tocEntry");
    protected String idmsRecordTocEntry = Messages.getString(SummaryGenericDataSource.class, "idms.record.tocEntry");
    protected String idmsSetTocEntry = Messages.getString(SummaryGenericDataSource.class, "idms.set.tocEntry");
    private static final String datacomTableTocEntry = Messages.getString(SummaryGenericDataSource.class, "datacom.table.tocEntry");
    private static final String imsDBTocEntry = Messages.getString(SummaryGenericDataSource.class, "imsdb.tocEntry");
    protected String totalFileOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.file.occurences");
    private static final String totalSqlTableOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.sql.table.occurences");
    private static final String totalSmartScreenOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.smart.screen.occurences");
    private static final String totalLogicalFileOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.logical.occurences");
    private static final String totalPrinterFileOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.printer.file.occurences");
    private static final String totalClFileOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.cl.file.occurences");
    protected String totalIncludeOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.include.occurences");
    private static final String totalSmartTableOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.smart.table.occurences");
    protected String totalIDMSRecordOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.idms.record.occurences");
    protected String totalIDMSSetOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.idms.set.occurences");
    private static final String totalDatacomTableOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.datacom.table.occurences");
    private static final String totalProcOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.procedures.occurences");
    private static final String totalCallsOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.calls.occurences");
    private static final String totalBFPvaluesLbl = Messages.getString(SummaryGenericDataSource.class, "total.BFP.occurences");
    private static final String totalIMSDBOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.imsdb.occurences");
    private static final String avgFileOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.file.occurences");
    private static final String avgSqlTableOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.sql.table.occurences");
    private static final String avgSmartScreenOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.smart.screen.occurences");
    private static final String avgLogicalFileOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.logical.occurences");
    private static final String avgPrinterFileOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.printer.file.occurences");
    private static final String avgClFileOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.cl.file.occurences");
    private static final String avgIncludeOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.include.occurences");
    private static final String avgSmartTableOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.smart.table.occurences");
    private static final String avgIDMSRecordOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.idms.record.occurences");
    private static final String avgIDMSSetOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.idms.set.occurences");
    private static final String avgDatacomOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.datacom.occurences");
    private static final String avgProcOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.proc.occurences");
    private static final String avgCallsOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.calls.occurences");
    private static final String avgStmtsLbl = Messages.getString(SummaryGenericDataSource.class, "avg.stmts.occurences");
    private static final String avgBFPLbl = Messages.getString(SummaryGenericDataSource.class, "avg.BFP.occurences");
    private static final String avgIMSOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.imsdb.occurences");
    private static final String listingFileTitle = Messages.getString(SummaryGenericDataSource.class, "listing.file.title");
    private static final String listingSqlTableTitle = Messages.getString(SummaryGenericDataSource.class, "listing.sql.table.title");
    private static final String listingSmartScreenTitle = Messages.getString(SummaryGenericDataSource.class, "listing.smart.screen.title");
    private static final String listingLogicalFileTitle = Messages.getString(SummaryGenericDataSource.class, "listing.logical.title");
    private static final String listingPrinterFileTitle = Messages.getString(SummaryGenericDataSource.class, "listing.printer.file.title");
    private static final String listingClFileTitle = Messages.getString(SummaryGenericDataSource.class, "listing.cl.file.title");
    protected String listingIncludeTitle = Messages.getString(SummaryGenericDataSource.class, "listing.include.title");
    private static final String listingSmartTableTitle = Messages.getString(SummaryGenericDataSource.class, "listing.smart.table.title");
    protected String listingIdmsRecordTitle = Messages.getString(SummaryGenericDataSource.class, "listing.idms.record.title");
    protected String listingIdmsSetTitle = Messages.getString(SummaryGenericDataSource.class, "listing.idms.set.title");
    private static final String listingDatacomTableTitle = Messages.getString(SummaryGenericDataSource.class, "listing.datacom.table.title");
    private static final String listingImsDBTitle = Messages.getString(SummaryGenericDataSource.class, "listing.imsdb.title");
    private String listingIdmsxRecordTitle = Messages.getString(SummaryGenericDataSource.class, "listing.idmsx.record.title");
    private String listingIdmsxSetTitle = Messages.getString(SummaryGenericDataSource.class, "listing.idmsx.set.title");
    private String totalIDMSXRecordOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.idmsx.record.occurences");
    private String totalIDMSXSetOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "total.idmsx.set.occurences");
    private String idmsxRecordNameString = Messages.getString(SummaryGenericDataSource.class, "idmsx.record.name");
    private String idmsxSetNameString = Messages.getString(SummaryGenericDataSource.class, "idmsx.set.name");
    private String idmsxRecordTocEntry = Messages.getString(SummaryGenericDataSource.class, "idmsx.record.tocEntry");
    private String idmsxSetTocEntry = Messages.getString(SummaryGenericDataSource.class, "idmsx.set.tocEntry");
    private static final String avgIDMSXRecordOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.idmsx.record.occurences");
    private static final String avgIDMSXSetOccurencesLbl = Messages.getString(SummaryGenericDataSource.class, "avg.idmsx.set.occurences");
    private static final String totalStmtsLbl = Messages.getString(SummaryGenericDataSource.class, "total.linesOfCode.occurences");
    private Set<String> emptyProgs = new HashSet<String>();
    protected SummaryDS summaryDS = null;
    protected BaseSubreportDataSource prgTotalsDS;
    protected Map<Integer, Integer> prgByTypes = new HashMap<Integer, Integer>();
    protected Map<String, BaseResourceInput> prgs = new HashMap<String, BaseResourceInput>();
    protected String totalNoProgramsInReportLabel = Messages.getString(SummaryGenericDataSource.class, "total.noPrograms.inreport");
    private boolean isVME = false;
    protected CSVWriter csvWriter;

    public SummaryGenericDataSource(Map prgVsElemGroupMap, boolean showOnlySummary, CSVWriter csvWriter) {
        super(prgVsElemGroupMap);
        this.csvWriter = csvWriter;
        this.showOnlySummary = showOnlySummary;
        this.summaryDS = null;
        this.init();
    }

    protected void init() {
        super.init();
        Set inputPrgSet = this.prgVsElemGroupMap.keySet();
        ArrayList inputPrgList = new ArrayList(inputPrgSet);
        if (!this.isOnlySummary()) {
            Collections.sort(inputPrgList);
        }
        int i = 0;
        while (i < inputPrgList.size()) {
            Object in = inputPrgList.get(i);
            if (!this.isOnlySummary()) {
                this.list.add(i, this.prgVsElemGroupMap.get(in));
            } else if (i == 0) {
                this.list.add(i, new ElementGroupInfo(null));
            }
            if (in instanceof ProgramInputNoGUI) {
                ProgramInputNoGUI inpt = (ProgramInputNoGUI)inputPrgList.get(i);
                Integer nr = this.prgByTypes.get(inpt.getTypeCode());
                if (nr == null) {
                    nr = new Integer(0);
                    this.prgByTypes.put(inpt.getTypeCode(), nr);
                }
                nr = nr + 1;
                this.prgByTypes.put(inpt.getTypeCode(), nr);
            }
            ++i;
        }
    }

    protected JRDataSource getReportSummaryDS() {
        if (this.summaryDS == null) {
            HashMap<String, Triplet<SubreportDataSource, SubreportDataSource, SubreportDataSource>> summDS = new HashMap<String, Triplet<SubreportDataSource, SubreportDataSource, SubreportDataSource>>();
            String appName = "";
            Triplet pair = new Triplet();
            pair.setFirst((Object)this.getTotalSummaryDataSource(appName));
            pair.setSecond((Object)this.getAvgSummaryDataSource(appName));
            pair.setThird((Object)this.prgTotalsDS);
            summDS.put(appName, pair);
            this.summaryDS = new SummaryDS(summDS);
        }
        return this.summaryDS;
    }

    public void setData(StoredProcedureResults data) {
        String[][] resultsCalls;
        String[][] resultsStmts;
        String[][] resultsProc;
        this.data = data;
        String[][] resultsBFPCobol = data.resultsBFPCobol;
        String[][] resultsBFPNatural = data.resultsBFPNatural;
        String[][] resultsBFPAssembler = data.resultsBFPAssembler;
        String[][] resultsBFPPL1 = data.resultsBFPPl1;
        HashMap<String, String> programsWithNoData = new HashMap<String, String>();
        for (Object prgInput : this.prgVsElemGroupMap.keySet()) {
            programsWithNoData.put(((BaseResourceInput)prgInput).getResourceID().toString(), ((BaseResourceInput)prgInput).getName());
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (resultsBFPCobol != null) {
            int i = 0;
            while (i < resultsBFPCobol.length) {
                list.add(resultsBFPCobol[i]);
                programsWithNoData.remove(resultsBFPCobol[i][2]);
                ++i;
            }
        }
        if (resultsBFPPL1 != null) {
            int i = 0;
            while (i < resultsBFPPL1.length) {
                list.add(resultsBFPPL1[i]);
                programsWithNoData.remove(resultsBFPPL1[i][2]);
                ++i;
            }
        }
        if (resultsBFPNatural != null) {
            int i = 0;
            while (i < resultsBFPNatural.length) {
                list.add(resultsBFPNatural[i]);
                programsWithNoData.remove(resultsBFPNatural[i][2]);
                ++i;
            }
        }
        if (resultsBFPAssembler != null) {
            int i = 0;
            while (i < resultsBFPAssembler.length) {
                list.add(resultsBFPAssembler[i]);
                programsWithNoData.remove(resultsBFPAssembler[i][2]);
                ++i;
            }
        }
        this.emptyProgs.clear();
        if (!list.isEmpty()) {
            int k = 0;
            while (k < list.size()) {
                String prgID = ((String[])list.get(k))[2];
                if (!this.isOnlySummary()) {
                    ObjectForSubreport obj = new ObjectForSubreport();
                    obj.setExp(totalBFPvaluesLbl);
                    obj.setExpVal(((String[])list.get(k))[1]);
                    List summaryList = this.getSummaryList(prgID);
                    summaryList.add(obj);
                }
                this.emptyProgs.add(prgID);
                ++k;
            }
        }
        if ((resultsProc = data.resultsProceduresOccurrences) != null) {
            int k = 0;
            while (k < resultsProc.length) {
                String prgID = resultsProc[k][2];
                ObjectForSubreport obj = null;
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)resultsProc[k][1]) == null) {
                    resultsProc[k][1] = "0";
                } else if (!this.isOnlySummary() && !resultsProc[k][1].equals("0")) {
                    obj = new ObjectForSubreport();
                    obj.setExp(totalProcOccurencesLbl);
                    obj.setExpVal(resultsProc[k][1]);
                }
                this.sumGlobalTotal("totalProcNumber", Integer.parseInt(resultsProc[k][1]), null);
                if (!this.isOnlySummary() && obj != null) {
                    List summaryList = this.getSummaryList(prgID);
                    if (obj != null) {
                        summaryList.add(obj);
                    }
                }
                this.emptyProgs.add(prgID);
                ++k;
            }
            data.resultsProceduresOccurrences = null;
        }
        if ((resultsStmts = data.resultsStmtsOccurrences) != null) {
            int k = 0;
            while (k < resultsStmts.length) {
                String prgID = resultsStmts[k][2];
                NumberFormat nf = NumberFormat.getNumberInstance();
                ObjectForSubreport locObj = null;
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)resultsStmts[k][1]) == null) {
                    resultsStmts[k][1] = "0";
                }
                try {
                    Number n = nf.parse(resultsStmts[k][1]);
                    if (!this.isOnlySummary() && !resultsStmts[k][1].equals("0")) {
                        locObj = new ObjectForSubreport();
                        locObj.setExp(totalStmtsLbl);
                        locObj.setExpVal(resultsStmts[k][1]);
                    }
                    this.sumGlobalTotal("totalLOCNumber", n.intValue(), null);
                }
                catch (ParseException e) {
                    L.error("cannot convert {}, using 0", (Object)resultsProc[k][1], (Object)e);
                }
                if (!this.isOnlySummary() && locObj != null) {
                    List summaryList = this.getSummaryList(prgID);
                    if (locObj != null) {
                        summaryList.add(locObj);
                    }
                }
                this.emptyProgs.add(prgID);
                ++k;
            }
            data.resultsStmtsOccurrences = null;
        }
        if ((resultsCalls = data.resultsCallsOccurrences) != null) {
            String keyID;
            String prevParent = "";
            Integer value = new Integer(0);
            int k = 0;
            while (k < resultsCalls.length) {
                String ancestor = resultsCalls[k][4];
                if (prevParent != null && !prevParent.isEmpty() && ancestor != null && !ancestor.isEmpty() && prevParent.equalsIgnoreCase(ancestor)) {
                    value = value + Integer.valueOf(resultsCalls[k][1]);
                } else {
                    ObjectForSubreport obj = null;
                    if (value != 0) {
                        String keyID2;
                        String string = keyID2 = resultsCalls[k - 1][4] != null ? resultsCalls[k - 1][4] : resultsCalls[k - 1][3];
                        if (!this.isOnlySummary()) {
                            obj = new ObjectForSubreport();
                            obj.setExp(totalCallsOccurencesLbl);
                            obj.setExpVal(value.toString());
                            List summaryList = this.getSummaryList(keyID2);
                            summaryList.add(obj);
                        }
                        this.sumGlobalTotal("totalCallsNumber", value, null);
                        this.emptyProgs.add(keyID2);
                    }
                    value = Integer.valueOf(resultsCalls[k][1]);
                    prevParent = ancestor;
                }
                ++k;
            }
            String string = prevParent != null && !prevParent.isEmpty() ? prevParent : (keyID = resultsCalls[resultsCalls.length - 1][4] != null ? resultsCalls[resultsCalls.length - 1][4] : resultsCalls[resultsCalls.length - 1][3]);
            if (!this.isOnlySummary()) {
                ObjectForSubreport obj = new ObjectForSubreport();
                obj.setExp(totalCallsOccurencesLbl);
                obj.setExpVal(value.toString());
                List summaryList = this.getSummaryList(keyID);
                summaryList.add(obj);
            }
            this.sumGlobalTotal("totalCallsNumber", value, null);
            this.emptyProgs.add(keyID);
            data.resultsCallsOccurrences = null;
        }
        this.emptyProgs.addAll(programsWithNoData.keySet());
        String[][] resultsPrgsVSInclude = data.resultsPrgsVSInclude;
        if (resultsPrgsVSInclude == null) {
            L.warn("no results for includes used in summary report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgsVSInclude, "totalIncludeNumber", factory, 0, 1, null, this.listingIncludeTitle, this.totalIncludeOccurencesLbl, includeNameString, this.includeTocEntry);
            data.resultsPrgsVSInclude = null;
        }
        String[][] resultsPrgVSFiles = data.resultsPrgsVSFile;
        if (resultsPrgVSFiles == null) {
            L.warn("no results for UsedFiles in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgVSFiles, "totalFilesNumber", factory, 0, 2, null, listingFileTitle, this.totalFileOccurencesLbl, fileNameString, fileTocEntry);
            data.resultsPrgsVSFile = null;
        }
        String[][] resultsPrgVSCLFile = data.resultsPrgsVSCLFile;
        if (resultsPrgVSCLFile == null) {
            L.warn("no results for CLFile in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgVSCLFile, "totalCLFileNumber", factory, 0, 2, null, listingClFileTitle, totalClFileOccurencesLbl, clFileNameString, clFileTocEntry);
            data.resultsPrgsVSCLFile = null;
        }
        String[][] resultsPrgVSPrinterFile = data.resultsPrgsVSPrinterFile;
        if (resultsPrgVSPrinterFile == null) {
            L.warn("no results for PrinterFile in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgVSPrinterFile, "totalPrinterFileNumber", factory, 0, 2, null, listingPrinterFileTitle, totalPrinterFileOccurencesLbl, printerFileNameString, printerFileTocEntry);
            data.resultsPrgsVSPrinterFile = null;
        }
        String[][] resultsPrgVSLogicalFile = data.resultsPrgsVSLogicalFile;
        if (resultsPrgVSLogicalFile == null) {
            L.warn("no results for Logical Files in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgVSLogicalFile, "totalLogicalFileNumber", factory, 0, 2, null, listingLogicalFileTitle, totalLogicalFileOccurencesLbl, logicalFileNameString, logicalFileTocEntry);
            data.resultsPrgsVSLogicalFile = null;
        }
        String[][] resultsPrgVSSmartScreen = data.resultsPrgsVSSmartScreen;
        if (resultsPrgVSSmartScreen == null) {
            L.warn("no results for Smart Screen in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgVSSmartScreen, "totalSmartScreenNumber", factory, 0, 2, null, listingSmartScreenTitle, totalSmartScreenOccurencesLbl, smartScreenNameString, smartScreenTocEntry);
            data.resultsPrgsVSSmartScreen = null;
        }
        String[][] resultsPrgsVSSmartTable = data.resultsPrgsVSSmartTables;
        if (resultsPrgsVSSmartTable == null) {
            L.warn("no results for smart table in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgsVSSmartTable, "totalSmartTableNumber", factory, 0, 1, null, listingSmartTableTitle, totalSmartTableOccurencesLbl, smartTableNameString, smartTableTocEntry);
            data.resultsPrgsVSSmartTables = null;
        }
        String[][] resultsPrgsVSSQLTables = data.resultsPrgsVSSQLTables;
        if (resultsPrgsVSSQLTables == null) {
            L.warn("no results for SQL TABLES in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgsVSSQLTables, "totalSQLTableNumber", factory, 0, 2, null, listingSqlTableTitle, totalSqlTableOccurencesLbl, sqlTableNameString, sqlTableTocEntry);
            data.resultsPrgsVSSQLTables = null;
        }
        String[][] resultsPrgsVSIDMSRecord = data.resultsPrgsVSIDMSRecord;
        if (resultsPrgsVSIDMSRecord == null) {
            L.warn("no results for IDMS/IDMSX RECORD in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgsVSIDMSRecord, "totalIDMSRecordNumber", factory, 0, 2, null, this.isVME ? this.listingIdmsxRecordTitle : this.listingIdmsRecordTitle, this.isVME ? this.totalIDMSXRecordOccurencesLbl : this.totalIDMSRecordOccurencesLbl, this.isVME ? this.idmsxRecordNameString : this.idmsRecordNameString, this.isVME ? this.idmsxRecordTocEntry : this.idmsRecordTocEntry);
            data.resultsPrgsVSIDMSRecord = null;
        }
        String[][] resultsPrgsVSIDMSSet = data.resultsPrgsVSIDMSSet;
        if (resultsPrgsVSIDMSSet == null) {
            L.warn("no results for IDMS SET/IDMSX in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgsVSIDMSSet, "totalIDMSSetNumber", factory, 0, 2, null, this.isVME ? this.listingIdmsxSetTitle : this.listingIdmsSetTitle, this.isVME ? this.totalIDMSXSetOccurencesLbl : this.totalIDMSSetOccurencesLbl, this.isVME ? this.idmsxSetNameString : this.idmsSetNameString, this.isVME ? this.idmsxSetTocEntry : this.idmsSetTocEntry);
            data.resultsPrgsVSIDMSSet = null;
        }
        String[][] resultsPrgsVSDatacomTables = data.resultsPrgsVSDatacomTables;
        if (resultsPrgsVSDatacomTables == null) {
            L.warn("no results for Datacom TABLES in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            this.fill(resultsPrgsVSDatacomTables, "totalDatacomTableNumber", factory, 0, 2, null, listingDatacomTableTitle, totalDatacomTableOccurencesLbl, datacomTableNameString, datacomTableTocEntry);
            data.resultsPrgsVSDatacomTables = null;
        }
        String[][] resultsPrgsVSIMSDB = data.resultsPrgVsIMSDB;
        if (resultsPrgsVSIMSDB == null) {
            L.warn("no results for IMS/DB in summary report report");
        } else {
            DSFactory factory = new DSFactory();
            Properties pref = new Properties();
            pref.setProperty(String.valueOf(18), Utils.getExternalizedType4IMS((Integer)18));
            pref.setProperty(String.valueOf(19), Utils.getExternalizedType4IMS((Integer)19));
            this.fill(resultsPrgsVSIMSDB, "totalIMSDBNumber", factory, 0, 2, imsdbNameString, listingImsDBTitle, totalIMSDBOccurencesLbl, pref, imsDBTocEntry);
            data.resultsPrgVsIMSDB = null;
        }
        this.setAdditionalData(data);
        if (!this.emptyProgs.isEmpty() && !this.isOnlySummary()) {
            this.fillSummaryOnly(0);
        }
    }

    protected void setAdditionalData(StoredProcedureResults data) {
    }

    private void fillSummaryOnly(int summaryDSKind) {
        DSFactory factory = new DSFactory();
        for (String prgID : this.emptyProgs) {
            BaseResourceInput prg = this.getProgramInput(prgID, this.prgVsElemGroupMap);
            if (prg == null) {
                L.warn("Program with ID {} is not an input. Needs correct ancestor ID for assebmbler program", (Object)prgID);
                continue;
            }
            String prgName = prg.getListableName();
            ElementGroupInfo elem = (ElementGroupInfo)this.prgVsElemGroupMap.get(prg);
            if (elem == null || elem.hasSummaryAdded) continue;
            List summaryList = (List)this.prgSummaryEntriesMap.get(prgID);
            if (summaryList != null) {
                BaseSubreportDataSource summaryDS = factory.createDS(summaryDSKind);
                summaryDS.setList(summaryList);
                summaryDS.setTitle(null);
                elem.addDataSource((SubreportDataSource)summaryDS);
                elem.hasSummaryAdded = true;
                this.writeLineToCSVForProgramsInventory(prgName, Messages.getString(SummaryGenericDataSource.class, "csv.noResources.label"));
                continue;
            }
            L.debug("prg {} has no summary", (Object)prgName);
            this.writeLineToCSVForProgramsInventory(prgName, Messages.getString(SummaryGenericDataSource.class, "csv.noData.label"));
        }
    }

    protected BaseResourceInput getProgramInput(String prgID, Map prgVsElemGroupMap) {
        BaseResourceInput inpt = this.prgs.get(prgID);
        if (inpt == null) {
            for (BaseResourceInput prg : prgVsElemGroupMap.keySet()) {
                String resID = prg.getResourceID().toString();
                if (resID.equals(prgID)) {
                    inpt = prg;
                    break;
                }
                if (prg.getTypeCode() != 8 || resID.equals(prgID) || ((ProgramInputNoGUI)prg).getChildrenIDs() == null || !((ProgramInputNoGUI)prg).getChildrenIDs().contains(Integer.valueOf(prgID))) continue;
                inpt = prg;
                break;
            }
            if (inpt != null) {
                this.prgs.put(prgID, inpt);
            }
        }
        return inpt;
    }

    protected void fill(String[][] results, String globalTotal, DSFactory factory, int summaryDSKind, int elemDSKind, String summaryTitle, String elemTitle, String summaryEntry, String groupPrefix, String tocEntry) {
        Properties pref = new Properties();
        pref.setProperty("0", groupPrefix);
        this.fill(results, globalTotal, factory, summaryDSKind, elemDSKind, summaryTitle, elemTitle, summaryEntry, pref, tocEntry);
    }

    private void fill(String[][] results, String globalTotal, DSFactory factory, int summaryDSKind, int elemDSKind, String summaryTitle, String elemTitle, String summaryEntry, Properties groupPrefixes, String tocEntry) {
        HashSet<String> countMap = new HashSet<String>();
        String oldPrgID = null;
        List summaryList = null;
        ElementGroupInfo elem = null;
        ArrayList<ObjectForSubreport> objList = null;
        ObjectForSubreport obj = null;
        int i = 0;
        while (i < results.length) {
            String prgName = this.getProgramKey(results[i]);
            String prgID = this.detectProgramInput(results[i]);
            BaseResourceInput programInput = this.getProgramInput(prgID, this.prgVsElemGroupMap);
            prgName = programInput.getListableName();
            if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)prgName) != null) {
                boolean firstAdd;
                if (oldPrgID == null || !oldPrgID.equalsIgnoreCase(prgID)) {
                    if (oldPrgID != null) {
                        if (!this.isOnlySummary()) {
                            obj = new ObjectForSubreport();
                            obj.setExp(summaryEntry);
                            obj.setExpVal("" + countMap.size());
                            summaryList = this.getSummaryList(oldPrgID);
                            summaryList.add(obj);
                        }
                        this.sumGlobalTotal(globalTotal, null, countMap);
                    }
                    countMap.clear();
                    if (!this.isOnlySummary()) {
                        summaryList = this.getSummaryList(prgID);
                        elem = (ElementGroupInfo)this.prgVsElemGroupMap.get(programInput);
                        if (elem != null && !elem.hasSummaryAdded) {
                            BaseSubreportDataSource summaryDS = factory.createDS(summaryDSKind);
                            summaryDS.setList(summaryList);
                            summaryDS.setTitle(summaryTitle);
                            elem.addDataSource((SubreportDataSource)summaryDS);
                            elem.hasSummaryAdded = true;
                            if (!this.emptyProgs.remove(programInput.getResourceID().toString())) {
                                this.emptyProgs.remove(programInput.getResourceID().toString());
                            }
                        }
                        objList = new ArrayList<ObjectForSubreport>();
                        BaseSubreportDataSource elemDS = factory.createDS(elemDSKind);
                        elemDS.setList(objList);
                        elemDS.setTitle(elemTitle);
                        elemDS.setTocEntry(tocEntry);
                        elem.addDataSource((SubreportDataSource)elemDS);
                    }
                    oldPrgID = prgID;
                }
                String groupPrefix = null;
                if (!this.isOnlySummary()) {
                    String type = "0";
                    if (groupPrefixes.size() > 1) {
                        try {
                            type = results[i][results[i].length - 1];
                        }
                        catch (Exception ex) {
                            L.warn("error at trying to find groupprefix for element: {}", (Object)elemTitle, (Object)ex);
                        }
                    }
                    groupPrefix = groupPrefixes.getProperty(type);
                    obj = factory.createObj(elemDSKind, results[i], groupPrefix);
                    objList.add(obj);
                }
                if (firstAdd = countMap.add(results[i][1])) {
                    String prgNameForCsv = prgName;
                    if (programInput != null) {
                        prgNameForCsv = programInput.getListableName();
                    }
                    this.writeLineToCSVForProgramsInventory(prgNameForCsv, groupPrefix, results[i][1]);
                }
            }
            ++i;
        }
        this.sumGlobalTotal(globalTotal, null, countMap);
        if (!this.isOnlySummary()) {
            obj = new ObjectForSubreport();
            obj.setExp(summaryEntry);
            obj.setExpVal("" + countMap.size());
            summaryList.add(obj);
        }
    }

    private String detectProgramInput(String[] results) {
        if (results.length > 5) {
            return results[5] != null ? results[5] : results[4];
        }
        return results[4];
    }

    protected String getProgramKey(String[] results) {
        return results[0];
    }

    private void sumGlobalTotal(String globalTotal, Integer total, Set<String> countMap) {
        if (countMap != null && countMap.size() != 0) {
            Map<String, Set<String>> totals = this.globalTotalsLists;
            Set<String> value = null;
            if (totals != null) {
                value = totals.get(globalTotal);
            } else {
                totals = new HashMap<String, Set<String>>();
                this.globalTotalsLists.putAll(totals);
            }
            if (value == null) {
                value = new HashSet<String>();
                totals.put(globalTotal, value);
            }
            value.addAll(countMap);
        } else if (total != null && total != 0) {
            String appName = "";
            HashMap<String, Integer> totals = (HashMap<String, Integer>)this.globalTotals.get(appName);
            Integer value = null;
            if (totals != null) {
                value = (Integer)totals.get(globalTotal);
            } else {
                totals = new HashMap<String, Integer>();
                this.globalTotals.put(appName, totals);
            }
            int current = total;
            if (value != null) {
                current = value + total;
            }
            totals.put(globalTotal, current);
        }
    }

    private void putGlobalTotal(String appName, String globalTotal, double total) {
        HashMap<String, Double> totals = (HashMap<String, Double>)this.globalTotals.get(appName);
        if (totals == null) {
            totals = new HashMap<String, Double>();
            this.globalTotals.put(appName, totals);
        }
        totals.put(globalTotal, total);
    }

    private String getAvg(String appName, String globalTotal, Integer prgNo) {
        Map appTotals = (Map)this.globalTotals.get(appName);
        String strValue = null;
        if (appTotals != null) {
            Number val = (Number)appTotals.get(globalTotal);
            if (val == null && this.globalTotalsLists != null) {
                Set<String> totalList = this.globalTotalsLists.get(globalTotal);
                Number number = val = totalList != null ? Integer.valueOf(totalList.size()) : null;
            }
            if (val != null) {
                double avg = val.doubleValue() / (double)prgNo.intValue();
                if (avg <= 0.05) {
                    strValue = "< 0.1";
                } else {
                    Double avgDouble = new Double(avg);
                    NumberFormat f = NumberFormat.getNumberInstance();
                    if (f instanceof DecimalFormat) {
                        ((DecimalFormat)f).setMaximumFractionDigits(1);
                        strValue = f.format(avgDouble);
                    }
                }
            }
        }
        return strValue;
    }

    protected String getTotal(String appName, String globalTotal) {
        Map appTotals = (Map)this.globalTotals.get(appName);
        Number intgVal = null;
        if (appTotals != null) {
            intgVal = (Number)appTotals.get(globalTotal);
        }
        if (intgVal == null && this.globalTotalsLists != null) {
            Set<String> totalList = this.globalTotalsLists.get(globalTotal);
            intgVal = totalList != null ? Integer.valueOf(totalList.size()) : null;
        }
        return intgVal != null ? intgVal.toString() : null;
    }

    private List getSummaryList(String prgID) {
        ArrayList summaryList = (ArrayList)this.prgSummaryEntriesMap.get(prgID);
        if (summaryList == null) {
            summaryList = new ArrayList();
            this.prgSummaryEntriesMap.put(prgID, summaryList);
        }
        return summaryList;
    }

    protected SubreportDataSource getTotalSummaryDataSource(String appName) {
        SC2DataSource subReportDS = null;
        ArrayList<ObjectForSubreport> list2 = new ArrayList<ObjectForSubreport>();
        ObjectForSubreport obj = null;
        String[][] totalCobol = (String[][])this.data.totalBFPCobol.get(appName);
        String[][] totalNatural = (String[][])this.data.totalBFPNatural.get(appName);
        String[][] totalPL1 = (String[][])this.data.totalBFPPl1.get(appName);
        String[][] totalAssembler = (String[][])this.data.totalBFPAssembler.get(appName);
        boolean makeBFPEntry = false;
        double ttotal = 0.0;
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(1);
        Number n = null;
        if (totalCobol != null && com.ez.mainframe.data.utils.Utils.filterNullValue((String)totalCobol[0][0]) != null) {
            try {
                n = nf.parse(totalCobol[0][0]);
                ttotal += n.doubleValue();
            }
            catch (ParseException e) {
                L.error("cannot convert totalCobol: {}, using 0", (Object)totalCobol[0][0], (Object)e);
            }
            makeBFPEntry = true;
        }
        if (totalNatural != null && com.ez.mainframe.data.utils.Utils.filterNullValue((String)totalNatural[0][0]) != null) {
            try {
                n = nf.parse(totalNatural[0][0]);
                ttotal += n.doubleValue();
            }
            catch (ParseException e) {
                L.error("cannot convert totalNatural: {}, using 0", (Object)totalNatural[0][0], (Object)e);
            }
            makeBFPEntry = true;
        }
        if (totalAssembler != null && com.ez.mainframe.data.utils.Utils.filterNullValue((String)totalAssembler[0][0]) != null) {
            try {
                n = nf.parse(totalAssembler[0][0]);
                ttotal += n.doubleValue();
            }
            catch (ParseException e) {
                L.error("cannot convert totalAssembler: {}, using 0", (Object)totalAssembler[0][0], (Object)e);
            }
            makeBFPEntry = true;
        }
        if (totalPL1 != null && com.ez.mainframe.data.utils.Utils.filterNullValue((String)totalPL1[0][0]) != null) {
            try {
                n = nf.parse(totalPL1[0][0]);
                ttotal += n.doubleValue();
            }
            catch (ParseException e) {
                L.error("cannot convert totalPl1: {}, using 0", (Object)totalPL1[0][0], (Object)e);
            }
            makeBFPEntry = true;
        }
        if (makeBFPEntry) {
            obj = new ObjectForSubreport();
            obj.setExp(totalBFPvaluesLbl);
            obj.setExpVal(nf.format(ttotal));
            list2.add(obj);
            this.putGlobalTotal(appName, "totalBFP", ttotal);
        }
        String total = null;
        total = this.getTotal(appName, "totalLOCNumber");
        if (total != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalStmtsLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalProcNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalProcOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalCallsNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalCallsOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalIncludeNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(this.totalIncludeOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalFilesNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(this.totalFileOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalSmartTableNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalSmartTableOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalSmartScreenNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalSmartScreenOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalCLFileNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalClFileOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalPrinterFileNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalPrinterFileOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalLogicalFileNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalLogicalFileOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalSQLTableNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalSqlTableOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalIDMSRecordNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(this.isVME ? this.totalIDMSXRecordOccurencesLbl : this.totalIDMSRecordOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalIDMSSetNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(this.isVME ? this.totalIDMSXSetOccurencesLbl : this.totalIDMSSetOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalDatacomTableNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalDatacomTableOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, "totalIMSDBNumber")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(totalIMSDBOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if (this.prgByTypes != null && this.prgByTypes.keySet().size() == 1) {
            Integer prgType = this.prgByTypes.keySet().iterator().next();
            Integer prgNo = this.prgByTypes.get(prgType);
            String totalPrgsInReportString = this.getTotalLabelPrgsByType(prgType);
            obj = new ObjectForSubreport();
            obj.setExp(totalPrgsInReportString);
            obj.setExpVal("" + prgNo);
            list2.add(obj);
        } else {
            this.buildPrgByTypesTotals(this.prgByTypes);
        }
        if (!list2.isEmpty()) {
            subReportDS = new SC2DataSource(null, list2);
        }
        return subReportDS;
    }

    protected String getTotalLabelPrgsByType(Integer prgType) {
        return Messages.getString(SummaryGenericDataSource.class, "total.prgs.type.inreport", new String[]{this.getResourceTypesForSummary(prgType)});
    }

    protected String getResourceTypesForSummary(Integer prgType) {
        return com.ez.mainframe.data.utils.Utils.getExternalizedType((Integer)prgType);
    }

    protected void buildPrgByTypesTotals(Map<Integer, Integer> prgByTypes) {
        ArrayList<ObjectForSubreport> lst = new ArrayList<ObjectForSubreport>();
        this.prgTotalsDS = new SC1DataSource(null, lst);
        if (prgByTypes == null || prgByTypes.keySet().size() == 0) {
            ObjectForSubreport obj = new ObjectForSubreport();
            obj.setExp(this.totalNoProgramsInReportLabel);
            obj.setExpVal("");
            lst.add(obj);
        } else {
            int total = 0;
            for (Integer type : prgByTypes.keySet()) {
                ObjectForSubreport obj = new ObjectForSubreport();
                String totalString = this.getTotalLabelElementsByType(type);
                obj.setExp(totalString);
                Integer prgNo = prgByTypes.get(type);
                obj.setExpVal("" + prgNo);
                lst.add(obj);
                total += prgNo.intValue();
            }
            this.sortInputsSummarySubreport(lst);
            String totalPrgsInReportString = this.getTotalLabelPrograms(total);
            this.prgTotalsDS.setDecision(totalPrgsInReportString);
            this.prgTotalsDS.setExtraTitle(this.summaryExtraTitle);
        }
    }

    protected String getTotalLabelPrograms(int total) {
        return Messages.getString(SummaryGenericDataSource.class, "total.prgs.inreport", new String[]{String.valueOf(total)});
    }

    protected String getTotalLabelElementsByType(Integer type) {
        return Messages.getString(SummaryGenericDataSource.class, "total.elements.byType.inSummary", new String[]{this.getResourceTypesForSummary(type)});
    }

    protected void sortInputsSummarySubreport(List<ObjectForSubreport> lst) {
    }

    protected Integer getPrgNo(String appName, Integer prgType) {
        if (prgType == null) {
            return this.prgVsElemGroupMap.size();
        }
        return this.prgByTypes.get(prgType);
    }

    protected SubreportDataSource getAvgSummaryDataSource(String appName) {
        SC2DataSource subReportDS = null;
        ArrayList<ObjectForSubreport> list2 = new ArrayList<ObjectForSubreport>();
        ObjectForSubreport obj = null;
        Integer prgNo = this.getPrgNo(appName, null);
        String total = this.getAvg(appName, "totalBFP", prgNo);
        if (total != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgBFPLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalLOCNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgStmtsLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalProcNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgProcOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalCallsNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgCallsOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalIncludeNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgIncludeOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalFilesNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgFileOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalSmartTableNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgSmartTableOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalSmartScreenNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgSmartScreenOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalCLFileNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgClFileOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalPrinterFileNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgPrinterFileOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalLogicalFileNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgLogicalFileOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalSQLTableNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgSqlTableOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalIDMSRecordNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(this.isVME ? avgIDMSXRecordOccurencesLbl : avgIDMSRecordOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalIDMSSetNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(this.isVME ? avgIDMSXSetOccurencesLbl : avgIDMSSetOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalDatacomTableNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgDatacomOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getAvg(appName, "totalIMSDBNumber", prgNo)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(avgIMSOccurencesLbl);
            obj.setExpVal(total);
            list2.add(obj);
        }
        if (!list2.isEmpty()) {
            subReportDS = new SC2DataSource(null, list2);
        }
        return subReportDS;
    }

    protected boolean isOnlySummary() {
        return this.showOnlySummary;
    }

    public void setIsVME(boolean isVME) {
        this.isVME = isVME;
    }

    protected void writeLineToCSVForProgramsInventory(String ... entries) {
        this.csvWriter.write(entries);
    }
}

