/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports;

import com.ez.analysisbrowser.actions.DescriptorAdapter;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.properties.ReportSettingsAction;
import com.ez.report.application.properties.ReportSettingsDialog;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SettingsDescriptor
extends DescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SettingsDescriptor.class);
    static final String ANALYSIS_TYPE_INPUTS = "ANALYSIS_TYPE_INPUTS";
    static final String PROJECT_INFO = "PROJECT_INFO";

    public SettingsDescriptor(EZAnalysis an) {
        super(an.getType());
    }

    public SettingsDescriptor(EZAnalysisType at) {
        super(at);
    }

    protected abstract String getAnalysisFolder();

    protected abstract ReportSettingsDialog getDialog(Shell var1, com.ez.ezsource.connection.ProjectInfo var2);

    public void contributeContextMenu(MenuManager menuMgr, IActionContext context) {
        ArrayList inputs = (ArrayList)context.getData().get(ANALYSIS_TYPE_INPUTS);
        EZObjectType ezObjectType = (EZObjectType)inputs.get(0);
        if (ezObjectType == null || !(ezObjectType instanceof EZSourceProjectInputType)) {
            return;
        }
        EZSourceProjectInputType inptType = (EZSourceProjectInputType)ezObjectType;
        ProjectInfo pInfo = (ProjectInfo)inptType.getProperty(PROJECT_INFO);
        com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
        String prjName = prjInfo != null ? prjInfo.getProjectName() : inptType.getName();
        String folderPath = Utils.getProjectPathName((String)prjName).concat(File.separator).concat(this.getAnalysisFolder());
        File folder = new File(folderPath);
        File[] files = folder.listFiles();
        Shell shell = Display.getDefault().getActiveShell();
        if (files == null || files.length == 1) {
            ReportSettingsAction act = new ReportSettingsAction("default", prjName, this.getDialog(shell, prjInfo));
            act.setText(Messages.getString(SettingsDescriptor.class, "action.name"));
            menuMgr.add((IAction)act);
        } else {
            MenuManager submenu = new MenuManager(Messages.getString(SettingsDescriptor.class, "menu.label"));
            menuMgr.add((IContributionItem)submenu);
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isFile()) {
                    String fName = file.getName();
                    fName = fName.substring(0, fName.lastIndexOf("."));
                    ReportSettingsAction act = new ReportSettingsAction(fName, prjName, this.getDialog(shell, prjInfo));
                    submenu.add((IAction)act);
                }
                ++i;
            }
        }
    }
}

