/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.wizard;

import com.ez.common.ui.listselection.Listable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ReportInputPage<T extends Listable>
extends GenericSelectInputPage4Report<Listable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected boolean showOperators = true;
    protected String btnLabel = Messages.getString(ReportInputPage.class, "showOperatorsInAppendix.lbl");
    private Button btn;
    String propertyKey = "showOperators";

    public ReportInputPage(String pageName, boolean useFilters, boolean generateSummary) {
        this(pageName, useFilters, generateSummary, null, null);
    }

    public ReportInputPage(String pageName, boolean useFilters, boolean generateSummary, String propertyKey, String buttonLabel) {
        super(pageName, useFilters, generateSummary);
        this.showOperators = this.showInputsOption;
        if (propertyKey != null && !propertyKey.isEmpty()) {
            this.propertyKey = propertyKey;
        }
        if (buttonLabel != null && !buttonLabel.isEmpty()) {
            this.btnLabel = buttonLabel;
        }
    }

    protected void addShowAppendixOptions(Composite optGroup) {
        super.addShowAppendixOptions(optGroup);
        if (this.showOperators) {
            this.btn = new Button(optGroup, 32);
            this.btn.setText(this.btnLabel);
            this.btn.setSelection(this.optionValue);
            this.btn.setEnabled(this.btnAppendix.getSelection());
            this.wizard.set(this.propertyKey, (Object)this.optionValue);
            this.btn.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ReportInputPage.this.btn.getSelection();
                    ReportInputPage.this.wizard.set(ReportInputPage.this.propertyKey, (Object)selected);
                }
            });
            GridData data = new GridData();
            data.horizontalAlignment = 1;
            data.horizontalIndent = 20;
            data.verticalAlignment = 3;
            this.btn.setLayoutData((Object)data);
        }
    }

    protected void checkOnlySummary() {
        super.checkOnlySummary();
    }

    protected void checkAppendix() {
        super.checkAppendix();
        boolean showAppendix = this.btnAppendix.getSelection();
        if (this.btn != null) {
            this.btn.setEnabled(showAppendix);
            if (!showAppendix) {
                this.btn.setSelection(showAppendix);
                this.wizard.set(this.propertyKey, (Object)showAppendix);
            }
        }
        if (this.btnShowInputs != null) {
            this.btnShowInputs.setEnabled(showAppendix);
            if (!showAppendix) {
                this.btnShowInputs.setSelection(showAppendix);
                this.checkShowInputs();
            }
        }
    }
}

