/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.wizard;

import com.ez.ezsource.connection.ServerType;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.utils.Utils;
import java.util.ArrayList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternSearchPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PatternSearchPage.class);
    private PrepareReportWizard wizard = null;
    private List patternList;
    private Button addButton;
    private Text patternText;
    ArrayList<String> exps = new ArrayList();
    public static final char NOT_MARKER = '!';
    public static final String PATTERN_LIST = "pattern list";

    public PatternSearchPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString(PatternSearchPage.class, "patternPage.title"));
        this.setDescription(Messages.getString(PatternSearchPage.class, "patternPage.description"));
    }

    private void init() {
        this.wizard = (PrepareReportWizard)this.getWizard();
        this.wizard.set(PATTERN_LIST, this.exps);
    }

    public void createControl(Composite parent) {
        this.init();
        Composite composite = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 4;
        formLayout.marginHeight = 4;
        composite.setLayout((Layout)formLayout);
        GridData dat = new GridData();
        dat.grabExcessHorizontalSpace = true;
        dat.grabExcessVerticalSpace = true;
        dat.horizontalAlignment = 4;
        dat.verticalAlignment = 4;
        composite.setLayoutData((Object)dat);
        Label infoLabel = new Label(composite, 0x1000040);
        infoLabel.setText(Messages.getString(PatternSearchPage.class, "patternPage.infoText"));
        FormData data = new FormData();
        data.left = new FormAttachment(0, 70);
        data.right = new FormAttachment(100, -70);
        data.top = new FormAttachment(0, 0);
        infoLabel.setLayoutData((Object)data);
        Group group = new Group(composite, 16);
        group.setText(Messages.getString(PatternSearchPage.class, "patternPage.groupText"));
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)infoLabel);
        data.bottom = new FormAttachment(100, 0);
        group.setLayoutData((Object)data);
        formLayout = new FormLayout();
        formLayout.marginWidth = 4;
        formLayout.marginHeight = 4;
        group.setLayout((Layout)formLayout);
        Label patternLabel = new Label((Composite)group, 16384);
        patternLabel.setText(Messages.getString(PatternSearchPage.class, "patternPage.patternLabel"));
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        patternLabel.setLayoutData((Object)data);
        int space = 5;
        int margin = 70;
        this.patternText = new Text((Composite)group, 2048);
        this.addButton = new Button((Composite)group, 8);
        this.addButton.setEnabled(false);
        data = new FormData();
        data.left = new FormAttachment(0, margin);
        data.right = new FormAttachment((Control)this.addButton, -space, 16384);
        data.top = new FormAttachment((Control)patternLabel);
        this.patternText.setLayoutData((Object)data);
        this.patternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PatternSearchPage.this.patternText.getText() == null || PatternSearchPage.this.patternText.getText().isEmpty()) {
                    PatternSearchPage.this.addButton.setEnabled(false);
                } else {
                    PatternSearchPage.this.addButton.setEnabled(true);
                }
            }
        });
        this.addButton.computeSize(-1, -1);
        data = new FormData();
        data.right = new FormAttachment(100, -margin);
        data.top = new FormAttachment((Control)patternLabel);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = PatternSearchPage.this.patternText.getText();
                if (this.verifyInput(text)) {
                    String escapedText = text;
                    if (!Utils.isSpecialExpression((String)escapedText)) {
                        int engine = ServerType.Access.getValue();
                        engine = PatternSearchPage.this.wizard.getProjectDatabaseEngine();
                        if (ServerType.SqlServer.getValue() == engine || ServerType.Db2Z.getValue() == engine || ServerType.Db2.getValue() == engine) {
                            escapedText = Utils.escapeText((String)text);
                        } else if (ServerType.Access.getValue() == engine) {
                            escapedText = Utils.transformExprForAccess((String)text);
                        }
                    }
                    if (!PatternSearchPage.this.exps.contains(escapedText)) {
                        PatternSearchPage.this.exps.add(0, escapedText);
                        PatternSearchPage.this.patternList.add(text, 0);
                        PatternSearchPage.this.patternList.setSelection(0);
                    } else {
                        int i = PatternSearchPage.this.exps.indexOf(escapedText);
                        if (i != -1) {
                            PatternSearchPage.this.patternList.setSelection(i);
                        }
                    }
                    PatternSearchPage.this.patternText.setText("");
                    PatternSearchPage.this.setPageComplete(true);
                }
            }

            private boolean verifyInput(String text) {
                return true;
            }
        });
        this.addButton.setText(Messages.getString(PatternSearchPage.class, "patternPage.addButton"));
        this.patternList = new List((Composite)group, 2048);
        this.patternList.setSize(200, 300);
        Composite removeButtonsPanel = new Composite((Composite)group, 0);
        data = new FormData();
        data.left = new FormAttachment(0, 70);
        data.right = new FormAttachment(100, -70);
        data.top = new FormAttachment((Control)this.patternText, 20);
        data.bottom = new FormAttachment((Control)removeButtonsPanel);
        this.patternList.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        removeButtonsPanel.setLayoutData((Object)data);
        RowLayout rl = new RowLayout(256);
        rl.spacing = 50;
        rl.justify = true;
        rl.wrap = false;
        rl.marginLeft = 100;
        rl.marginRight = 100;
        removeButtonsPanel.setLayout((Layout)rl);
        Button removeButton = new Button(removeButtonsPanel, 8);
        removeButton.setText(Messages.getString(PatternSearchPage.class, "patternPage.removeButton"));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternSearchPage.this.remove(false);
            }
        });
        Button removeAllButton = new Button(removeButtonsPanel, 8);
        removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternSearchPage.this.remove(true);
            }
        });
        removeAllButton.setText(Messages.getString(PatternSearchPage.class, "patternPage.removeAllButton"));
        group.pack();
        composite.pack();
        parent.layout();
        this.setControl((Control)composite);
    }

    protected void remove(boolean all) {
        if (all) {
            this.exps.clear();
            this.patternList.removeAll();
            this.setPageComplete(false);
        } else {
            int i = this.patternList.getSelectionIndex();
            if (i != -1) {
                this.patternList.remove(i);
                this.exps.remove(i);
                this.setPageComplete(this.exps.size() > 0);
            }
        }
    }

    public boolean isPageComplete() {
        boolean ret = false;
        ret = this.exps.size() > 0;
        return ret;
    }

    public void performHelp() {
        super.performHelp();
    }

    public void dispose() {
        this.wizard = null;
        super.dispose();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.patternText.setFocus();
    }
}

