/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.wizard;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.VariableOrBrowsePage;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactSettingsPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactSettingsPage.class);
    private Group directionGroup;
    private Button forward;
    private Button backward;
    private boolean showDirectionChoice;
    private Group depthChoiceGroup;
    private Button depthChoice;
    private Text depthText;
    private String description;
    private static final String DESCRIPTION_TEXT = Messages.getString(ImpactSettingsPage.class, "page.description");
    private static final String DESCRIPTION_DIRECTION_TEXT = Messages.getString(ImpactSettingsPage.class, "page.desc.direction");

    public ImpactSettingsPage(String pageName, boolean showDirectionChoice) {
        super(pageName);
        this.setTitle(Messages.getString(ImpactSettingsPage.class, "page.title"));
        this.description = showDirectionChoice ? DESCRIPTION_DIRECTION_TEXT : DESCRIPTION_TEXT;
        this.setDescription(this.description);
        this.showDirectionChoice = showDirectionChoice;
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginTop = 30;
        gl.marginLeft = 20;
        gl.verticalSpacing = 20;
        page.setLayout((Layout)gl);
        if (this.showDirectionChoice) {
            this.createDirectionGroup(page);
        }
        this.createDepthChoiceGroup(page);
        this.setPageComplete(false);
        this.setControl((Control)page);
    }

    private void createDirectionGroup(Composite page) {
        this.directionGroup = new Group(page, 0);
        this.directionGroup.setText(Messages.getString(ImpactSettingsPage.class, "direction.grp.txt"));
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        this.directionGroup.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        gd.horizontalAlignment = 16384;
        gd.minimumWidth = 300;
        gd.grabExcessHorizontalSpace = true;
        this.directionGroup.setLayoutData((Object)gd);
        DirectionAdapter da = new DirectionAdapter();
        this.forward = new Button((Composite)this.directionGroup, 16);
        this.forward.setText(Messages.getString(ImpactSettingsPage.class, "forward.btn.txt"));
        this.forward.setSelection(false);
        this.forward.addSelectionListener((SelectionListener)da);
        this.backward = new Button((Composite)this.directionGroup, 16);
        this.backward.setText(Messages.getString(ImpactSettingsPage.class, "backward.btn.txt"));
        this.backward.setSelection(false);
        this.backward.addSelectionListener((SelectionListener)da);
        this.setDirection();
    }

    private void createDepthChoiceGroup(Composite page) {
        this.depthChoiceGroup = new Group(page, 0);
        this.depthChoiceGroup.setText(Messages.getString(ImpactSettingsPage.class, "depth.grp.txt"));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = false;
        this.depthChoiceGroup.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        gd.horizontalAlignment = 16384;
        gd.minimumWidth = 300;
        gd.grabExcessHorizontalSpace = true;
        this.depthChoiceGroup.setLayoutData((Object)gd);
        this.depthChoice = new Button((Composite)this.depthChoiceGroup, 32);
        this.depthChoice.setText(Messages.getString(ImpactSettingsPage.class, "depth.btn.txt"));
        this.depthChoice.setSelection(false);
        this.depthChoice.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ImpactSettingsPage.this.depthChoice.getSelection();
                ImpactSettingsPage.this.depthText.setEnabled(selected);
                ImpactSettingsPage.this.setPageComplete(!selected || ImpactSettingsPage.this.checkDepthValue());
                ImpactSettingsPage.this.setDepth();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.depthText = new Text((Composite)this.depthChoiceGroup, 2052);
        gd = new GridData(256);
        gd.horizontalIndent = 5;
        gd.minimumWidth = 50;
        gd.widthHint = 50;
        this.depthText.setLayoutData((Object)gd);
        this.depthText.setEnabled(false);
        this.depthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ImpactSettingsPage.this.depthChoice.getSelection()) {
                    ImpactSettingsPage.this.setPageComplete(true);
                }
                ImpactSettingsPage.this.setDepth();
            }
        });
        this.setDepth();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        boolean complete = this.checkDirection();
        if (complete) {
            complete = this.checkDepthValue();
        }
        this.setPageComplete(complete);
        ((PrepareReportWizard)this.getWizard()).set("directionchanged", (Object)false);
    }

    private boolean checkDepthValue() {
        boolean complete = true;
        if (this.depthChoice != null) {
            if (this.depthChoice.getSelection()) {
                String depth = this.depthText.getText();
                try {
                    int depthInt = Integer.valueOf(depth);
                    complete = depthInt > 0 && depthInt <= 1000;
                    this.setMessage(this.description, 0);
                }
                catch (NumberFormatException ex) {
                    L.warn("wrong value for depth", (Throwable)ex);
                    this.setMessage(Messages.getString(ImpactSettingsPage.class, "wrongDepth.error.message", new String[]{String.valueOf(1), String.valueOf(1000)}), 3);
                    complete = false;
                }
            } else {
                this.setMessage(this.description, 0);
            }
        }
        return complete;
    }

    private void setDirection() {
        int direction = this.forward.getSelection() ? VariableOrBrowsePage.FORWARD : VariableOrBrowsePage.BACKWARD;
        ((PrepareReportWizard)this.getWizard()).set("impact direction", (Object)direction);
        ((PrepareReportWizard)this.getWizard()).set("impact_direction_changed", (Object)true);
    }

    private void setDepth() {
        int depthInt = 0;
        if (this.depthChoice != null && this.depthChoice.getSelection()) {
            String depth = this.depthText.getText();
            try {
                depthInt = Integer.valueOf(depth);
            }
            catch (NumberFormatException ex) {
                L.info("wrong value for depth; default ({}) is used", (Object)0, (Object)ex);
            }
        }
        ((PrepareReportWizard)this.getWizard()).set("max cycles", (Object)depthInt);
    }

    public IWizardPage getNextPage() {
        if (((PrepareReportWizard)this.getWizard()).getValue("variableName") != null) {
            return ((PrepareReportWizard)this.getWizard()).getPage("browseExcludedVariables");
        }
        return super.getNextPage();
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            complete = this.checkDirection();
        }
        if (complete && this.depthChoice != null) {
            complete = this.checkDepthValue();
        }
        super.setPageComplete(complete);
    }

    private boolean checkDirection() {
        boolean ret = this.forward == null && this.backward == null || this.forward != null && this.forward.getSelection() || this.backward != null && this.backward.getSelection();
        return ret;
    }

    private class DirectionAdapter
    extends SelectionAdapter {
        private DirectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            ImpactSettingsPage.this.setDirection();
            ImpactSettingsPage.this.setPageComplete(true);
        }
    }
}

