/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.wizard;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildListOfItemsPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(BuildListOfItemsPage.class);
    private Text text;
    private Button add;
    private Button browse;
    private Button importList;
    private List list;
    private Button del;
    private PrepareReportWizard wizard;
    private String key;
    private Runnable browseAction;

    public BuildListOfItemsPage(String pageName, String title, String description) {
        super(pageName);
        this.setTitle(title);
        this.setDescription(description);
    }

    public void setWizardItemKey(String key) {
        this.key = key;
    }

    public IWizardPage getNextPage() {
        return this.wizard.getPage("Datasets to be excluded");
    }

    public void createControl(Composite page) {
        this.wizard = (PrepareReportWizard)this.getWizard();
        this.wizard.set(this.key, new HashMap());
        Composite parent = new Composite(page, 0);
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        this.text = new Text(parent, 2048);
        this.add = new Button(parent, 8);
        this.add.setText(Messages.getString(BuildListOfItemsPage.class, "add.btn.txt"));
        this.browse = new Button(parent, 8);
        this.browse.setText(Messages.getString(BuildListOfItemsPage.class, "browse.btn.txt"));
        this.importList = new Button(parent, 8);
        this.importList.setText(Messages.getString(BuildListOfItemsPage.class, "importList.btn.txt"));
        this.list = new List(parent, 2560);
        this.del = new Button(parent, 8);
        this.del.setText(Messages.getString(BuildListOfItemsPage.class, "delete.btn.txt"));
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment((Control)this.add, -5);
        this.text.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.right = new FormAttachment((Control)this.browse, -5);
        this.add.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.right = new FormAttachment((Control)this.importList, -5);
        this.browse.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        this.importList.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.text, 5);
        fd.bottom = new FormAttachment((Control)this.del, -5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        this.list.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -5);
        fd.left = new FormAttachment(0, 5);
        this.del.setLayoutData((Object)fd);
        this.add.setEnabled(false);
        this.del.setEnabled(false);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean found = false;
                String[] stringArray = BuildListOfItemsPage.this.list.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (item.equals(BuildListOfItemsPage.this.text.getText())) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    Map rez = BuildListOfItemsPage.this.wizard.getMap(BuildListOfItemsPage.this.key);
                    Properties p = new Properties();
                    p.setProperty("varName", BuildListOfItemsPage.this.text.getText());
                    rez.put(BuildListOfItemsPage.this.text.getText(), p);
                    BuildListOfItemsPage.this.list.add(BuildListOfItemsPage.this.text.getText());
                    Object[] items = BuildListOfItemsPage.this.list.getItems();
                    Arrays.sort(items);
                    BuildListOfItemsPage.this.list.setItems((String[])items);
                    BuildListOfItemsPage.this.text.setText("");
                    BuildListOfItemsPage.this.add.setEnabled(false);
                } else {
                    BuildListOfItemsPage.this.setErrorMessage(Messages.getString(BuildListOfItemsPage.class, "msg.entry.txt"));
                }
                BuildListOfItemsPage.this.doDeleteEnablement();
            }
        });
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BuildListOfItemsPage.this.browseAction != null) {
                    BuildListOfItemsPage.this.browseAction.run();
                }
            }
        });
        this.importList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashSet<String> items = new HashSet<String>();
                Shell shell = Display.getDefault().getActiveShell();
                FileDialog fd = new FileDialog(shell, 4096);
                BufferedReader br = null;
                items.addAll(Arrays.asList(BuildListOfItemsPage.this.list.getItems()));
                Map rez = BuildListOfItemsPage.this.wizard.getMap(BuildListOfItemsPage.this.key);
                String fName = fd.open();
                if (fName != null) {
                    block16: {
                        try {
                            try {
                                String vName;
                                br = new BufferedReader(new FileReader(new File(fName)));
                                while ((vName = br.readLine()) != null) {
                                    if ((vName = vName.trim()).isEmpty() || !items.add(vName)) continue;
                                    Properties p = new Properties();
                                    p.setProperty("varName", vName);
                                    rez.put(vName, p);
                                }
                            }
                            catch (Exception ex) {
                                L.error("could not load file {}", (Object)fName, (Object)ex);
                                if (br != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (IOException ex1) {
                                        L.error("can't close {}", (Object)fName, (Object)ex1);
                                    }
                                }
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException ex1) {
                                    L.error("can't close {}", (Object)fName, (Object)ex1);
                                }
                            }
                            throw throwable;
                        }
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException ex1) {
                                L.error("can't close {}", (Object)fName, (Object)ex1);
                            }
                        }
                    }
                    BuildListOfItemsPage.this.list.removeAll();
                    Object[] newItems = items.toArray(new String[0]);
                    Arrays.sort(newItems);
                    BuildListOfItemsPage.this.list.setItems((String[])newItems);
                }
                BuildListOfItemsPage.this.doDeleteEnablement();
            }
        });
        this.del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                int pos = -1;
                String name = null;
                String[] stringArray = BuildListOfItemsPage.this.list.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (item.equals(BuildListOfItemsPage.this.list.getSelection()[0])) {
                        pos = i;
                        name = item;
                        break;
                    }
                    ++i;
                    ++n2;
                }
                if (pos != -1) {
                    Map rez = BuildListOfItemsPage.this.wizard.getMap(BuildListOfItemsPage.this.key);
                    rez.remove(name);
                    BuildListOfItemsPage.this.list.remove(pos);
                }
                BuildListOfItemsPage.this.doDeleteEnablement();
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildListOfItemsPage.this.setErrorMessage(null);
                if (!BuildListOfItemsPage.this.text.getText().isEmpty()) {
                    BuildListOfItemsPage.this.add.setEnabled(true);
                } else {
                    BuildListOfItemsPage.this.add.setEnabled(false);
                }
            }
        });
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase().trim();
            }
        });
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BuildListOfItemsPage.this.list.getItemCount() > 0 && BuildListOfItemsPage.this.list.getSelectionCount() > 0) {
                    BuildListOfItemsPage.this.del.setEnabled(true);
                } else {
                    BuildListOfItemsPage.this.del.setEnabled(false);
                }
            }
        });
        this.setControl((Control)parent);
    }

    private void doDeleteEnablement() {
        if (this.list.getItemCount() > 0 && this.list.getSelectionCount() > 0) {
            this.del.setEnabled(true);
        } else {
            this.del.setEnabled(false);
        }
    }

    public void setBrowseAction(Runnable browseAction) {
        this.browseAction = browseAction;
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    public void addEntry(Properties entryProp) {
        String id;
        Map rez = this.wizard.getMap(this.key);
        if (!rez.containsKey(id = String.valueOf(entryProp.getProperty("resourceName")) + entryProp.getProperty("varName") + entryProp.getProperty("startRow"))) {
            rez.put(id, entryProp);
            String resourceName = entryProp.getProperty("resourceName");
            String isProgram = entryProp.getProperty("isProgram");
            String startRow = entryProp.getProperty("startRow");
            String paragraph = entryProp.getProperty("paragraph");
            String resType = Boolean.valueOf(isProgram) != false ? Utils.RESOURCE_TYPE_PROGRAM : Utils.RESOURCE_TYPE_INCLUDE;
            String varName = entryProp.getProperty("varName");
            String msgKey = "variable.entry.short";
            Object[] messageArguments = new Object[]{varName, resType, resourceName};
            if (paragraph != null && !paragraph.isEmpty()) {
                if (startRow != null && !startRow.isEmpty()) {
                    msgKey = "variable.entry.full";
                    messageArguments = new Object[]{varName, resType, resourceName, paragraph, startRow};
                } else {
                    msgKey = "variable.entry.noLine";
                    messageArguments = new Object[]{varName, resType, resourceName, paragraph};
                }
            } else if (startRow != null && !startRow.isEmpty()) {
                msgKey = "variable.entry.noPara";
                messageArguments = new Object[]{varName, resType, resourceName, startRow};
            }
            this.list.add(Messages.getString(BuildListOfItemsPage.class, msgKey, messageArguments));
            if (this.list.getSelectionCount() > 0) {
                this.del.setEnabled(true);
            }
        }
    }
}

