/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.ui.displayview;

import com.ez.mainframe.editors.EZEditor;
import com.ez.mainframe.editors.adsp.ADSProcessEditor;
import com.ez.mainframe.editors.assembler.AssemblerEditor;
import com.ez.mainframe.editors.cobol.CobolEditor;
import com.ez.mainframe.editors.natural.NaturalEditor;
import com.ez.mainframe.editors.pl1.PL1Editor;
import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.ui.displayview.EZExportAsPdfAction;
import com.ez.mainframe.reports.gui.ui.displayview.EZExportAsXlsAction;
import com.ez.mainframe.reports.gui.ui.displayview.EZExportMenuAction;
import com.ez.mainframe.reports.gui.ui.displayview.ExportAsRtfAction;
import com.ez.mainframe.reports.gui.ui.displayview.FindTextContributionItem;
import com.ez.mainframe.reports.gui.ui.displayview.GoBackAction;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.utils.Utils;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.ReportViewer;
import com.jasperassistant.designer.viewer.StatusBar;
import com.jasperassistant.designer.viewer.actions.FirstPageAction;
import com.jasperassistant.designer.viewer.actions.LastPageAction;
import com.jasperassistant.designer.viewer.actions.NextPageAction;
import com.jasperassistant.designer.viewer.actions.PageNumberContributionItem;
import com.jasperassistant.designer.viewer.actions.PreviousPageAction;
import com.jasperassistant.designer.viewer.actions.PrintAction;
import com.jasperassistant.designer.viewer.actions.ZoomActualSizeAction;
import com.jasperassistant.designer.viewer.actions.ZoomComboContributionItem;
import com.jasperassistant.designer.viewer.actions.ZoomFitPageAction;
import com.jasperassistant.designer.viewer.actions.ZoomFitPageWidthAction;
import com.jasperassistant.designer.viewer.actions.ZoomInAction;
import com.jasperassistant.designer.viewer.actions.ZoomOutAction;
import java.io.File;
import java.net.URI;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDisplayView
extends ViewPart {
    private static final Logger L = LoggerFactory.getLogger(ReportDisplayView.class);
    public static final String ID = "com.ez.report.application.ReportDisplayView";
    protected Display display = Display.getDefault();
    protected final Cursor waitCursor = new Cursor((Device)this.display, 1);
    protected final Cursor defCursor = new Cursor((Device)this.display, 0);
    private static final ImageDescriptor PDF_EXPORT_ICON = ImageDescriptor.createFromFile(Activator.class, (String)"/icons/pdf.png");
    private JasperPrint document;
    private ReportViewer reportViewer;
    private GoBackAction gba;
    public boolean notifyOnOpen = true;
    private EZExportAsPdfAction pdfAction;
    private ExportAsRtfAction rtfAction;
    private EZExportAsXlsAction xlsAction;
    private boolean fDisposed;
    private ResourceManager fResourceManager;
    private ToolBarManager tbManager;
    private JRHyperlinkListener hypListener;
    private FindTextContributionItem textContributionItem;

    public void setTitleImageName(String titleImageName, String bundleName) {
        Image image;
        ImageDescriptor idDescriptor = null;
        String gifImageName = "/icons/".concat(titleImageName).concat(".gif");
        boolean isEmbedded = "com.ez.mainframe.reports.gui".equalsIgnoreCase(bundleName);
        idDescriptor = isEmbedded ? Activator.getImageDescriptor(gifImageName) : Activator.getImageDescriptor(bundleName, gifImageName);
        if (idDescriptor == null) {
            String pngImageName = "/icons/".concat(titleImageName).concat(".png");
            idDescriptor = isEmbedded ? Activator.getImageDescriptor(pngImageName) : Activator.getImageDescriptor(bundleName, pngImageName);
        }
        if ((image = this.getImage(idDescriptor)) != null) {
            super.setTitleImage(image);
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite ctrl = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 2;
        ctrl.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        ctrl.setLayoutData((Object)gd);
        this.reportViewer = new ReportViewer(2048);
        this.tbManager = new ToolBarManager(0x800000);
        EZExportMenuAction exportMenu = new EZExportMenuAction(this.reportViewer);
        this.pdfAction = new EZExportAsPdfAction((IReportViewer)this.reportViewer);
        this.pdfAction.setImageDescriptor(PDF_EXPORT_ICON);
        this.pdfAction.setDisabledImageDescriptor(PDF_EXPORT_ICON);
        exportMenu.getMenuManager().add((IAction)this.pdfAction);
        exportMenu.setDefaultAction((IAction)this.pdfAction);
        this.rtfAction = new ExportAsRtfAction((IReportViewer)this.reportViewer);
        exportMenu.getMenuManager().add((IAction)this.rtfAction);
        this.xlsAction = new EZExportAsXlsAction((IReportViewer)this.reportViewer);
        exportMenu.getMenuManager().add((IAction)this.xlsAction);
        this.tbManager.add((IAction)exportMenu);
        this.tbManager.add((IAction)new PrintAction((IReportViewer)this.reportViewer));
        this.tbManager.add((IContributionItem)new Separator());
        this.tbManager.add((IAction)new FirstPageAction((IReportViewer)this.reportViewer));
        this.tbManager.add((IAction)new PreviousPageAction((IReportViewer)this.reportViewer));
        if (SWT.getPlatform().equals("win32")) {
            this.tbManager.add((IContributionItem)new PageNumberContributionItem((IReportViewer)this.reportViewer));
        }
        this.tbManager.add((IAction)new NextPageAction((IReportViewer)this.reportViewer));
        this.tbManager.add((IAction)new LastPageAction((IReportViewer)this.reportViewer));
        this.tbManager.add((IContributionItem)new Separator());
        this.tbManager.add((IAction)new ZoomActualSizeAction((IReportViewer)this.reportViewer));
        this.tbManager.add((IAction)new ZoomFitPageAction((IReportViewer)this.reportViewer));
        this.tbManager.add((IAction)new ZoomFitPageWidthAction((IReportViewer)this.reportViewer));
        this.tbManager.add((IContributionItem)new Separator());
        this.gba = new GoBackAction((IReportViewer)this.reportViewer);
        this.tbManager.add((IAction)this.gba);
        this.tbManager.add((IContributionItem)new Separator());
        this.tbManager.add((IAction)new ZoomOutAction((IReportViewer)this.reportViewer));
        this.tbManager.add((IContributionItem)new ZoomComboContributionItem((IReportViewer)this.reportViewer));
        this.tbManager.add((IAction)new ZoomInAction((IReportViewer)this.reportViewer));
        ToolBar toolbar = this.tbManager.createControl(ctrl);
        toolbar.setLayoutData((Object)new GridData(768));
        Control reportViewerControl = this.reportViewer.createControl(ctrl);
        reportViewerControl.setLayoutData((Object)new GridData(1808));
        StatusBar statusBar = new StatusBar();
        statusBar.setReportViewer((IReportViewer)this.reportViewer);
        Control statusBarControl = statusBar.createControl(ctrl);
        statusBarControl.setLayoutData((Object)new GridData(768));
        ctrl.setVisible(true);
        this.hypListener = new JRHyperlinkListener(){

            public void gotoHyperlink(JRPrintHyperlink hyperlink) throws JRException {
                if (hyperlink instanceof JRTemplatePrintText) {
                    String anchorName = ((JRTemplatePrintText)hyperlink).getAnchorName();
                    L.debug("hyperlink pressed; anchorName=" + anchorName);
                    HyperlinkTypeEnum hyperlinkType = ((JRTemplatePrintText)hyperlink).getHyperlinkTypeValue();
                    if (HyperlinkTypeEnum.REFERENCE.equals((Object)hyperlinkType) || HyperlinkTypeEnum.CUSTOM.equals((Object)hyperlinkType)) {
                        L.debug("type reference");
                        String link = ((JRTemplatePrintText)hyperlink).getHyperlinkReference();
                        L.debug("ref: " + link);
                        if (link != null) {
                            JRPrintHyperlinkParameters p = hyperlink.getHyperlinkParameters();
                            boolean wasOpen = false;
                            if (p != null) {
                                List paramList = p.getParameters();
                                for (JRPrintHyperlinkParameter parameter : paramList) {
                                    if (!parameter.getName().equalsIgnoreCase("isProgramLaunch")) continue;
                                    wasOpen = true;
                                    String[] str = link.split(",");
                                    Program.launch((String)str[1].concat(str[0]));
                                    break;
                                }
                            }
                            if (link.startsWith("./")) {
                                wasOpen = true;
                                String graphsDir = Utils.getGraphsDirectory();
                                link = link.substring(2);
                                Program.launch((String)graphsDir.concat(link));
                            }
                            if (!wasOpen) {
                                ReportDisplayView.this.openLink(link);
                            }
                        }
                    }
                    if (anchorName != null) {
                        ReportDisplayView.this.registerAnchor(anchorName);
                    }
                }
            }
        };
        this.reportViewer.addHyperlinkListener(this.hypListener);
    }

    private void registerAnchor(String anchorName) {
        this.gba.setAnchorName(anchorName);
    }

    private void openLink(String link) {
        String[] strs = link.split(",");
        String path = strs[0].trim();
        String type = strs[1].trim();
        int line = 0;
        if (strs.length > 2 && !strs[2].equals("null")) {
            line = Integer.valueOf(strs[2].trim());
        }
        if (type != null && path != null && path.length() > 0) {
            File file = new File(path);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
            if (file != null && file.exists()) {
                IWorkbenchPage page = window.getActivePage();
                try {
                    IEditorPart editor = null;
                    IFileStore fileStore = EFS.getStore((URI)file.toURI());
                    editor = type.equalsIgnoreCase("NATURAL") ? page.openEditor((IEditorInput)new FileStoreEditorInput(fileStore), NaturalEditor.NATURAL_EDITOR_ID) : (type.equalsIgnoreCase("PL1") ? page.openEditor((IEditorInput)new FileStoreEditorInput(fileStore), PL1Editor.PL1_EDITOR_ID) : (type.equalsIgnoreCase("COBOL") ? page.openEditor((IEditorInput)new FileStoreEditorInput(fileStore), CobolEditor.COBOL_EDITOR_ID) : (type.equalsIgnoreCase("ASSEMBLER") ? page.openEditor((IEditorInput)new FileStoreEditorInput(fileStore), AssemblerEditor.ASSEMBLER_EDITOR_ID) : (type.equalsIgnoreCase("ADS Process") ? page.openEditor((IEditorInput)new FileStoreEditorInput(fileStore), ADSProcessEditor.ADSP_EDITOR_ID) : page.openEditor((IEditorInput)new FileStoreEditorInput(fileStore), "ezeditor.id")))));
                    if (line > 0 && editor instanceof EZEditor) {
                        L.debug("open an Application Discovery file: {}", (Object)path);
                        EZEditor.CustomScrollLinesAction action = (EZEditor.CustomScrollLinesAction)((EZEditor)editor).getAction("CUSTOM_SCROLL_LINE_UP");
                        action.setLineToJump(line);
                        action.run();
                    }
                }
                catch (CoreException e) {
                    L.error("error at opening file in editor", (Throwable)e);
                    EZReportErrorLog.err(Messages.getString(ReportDisplayView.class, "openFile.logError.message"), e);
                }
            } else {
                L.warn("try to open a null file: " + file);
                Object[] param = new String[]{path};
                String msg = Messages.getString(ReportDisplayView.class, "openNullFile.warning.message", param);
                String title = Messages.getString(ReportDisplayView.class, "openNullFile.warning.title");
                MessageDialog.openWarning((Shell)window.getShell(), (String)title, (String)msg);
            }
        }
    }

    public void setFocus() {
    }

    public JasperPrint getDocument() {
        return this.document;
    }

    public void setDocument(JasperPrint document) {
        this.document = document;
    }

    public void showInViewer(AbstractReport report, JasperPrint document) {
        this.showInViewer(report.name, document);
    }

    public void showInViewer(String reportName, JasperPrint document) {
        this.setPartName(reportName);
        this.pdfAction.setFileName(reportName);
        this.rtfAction.setFileName(reportName);
        this.xlsAction.setFileName(reportName);
        JRProperties.setProperty((String)"net.sf.jasperreports.awt.ignore.missing.font", (String)Boolean.TRUE.toString());
        this.setDocument(document);
        this.reportViewer.setDocument(document);
    }

    public void dispose() {
        this.pdfAction.dispose();
        this.pdfAction = null;
        this.rtfAction.dispose();
        this.rtfAction = null;
        this.xlsAction.dispose();
        this.xlsAction = null;
        this.gba.dispose();
        this.gba = null;
        this.reportViewer.removeHyperlinkListener(this.hypListener);
        this.hypListener = null;
        this.tbManager.dispose();
        this.tbManager = null;
        this.reportViewer.getViewerCanvas().dispose();
        this.reportViewer = null;
        if (this.document != null && this.document.getStylesMap() != null) {
            this.document.getStylesMap().clear();
            this.document = null;
        }
        this.display = null;
        this.fDisposed = true;
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
        }
        super.dispose();
    }

    public ReportViewer getReportViewer() {
        return this.reportViewer;
    }

    public void updateToolBar() {
    }

    private ResourceManager getResourceManager() {
        if (this.fDisposed) {
            return null;
        }
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    private Image getImage(ImageDescriptor desc) {
        ResourceManager rm = this.getResourceManager();
        return rm.createImage(desc);
    }

    public void addExportedFile(String exportedFile) {
        if (exportedFile != null) {
            this.pdfAction.addExportedFile(exportedFile);
            this.rtfAction.addExportedFile(exportedFile);
            this.xlsAction.addExportedFile(exportedFile);
        }
    }
}

