/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.ui.displayview;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.IReportViewerListener;
import com.jasperassistant.designer.viewer.ReportViewerEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FindTextContributionItem
extends ContributionItem
implements IReportViewerListener {
    private IReportViewer viewer;
    private Text text;
    private ToolItem toolitem;
    private List<ModifyListener> listeners = new ArrayList<ModifyListener>();

    public FindTextContributionItem(IReportViewer reportViewer) {
        this.viewer = reportViewer;
        this.viewer.addReportViewerListener((IReportViewerListener)this);
    }

    void refresh() {
        if (this.text == null || this.text.isDisposed()) {
            return;
        }
        if (!this.viewer.hasDocument()) {
            this.text.setEnabled(false);
            this.text.setText("");
        } else {
            this.text.setText("");
            this.text.setEnabled(true);
        }
    }

    public void dispose() {
        for (ModifyListener ml : this.listeners) {
            this.text.removeModifyListener(ml);
        }
        this.text = null;
        this.viewer = null;
        super.dispose();
    }

    private Control createControl(Composite parent) {
        Composite group = new Composite(parent, 0);
        RowLayout rl = new RowLayout(256);
        rl.fill = true;
        rl.wrap = false;
        rl.pack = true;
        group.setLayout((Layout)rl);
        Label findLabel = new Label(group, 16384);
        findLabel.setText(Messages.getString(FindTextContributionItem.class, "find.label.txt"));
        findLabel.pack();
        this.text = new Text(group, 2048);
        this.text.setText("");
        this.text.setTextLimit(30);
        this.text.pack();
        for (ModifyListener ml : this.listeners) {
            this.text.addModifyListener(ml);
        }
        this.refresh();
        return group;
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setWidth(100);
        this.toolitem.setControl(control);
    }

    public void fill(Composite parent) {
        super.fill(parent);
    }

    public String getFindText() {
        if (this.text == null || this.text.isDisposed()) {
            return "";
        }
        return this.text.getText();
    }

    public void viewerStateChanged(ReportViewerEvent reportviewerevent) {
        this.refresh();
    }

    public void addTextModifyListener(ModifyListener listener) {
        if (this.text == null) {
            this.listeners.add(listener);
        } else {
            this.text.addModifyListener(listener);
        }
    }

    public void removeTextModifyListener(ModifyListener listener) {
        this.listeners.remove(listener);
        this.text.removeModifyListener(listener);
    }
}

