/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.ui.displayview;

import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.displayview.EZHyperlinkProducerFactory;
import com.ez.report.application.utils.Utils;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportAsRtfAction
extends AbstractExportAction {
    private static final Logger L = LoggerFactory.getLogger(ExportAsRtfAction.class);
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(Activator.class, (String)"/icons/rtf.png");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(Activator.class, (String)"/icons/rtf.png");
    private List<String> exportedFiles = new ArrayList<String>();

    public ExportAsRtfAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString(ExportAsRtfAction.class, "ExportAsRtfAction.label"));
        this.setToolTipText(Messages.getString(ExportAsRtfAction.class, "ExportAsRtfAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.rtf"});
        this.setFilterNames(new String[]{Messages.getString(ExportAsRtfAction.class, "ExportAsRtfAction.filterName")});
        this.setDefaultFileExtension("rtf");
    }

    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        try {
            JRRtfExporter exporter = new JRRtfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getReportViewer().getDocument());
            exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)new EZHyperlinkProducerFactory());
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)file);
            exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)monitor);
            exporter.exportReport();
            for (String f : this.exportedFiles) {
                try {
                    Utils.exportFile((String)f, (File)file);
                }
                catch (IOException e) {
                    L.error("error at exporting report into .svg file: " + file, (Throwable)e);
                }
            }
            List filePages = this.getReportViewer().getDocument().getPages();
            int i = 0;
            while (i < filePages.size()) {
                if (monitor != null) {
                    monitor.afterPageExport();
                }
                ++i;
            }
        }
        catch (Throwable ex) {
            L.error("error at exporting report to xls", ex);
            EZReportErrorLog.err(Messages.getString(ExportAsRtfAction.class, "export.errorLog.message"), ex);
        }
    }

    public void addExportedFile(String exportedFile) {
        this.exportedFiles.add(exportedFile);
    }
}

