/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.ui.displayview;

import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.utils.Utils;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.ExportAsSingleXlsAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZExportAsXlsAction
extends ExportAsSingleXlsAction {
    private static final Logger L = LoggerFactory.getLogger(EZExportAsXlsAction.class);
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(Activator.class, (String)"/icons/xls.png");
    public String[] sheetNames = null;
    private List<String> exportedFiles = new ArrayList<String>();

    public EZExportAsXlsAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString(EZExportAsXlsAction.class, "ExportAsXlsAction.label"));
        this.setToolTipText(Messages.getString(EZExportAsXlsAction.class, "ExportAsXlsAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(ICON);
        this.setFileExtensions(new String[]{"*.xls"});
        this.setFilterNames(new String[]{Messages.getString(EZExportAsXlsAction.class, "EZExportAsXlsAction.filterName")});
        this.setDefaultFileExtension("xls");
    }

    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        try {
            JRXlsExporter exporter = new JRXlsExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getReportViewer().getDocument());
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)file);
            exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)monitor);
            exporter.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
            if (exporter.getParameter((JRExporterParameter)JExcelApiExporterParameter.IS_ONE_PAGE_PER_SHEET) == null || exporter.getParameter((JRExporterParameter)JExcelApiExporterParameter.IS_ONE_PAGE_PER_SHEET).equals(Boolean.FALSE)) {
                exporter.setParameter((JRExporterParameter)JExcelApiExporterParameter.SHEET_NAMES, (Object)this.sheetNames);
            }
            exporter.exportReport();
            for (String f : this.exportedFiles) {
                try {
                    Utils.exportFile((String)f, (File)file);
                }
                catch (IOException e) {
                    L.error("exporting " + f, (Throwable)e);
                }
            }
        }
        catch (Throwable ex) {
            L.error("error at exporting report to xls", ex);
            EZReportErrorLog.err(Messages.getString(EZExportAsXlsAction.class, "export.errorLog.message"), ex);
        }
    }

    public void addExportedFile(String file) {
        this.exportedFiles.add(file);
    }
}

