/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.ui.displayview;

import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.displayview.EZHyperlinkProducerFactory;
import com.ez.report.application.utils.Utils;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.ExportAsPdfAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZExportAsPdfAction
extends ExportAsPdfAction {
    private static final Logger L = LoggerFactory.getLogger(EZExportAsPdfAction.class);
    private List<String> exportedFiles = new ArrayList<String>();

    public EZExportAsPdfAction(IReportViewer viewer) {
        super(viewer);
    }

    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        try {
            JRPdfExporter exporter = new JRPdfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getReportViewer().getDocument());
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)file);
            exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)monitor);
            String pdfProp = this.getReportViewer().getDocument().getProperty("pdf_metadata_author");
            if (pdfProp != null) {
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_AUTHOR, (Object)pdfProp);
            }
            if ((pdfProp = this.getReportViewer().getDocument().getProperty("pdf_metadata_title")) != null) {
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_TITLE, (Object)pdfProp);
            }
            if ((pdfProp = this.getReportViewer().getDocument().getProperty("pdf_hyperlink_export")) != null) {
                exporter.setParameter(JRPdfExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)new EZHyperlinkProducerFactory());
            }
            exporter.exportReport();
            for (String f : this.exportedFiles) {
                try {
                    Utils.exportFile((String)f, (File)file);
                }
                catch (IOException e) {
                    L.error("exporting " + f, (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            EZReportErrorLog.err(Messages.getString(EZExportAsPdfAction.class, "pdfExport.error", new String[]{file.toString()}), e);
            L.error("error at exporting report into pdf file: " + file, e);
        }
    }

    public void addExportedFile(String file) {
        this.exportedFiles.add(file);
    }
}

