/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.ui;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.ApplicationInputNoGUI;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationsProvider
implements SelectSingleFromListPage.ListDetailProvider {
    private static final Logger L = LoggerFactory.getLogger(ApplicationsProvider.class);
    private PrepareReportWizard wizard;
    boolean isCheckBox;
    String description;
    String title;
    String entityType;

    public ApplicationsProvider(PrepareReportWizard wizard) {
        this.wizard = wizard;
        this.title = Messages.getString(ApplicationsProvider.class, "title");
        this.description = Messages.getString(ApplicationsProvider.class, "description");
        this.entityType = Messages.getString(ApplicationsProvider.class, "entityType.application");
        this.isCheckBox = true;
    }

    public ApplicationsProvider(PrepareReportWizard wizard, boolean hasCheckBox) {
        this(wizard);
        this.isCheckBox = hasCheckBox;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public List<SelectSingleFromListPage.ListItem> getItems(EZSourceConnection bridge, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor.convert((IProgressMonitor)monitor, (String)"getting applications", (int)-1);
        ArrayList<SelectSingleFromListPage.ArrayListItem> items = null;
        try {
            List apps = Utils.getAvailableApplications((EZSourceConnection)bridge);
            if (!apps.isEmpty()) {
                items = new ArrayList<SelectSingleFromListPage.ArrayListItem>();
                for (ApplicationInputNoGUI app : apps) {
                    SelectSingleFromListPage.ArrayListItem li = new SelectSingleFromListPage.ArrayListItem();
                    li.setStringArray(new String[]{app.getListableName(), app.getApplicationID()});
                    items.add(li);
                }
            }
        }
        catch (EZSourceNativeException e) {
            L.error("connection error", (Throwable)e);
            EZReportErrorLog.err(Messages.getString(ApplicationsProvider.class, "connectionError.log.message"), e);
        }
        return items;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isCheckBox() {
        return this.isCheckBox;
    }

    public boolean hasFilters() {
        return true;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

