/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.preferences.pages;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MainframeReportsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Button btnAppendix = null;
    private Button btnShowInputs = null;
    private Composite parent;
    private RadioGroupFieldEditor prjNameEditor;
    private Button customNameBtn;
    private Text customNameTxt;

    public MainframeReportsPreferencePage() {
        super(1);
        this.setDescription("");
        this.setPreferenceStore(PreferenceUtils.getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.parent = this.getFieldEditorParent();
        Group appGr = new Group(this.parent, 0);
        appGr.setText(Messages.getString(MainframeReportsPreferencePage.class, "showAppendix.groupName"));
        GridLayout gl = new GridLayout();
        gl.marginBottom = 7;
        appGr.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        appGr.setLayoutData((Object)gd);
        BooleanFieldEditor showAppendix = new BooleanFieldEditor("showAppendix", Messages.getString(MainframeReportsPreferencePage.class, "showAppendix.label"), (Composite)appGr);
        this.btnAppendix = (Button)showAppendix.getDescriptionControl((Composite)appGr);
        this.btnAppendix.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MainframeReportsPreferencePage.this.checkAppendix();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addField((FieldEditor)showAppendix);
        gd = new GridData();
        gd.horizontalIndent = 5;
        gd.verticalIndent = 5;
        this.btnAppendix.setLayoutData((Object)gd);
        BooleanFieldEditor showInputs = new BooleanFieldEditor("showInputDetails", Messages.getString(MainframeReportsPreferencePage.class, "showInputsInAppendix.label"), (Composite)appGr);
        this.btnShowInputs = (Button)showInputs.getDescriptionControl((Composite)appGr);
        ((GridData)this.btnShowInputs.getLayoutData()).horizontalAlignment = 1;
        ((GridData)this.btnShowInputs.getLayoutData()).horizontalIndent = 20;
        this.addField((FieldEditor)showInputs);
        String[][] labelAndValues = new String[][]{{Messages.getString(MainframeReportsPreferencePage.class, "currentProject.button.label"), "currentProject"}, {Messages.getString(MainframeReportsPreferencePage.class, "customName.button.label"), "customName"}};
        this.prjNameEditor = new RadioGroupFieldEditor("use_current_project_name", Messages.getString(MainframeReportsPreferencePage.class, "projectName.group.label"), 2, labelAndValues, this.parent, true);
        this.addField((FieldEditor)this.prjNameEditor);
        Composite radioBoxControl = this.prjNameEditor.getRadioBoxControl(this.parent);
        StringFieldEditor projectName = new StringFieldEditor("project_name", "", radioBoxControl);
        this.addField((FieldEditor)projectName);
        this.customNameTxt = projectName.getTextControl(radioBoxControl);
        new Label(radioBoxControl, 0);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value") && event.getSource().equals(this.prjNameEditor)) {
            boolean valid = true;
            if (this.customNameBtn.getSelection()) {
                String customName = this.customNameTxt.getText();
                boolean bl = valid = customName != null && !customName.isEmpty();
            }
            if (valid) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(Messages.getString(MainframeReportsPreferencePage.class, "error.message"));
            }
        }
    }

    protected void adjustGridLayout() {
        super.adjustGridLayout();
        ((GridLayout)this.parent.getLayout()).verticalSpacing = 10;
        Composite radioBoxControl = this.prjNameEditor.getRadioBoxControl(this.parent);
        ((GridLayout)radioBoxControl.getLayout()).numColumns = 4;
        ((GridLayout)radioBoxControl.getLayout()).horizontalSpacing = 0;
        ((GridLayout)radioBoxControl.getLayout()).marginBottom = 5;
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 3;
        radioBoxControl.setLayoutData((Object)data);
        Control[] ctrls = radioBoxControl.getChildren();
        data = new GridData();
        data.horizontalSpan = 4;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 5;
        data.verticalIndent = 5;
        data.grabExcessHorizontalSpace = true;
        ctrls[0].setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 5;
        ctrls[1].setLayoutData((Object)data);
        this.customNameBtn = (Button)ctrls[1];
        data = new GridData();
        data.horizontalAlignment = 1;
        data.minimumWidth = 1;
        data.widthHint = 5;
        ctrls[2].setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.minimumWidth = 50;
        data.widthHint = 70;
        ctrls[3].setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        ctrls[4].setLayoutData((Object)data);
    }

    private void checkAppendix() {
        boolean showAppendix = this.btnAppendix.getSelection();
        this.btnShowInputs.setEnabled(showAppendix);
        if (!showAppendix) {
            this.btnShowInputs.setSelection(false);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkAppendix();
    }

    protected void initialize() {
        super.initialize();
        this.checkAppendix();
    }
}

