/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui.preferences;

import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.model.Constants;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PreferenceUtils.class);

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        Activator default1 = Activator.getDefault();
        if (default1 != null) {
            IPreferenceStore store = default1.getPreferenceStore();
            store.addPropertyChangeListener(listener);
        }
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        Activator default1 = Activator.getDefault();
        if (default1 != null) {
            IPreferenceStore store = default1.getPreferenceStore();
            store.removePropertyChangeListener(listener);
        }
    }

    public static final Object getDefaultValue(String preference) {
        if (preference != null) {
            if (preference.equalsIgnoreCase("reportsPathPreference")) {
                return PreferenceUtils.getDefaultGeneratedReportsPath();
            }
            if (preference.equalsIgnoreCase("documentationPathPreference")) {
                return PreferenceUtils.getDefaultDocumentationReportsPath();
            }
        }
        return null;
    }

    private static Object getDefaultGeneratedReportsPath() {
        String path = Utils.USER_APP_DIR;
        File generatedDir = new File(path = path.concat(Constants.PATH_SEPARATOR).concat("generated"));
        if (!generatedDir.exists()) {
            generatedDir.mkdir();
            L.debug("mkdir for generated dir");
        }
        return path;
    }

    private static Object getDefaultDocumentationReportsPath() {
        String path = System.getProperty("user.home");
        File docDir = new File(path = path.concat(Constants.PATH_SEPARATOR).concat("documentation"));
        if (!docDir.exists()) {
            docDir.mkdir();
            L.debug("mkdir for documentation dir");
        }
        return path;
    }

    public static IPreferenceStore getPreferenceStore() {
        Activator activator = Activator.getDefault();
        IPreferenceStore ret = null;
        if (activator != null) {
            ret = activator.getPreferenceStore();
        }
        return ret;
    }
}

