/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui;

import com.ez.mainframe.reports.EZExportGraphDialogInternal;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.interactive.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.licensing.TSLicenseManager;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.TSServiceOutputData;
import com.tomsawyer.service.TSServiceOutputDataInterface;
import com.tomsawyer.service.layout.TSHierarchicalLayoutInputTailor;
import com.tomsawyer.service.layout.client.TSApplyLayoutResults;
import com.tomsawyer.service.layout.client.TSLayoutProxy;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportBuilderWithTS
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractReportBuilderWithTS.class);
    protected EZExportGraphDialogInternal tsSaveAsWindow;
    Frame frame = null;

    protected void initializeTS() {
        boolean noTS = Boolean.parseBoolean(System.getProperty("noTS", "false"));
        if (!noTS) {
            TSLicenseManager.setUserName((String)System.getProperty("user.name"));
            TSLicenseManager.axSuzszgQomlyiri();
            this.frame = new Frame();
            this.tsSaveAsWindow = new EZExportGraphDialogInternal(this.frame, "title", new TSSwingCanvas(), 2);
        }
    }

    protected void uninitializeTS(Frame frame) {
        if (this.tsSaveAsWindow != null) {
            this.tsSaveAsWindow.dispose();
            this.tsSaveAsWindow = null;
        }
        if (frame != null) {
            frame.dispose();
        }
    }

    protected void exportToSVGFile(File svgFile, TSEGraphManager gManager) {
        this.tsSaveAsWindow.setGraphManager(gManager);
        this.tsSaveAsWindow.setExportFile(svgFile);
        boolean exportResult = this.tsSaveAsWindow.onOK();
        L.debug("export result: {}", (Object)exportResult);
        this.generateAdditionalSVG(svgFile.getAbsolutePath());
    }

    protected void doHierarchicalLayout(TSEGraphManager gManager) {
        this.doHierarchicalLayout(gManager, 3);
    }

    protected void doHierarchicalLayout(TSEGraphManager gManager, int levelDirection) {
        TSLayoutProxy layoutProxy = new TSLayoutProxy();
        TSEAllOptionsServiceInputData inputData = new TSEAllOptionsServiceInputData((TSDGraphManager)gManager);
        TSHierarchicalLayoutInputTailor hierarchicalLayoutInputTailor = new TSHierarchicalLayoutInputTailor((TSServiceInputDataInterface)inputData);
        hierarchicalLayoutInputTailor.setGraph(gManager.getMainDisplayGraph());
        hierarchicalLayoutInputTailor.setLevelDirection(levelDirection);
        hierarchicalLayoutInputTailor.setLevelAlignment(1);
        hierarchicalLayoutInputTailor.setOrthogonalRouting(false);
        hierarchicalLayoutInputTailor.setKeepNodeSizes(true);
        hierarchicalLayoutInputTailor.setAsCurrentLayoutStyle();
        hierarchicalLayoutInputTailor.setConstantHorizontalSpacingBetweenNodes(20.0);
        hierarchicalLayoutInputTailor.setConstantVerticalSpacingBetweenNodes(20.0);
        hierarchicalLayoutInputTailor.setHorizontalSpacingBetweenEdges(20.0);
        hierarchicalLayoutInputTailor.setVerticalSpacingBetweenEdges(20.0);
        this.applyConstraints(inputData, gManager);
        TSServiceOutputData outputData = new TSServiceOutputData();
        layoutProxy.run((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        TSApplyLayoutResults applyResults = new TSApplyLayoutResults();
        applyResults.apply((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        if (this.applyRouting(inputData, gManager)) {
            outputData = new TSServiceOutputData();
            layoutProxy.run((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
            applyResults = new TSApplyLayoutResults();
            applyResults.apply((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        }
    }

    protected boolean applyRouting(TSEAllOptionsServiceInputData inputData, TSEGraphManager gManager) {
        return false;
    }

    protected void applyConstraints(TSEAllOptionsServiceInputData inputData, TSEGraphManager gmanager) {
    }

    private void generateAdditionalSVG(String fileName) {
        if (fileName != null) {
            String fileName4Copy = AbstractReportBuilderWithTS.removeExtension((String)fileName);
            try {
                FileReader is = new FileReader(fileName);
                BufferedReader br = new BufferedReader(is);
                fileName4Copy = fileName4Copy.concat("_visio.svg");
                String line = "";
                ArrayList<String> svgLines = new ArrayList<String>();
                while ((line = br.readLine()) != null) {
                    line = this.removeAllInLine(line, "clip-path:url(#clipPath");
                    svgLines.add(line);
                }
                br.close();
                PrintWriter pw = new PrintWriter(fileName);
                for (String svgLine : svgLines) {
                    pw.println(svgLine);
                }
                pw.close();
            }
            catch (FileNotFoundException e) {
                L.error("Cannot create SVG compatible copy for MS Visio", (Throwable)e);
            }
            catch (IOException e) {
                L.error("Cannot read SVG file {}", (Object)fileName, (Object)e);
            }
        }
    }

    private String removeAllInLine(String line, String text) {
        while (line.indexOf(text) >= 0) {
            int nextEndStr;
            int nextCol;
            int min;
            int x = line.indexOf(text);
            if (x >= (min = Math.min(nextCol = line.indexOf(";", x), nextEndStr = line.indexOf("\"", x)))) break;
            String start = line.substring(0, x);
            String end = line.substring(min + 1, line.length());
            if (!start.contains("<line ")) break;
            line = start.concat(end);
        }
        return line;
    }

    public void dispose() {
        super.dispose();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractReportBuilderWithTS.this.tsSaveAsWindow != null) {
                    AbstractReportBuilderWithTS.this.tsSaveAsWindow.dispose();
                    AbstractReportBuilderWithTS.this.tsSaveAsWindow = null;
                }
            }
        });
    }
}

