/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.gui;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.mainframe.reports.EZExportGraphDialogInternal;
import com.ez.mainframe.reports.gui.AbstractReportBuilderWithTS;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.displayview.EZHyperlinkProducerFactory;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.xml.TSEVisualizationXMLWriter;
import com.tomsawyer.interactive.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.licensing.TSLicenseManager;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.TSServiceOutputData;
import com.tomsawyer.service.TSServiceOutputDataInterface;
import com.tomsawyer.service.layout.client.TSApplyLayoutResults;
import com.tomsawyer.service.layout.client.TSLayoutProxy;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeneratorBuilder
extends AbstractReportBuilderWithTS {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractGeneratorBuilder.class);

    public IStatus build(IProgressMonitor pmonitor) {
        IStatus status = Status.OK_STATUS;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        this.initStopCode(pmonitor);
        if (this.report.print == null) {
            TSLicenseManager.setUserName((String)System.getProperty("user.name"));
            TSLicenseManager.axSuzszgQomlyiri();
            Frame frame = new Frame();
            this.tsSaveAsWindow = new EZExportGraphDialogInternal(frame, "title", new TSSwingCanvas(), 2);
            try {
                monitor.setTaskName(Messages.getString(AbstractGeneratorBuilder.class, "gen.rep.task.name"));
                this.prepareReport((IProgressMonitor)monitor.newChild(10));
                this.checkStop();
                monitor.setTaskName(Messages.getString(AbstractGeneratorBuilder.class, "gen.rep.params.task.name"));
                this.parameters = this.getReportParameters((IProgressMonitor)monitor.newChild(10));
                boolean isUCMDB = false;
                if (this.pInfo != null) {
                    isUCMDB = this.pInfo.isUMCDB();
                } else {
                    L.warn("pInfo null for project {}", (Object)this.project);
                }
                Utils.setParamsForTitle((Map)this.parameters, (String)this.project, (boolean)isUCMDB, (Map)this.inputs);
                L.debug("after load params");
                this.checkStop();
                this.putGenericParams(this.parameters);
                int targets = this.getNumOfTargetsFromProp(monitor.newChild(10));
                if (targets == -1) {
                    targets = this.getNumOfTargets((IProgressMonitor)monitor.newChild(10));
                }
                if (targets > 0) {
                    this.buildTargets(targets, (IProgressMonitor)monitor.newChild(70), status);
                }
                if (!this.report.hasPostBuild) {
                    this.cleanMemory();
                } else {
                    this.mustWrite = true;
                }
            }
            catch (Throwable t) {
                L.error("error at building report", t);
                status = Status.CANCEL_STATUS;
            }
            this.tsSaveAsWindow.dispose();
            frame.dispose();
        } else {
            L.debug("report loaded from file");
        }
        monitor.setWorkRemaining(0);
        if (monitor.isCanceled()) {
            status = Status.CANCEL_STATUS;
        }
        return status;
    }

    protected int getNumOfTargetsFromProp(SubMonitor newChild) {
        return -1;
    }

    protected abstract int getNumOfTargets(IProgressMonitor var1);

    protected abstract JRDataSource getDSForTarget(int var1, IProgressMonitor var2);

    private void buildTargets(int targets, IProgressMonitor pmonitor, IStatus status) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(targets * 200));
        L.info("Start generating of {} reports in builder: {}", (Object)targets, ((Object)((Object)this)).getClass());
        int failed = 0;
        int i = 0;
        while (i < targets) {
            this.computeGeneralResults(i, (IProgressMonitor)monitor.newChild(50));
            JRDataSource ds = null;
            try {
                ds = this.getDSForTarget(i, (IProgressMonitor)monitor.newChild(50));
                this.checkStop();
                if (ds != null) {
                    JasperPrint print;
                    monitor.setTaskName(Messages.getString(AbstractGeneratorBuilder.class, "prepare.rep.task.name"));
                    this.getReportModel().print = print = this.prepareDocument(this.jasperReport, this.parameters, ds, (IProgressMonitor)monitor.newChild(50), status);
                    this.checkStop();
                    if (!this.report.hasPostBuild) {
                        print = null;
                    }
                    monitor.worked(50);
                    this.checkStop();
                } else {
                    L.info("null datasource for target: {}", (Object)i);
                    ++failed;
                }
            }
            catch (Throwable th) {
                L.error("from report", th);
            }
            try {
                if (ds != null) {
                    boolean excludeDocGraphs = Boolean.getBoolean("exclude_doc_graphs");
                    L.debug("exclude_doc_graphs={}", (Object)excludeDocGraphs);
                    if (!excludeDocGraphs) {
                        this.extraWork(i, ds, (IProgressMonitor)monitor.newChild(50));
                    }
                }
            }
            catch (Throwable th) {
                L.error("from extraWork", th);
            }
            ds = null;
            this.checkStop();
            ++i;
        }
        L.info("{} succesfully generated from a total of {} from builder: {}", new Object[]{targets - failed, targets, ((Object)((Object)this)).getClass()});
        monitor.setWorkRemaining(0);
    }

    private void freeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        L.debug("free memory: {}", (Object)(freeMemory / 1024L));
        L.debug("allocated memory: {}", (Object)(allocatedMemory / 1024L));
        L.debug("max memory: {}", (Object)(maxMemory / 1024L));
        L.debug("total free memory: {}", (Object)((freeMemory + (maxMemory - allocatedMemory)) / 1024L));
    }

    protected String getFilePath(String exportPath, String fileName, String target) {
        String folder = target != null ? (target.length() > 2 ? target.substring(0, 2) : target) : (fileName.length() > 2 ? fileName.substring(0, 2) : fileName);
        folder = folder.trim();
        String expFolder = com.ez.mainframe.data.utils.Utils.getProjectPathName((String)this.project).concat(File.separator).concat(exportPath);
        File f = new File(String.valueOf(expFolder) + File.separatorChar + folder);
        if (!f.exists()) {
            boolean created = f.mkdirs();
            L.debug("{} created={}", (Object)f, (Object)created);
        }
        String ret = String.valueOf(f.getAbsolutePath()) + File.separatorChar + fileName;
        return ret;
    }

    protected String getFilePath(String exportPath, String fileName) {
        return this.getFilePath(exportPath, fileName, null);
    }

    protected String getRelativeFilePath(String exportPath, String fileName) {
        String folder = fileName.substring(0, 2);
        String ret = String.valueOf(exportPath) + File.separatorChar + folder + File.separatorChar + fileName;
        return ret;
    }

    protected void computeGeneralResults(int targetIndex, IProgressMonitor pmonitor) {
    }

    protected void cleanTarget() {
        if (this.report.print != null && this.report.print.getStylesMap() != null) {
            this.report.print.getStylesMap().clear();
            this.report.print = null;
        }
    }

    private void exportToXLS(JasperPrint print, String filePath) {
        try {
            File xlsFile = new File(String.valueOf(filePath) + ".xls");
            JRXlsExporter exporterXLS = new JRXlsExporter();
            exporterXLS.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
            exporterXLS.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)xlsFile);
            exporterXLS.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
            exporterXLS.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)Boolean.TRUE);
            exporterXLS.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
            exporterXLS.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            exporterXLS.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
            exporterXLS.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)new EZHyperlinkProducerFactory());
            exporterXLS.exportReport();
        }
        catch (Exception e) {
            L.error("error at exporting {} into .XLS file", (Object)filePath, (Object)e);
        }
    }

    private void exportToPDF(JasperPrint print, String filePath) {
        try {
            File pdfFile = new File(String.valueOf(filePath) + ".pdf");
            JRPdfExporter pdfExporter = new JRPdfExporter();
            pdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
            pdfExporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)pdfFile);
            pdfExporter.setParameter(JRPdfExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)new EZHyperlinkProducerFactory());
            pdfExporter.exportReport();
        }
        catch (Exception e) {
            L.error("error at exporting {} into .PDF file", (Object)filePath, (Object)e);
        }
    }

    public static String[][] runProc(EZSourceConnection conn, String procName, Collection<String> params, IProgressMonitor pmonitor) {
        String[][] result;
        block8: {
            result = null;
            String[] procParam = new String[]{};
            EZSourceConnection bridge = null;
            try {
                try {
                    bridge = conn != null ? conn : EZSourceConnectionManager.getCurrent();
                    List<EZSourceDataType> types = null;
                    if (params != null && !params.isEmpty()) {
                        types = Arrays.asList(new EZSourceDataType[params.size()]);
                        Collections.fill(types, EZSourceDataType.String);
                        result = bridge.execNonTransactionalStoredProc(procName, procParam, types, new ArrayList<String>(params));
                        break block8;
                    }
                    result = bridge.execNonTransactionalStoredProc(procName, procParam);
                }
                catch (Exception e) {
                    L.error("error at executing procedure {} with params: {}", new Object[]{procName, params, e});
                    if (conn == null && bridge != null) {
                        EZSourceConnectionManager.release((EZSourceConnection)bridge);
                    }
                }
            }
            finally {
                if (conn == null && bridge != null) {
                    EZSourceConnectionManager.release((EZSourceConnection)bridge);
                }
            }
        }
        return result;
    }

    protected void extraWork(int targetIdx, JRDataSource ds, IProgressMonitor monitor) {
    }

    private void exportToRtf(JasperPrint print, String filePath) {
        try {
            JRRtfExporter exporter = new JRRtfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
            exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)new EZHyperlinkProducerFactory());
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)new File(String.valueOf(filePath) + ".rtf"));
            exporter.exportReport();
        }
        catch (Exception e) {
            L.error("error at exporting {} into .RTF file", (Object)filePath, (Object)e);
        }
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor monitor) {
        return null;
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    public Map getReportParameters(IProgressMonitor monitor) {
        return this.parameters;
    }

    protected void postBuild(IProgressMonitor pmonitor) {
        if (this.report.hasPostBuild) {
            super.postBuild(pmonitor);
        }
    }

    protected void exportToTSXML(File xmlFile, TSEGraphManager gmanager) {
        TSLayoutProxy layoutProxy = new TSLayoutProxy();
        TSEAllOptionsServiceInputData inputData = new TSEAllOptionsServiceInputData((TSDGraphManager)gmanager);
        this.applyConstraints(inputData, gmanager);
        TSServiceOutputData outputData = new TSServiceOutputData();
        layoutProxy.run((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        TSApplyLayoutResults applyResults = new TSApplyLayoutResults();
        applyResults.apply((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        try {
            TSEVisualizationXMLWriter writer = new TSEVisualizationXMLWriter(xmlFile);
            writer.setGraphManager((TSGraphManager)gmanager);
            writer.setServiceInputData((TSServiceInputDataInterface)inputData);
            writer.write();
        }
        catch (FileNotFoundException e) {
            L.error("could not save to xml", (Throwable)e);
        }
    }

    public abstract String getFilePrefix();

    public abstract String getFileSuffix();

    public abstract String getIndexTitle();

    public abstract String getDefaultOutputFolder();
}

