/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.execution;

import com.ez.mainframe.reports.execution.GuiInputProvider;
import com.ez.mainframe.reports.execution.GuiOutputProvider;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.FinishListener;
import com.ez.report.generation.common.ExecutorFinishListener;
import com.ez.report.generation.common.GenerationStatus;
import com.ez.report.generation.common.ReportExecutorInterface;
import com.ez.report.generation.common.ReportInputProvider;
import com.ez.report.generation.common.ReportOutputProvider;
import com.ez.report.generation.common.ReportsRepository;
import com.ez.report.generation.common.model.ReportInformation;
import com.ez.report.generation.common.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportExecutor
implements ReportExecutorInterface {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportExecutor.class);
    private Shell shell;
    private IWorkbenchWindow window;
    private String reportName;
    private String propFile;
    private String projectName;
    private String repIndicator;
    private ReportOutputProvider outputProvider;
    private ReportInputProvider inputProvider;
    private AbstractReport report;

    public ReportExecutor(Map<String, Object> settings) {
        this.shell = (Shell)settings.get("shell");
        this.window = (IWorkbenchWindow)settings.get("window");
        this.reportName = (String)settings.get("report_name");
        this.repIndicator = (String)settings.get("report_indicator");
        this.propFile = (String)settings.get("properties_file");
        this.projectName = (String)settings.get("project_name");
        this.report = (AbstractReport)settings.get("report_model");
        if (this.report == null) {
            this.inputProvider = this.getInputProvider();
        } else {
            L.debug("an already generated report is open now");
        }
        this.outputProvider = new GuiOutputProvider(this);
    }

    public void generateReport(final IProgressMonitor pmonitor) {
        IStatus status = Status.OK_STATUS;
        if (this.outputProvider != null) {
            Map<String, Object> inputs = null;
            if (this.report == null) {
                if (this.inputProvider != null) {
                    inputs = this.getInputs();
                    if (inputs == null || inputs.isEmpty()) {
                        status = Status.CANCEL_STATUS;
                    }
                } else {
                    L.error("No input provider was specified!");
                    status = new Status(4, "com.ez.mainframe.reports.gui", Messages.getString(ReportExecutor.class, "noInput.status.error"));
                }
            }
            if (!status.equals(Status.CANCEL_STATUS)) {
                if (this.report != null && this.report.print != null) {
                    status = this.callOutputProvider(pmonitor, this.report, this.report.print, false);
                } else {
                    AbstractReportBuilder builder = (AbstractReportBuilder)ReportsRepository.getBuilder((String)this.reportName, (String)this.propFile, (String)this.repIndicator);
                    if (builder != null) {
                        FinishListener lst = new FinishListener(){

                            public IStatus reportFinished(AbstractReport model, JasperPrint print, boolean writeModel, IStatus st) {
                                st = pmonitor.isCanceled() || !st.isOK() ? Status.CANCEL_STATUS : ReportExecutor.this.callOutputProvider(pmonitor, model, print, writeModel);
                                return st;
                            }
                        };
                        builder.setFinishListener(lst);
                        builder.setProject(this.projectName);
                        builder.setInputs(inputs);
                        builder.setModel(this.report);
                        status = builder.execute(pmonitor);
                    } else {
                        L.error("Builder of report {} cannot be instantiated!", (Object)this.reportName);
                        status = new Status(4, "com.ez.mainframe.reports.gui", Messages.getString(ReportExecutor.class, "errorAtInstantiate.status.error", new String[]{this.reportName}));
                    }
                }
            }
        } else {
            L.error("No output provider was specified!");
            status = new Status(4, "com.ez.mainframe.reports.gui", Messages.getString(ReportExecutor.class, "noOutput.status.error"));
        }
    }

    private Map<String, Object> getInputs() {
        Map inputs = this.inputProvider != null ? this.inputProvider.getInputs() : null;
        return inputs;
    }

    private ReportInputProvider getInputProvider() {
        ReportInformation ri = ReportsRepository.getReportInformation((String)this.repIndicator);
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("shell", this.shell);
        settings.put("project_name", this.projectName);
        Class[] params = new Class[]{Map.class};
        Object[] args = new Object[]{settings};
        GuiInputProvider provider = (GuiInputProvider)Utils.instantiate((String)ri.getInputProviderName(), (Class[])params, (Object[])args);
        if (provider == null) {
            L.error("could not instantiate input provider for {}", (Object)this.reportName);
        }
        return provider;
    }

    public boolean isOkToContinue() {
        return true;
    }

    private IStatus callOutputProvider(IProgressMonitor pmonitor, AbstractReport model, JasperPrint print, boolean writeModelOnDisk) {
        IStatus st = Status.OK_STATUS;
        ((GuiOutputProvider)this.outputProvider).setReportModel(model);
        this.outputProvider.setDocument(print);
        ((GuiOutputProvider)this.outputProvider).setWindow(this.window);
        ((GuiOutputProvider)this.outputProvider).setShell(this.shell);
        ((GuiOutputProvider)this.outputProvider).writeModelOnDisk(writeModelOnDisk);
        this.outputProvider.showResults(pmonitor);
        st = pmonitor.isCanceled() ? Status.CANCEL_STATUS : st;
        return st;
    }

    public GuiOutputProvider getOutputProvider() {
        return (GuiOutputProvider)this.outputProvider;
    }

    public void setReportModelName(String newName) {
        this.report.name = newName;
    }

    public String getReportModelName() {
        return this.report.name;
    }

    public void addFinishListener(ExecutorFinishListener listener) {
    }

    public GenerationStatus getFinishStatus() {
        return null;
    }

    public List<Runnable> getCloseHandlers() {
        return null;
    }
}

