/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.execution;

import com.ez.mainframe.reports.execution.ReportExecutor;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.ui.displayview.ReportDisplayView;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.model.ModelVersion;
import com.ez.report.generation.common.GenerationStatus;
import com.ez.report.generation.common.ReportOutputProvider;
import com.ez.report.generation.common.ReportsRepository;
import com.ez.report.generation.common.model.ReportInformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiOutputProvider
implements ReportOutputProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GuiOutputProvider.class);
    private JasperPrint print;
    private boolean write;
    private IWorkbenchWindow window;
    private AbstractReport report;
    private ReportDisplayView repView = null;
    private Shell shell;
    private ReportExecutor executor;

    public GuiOutputProvider(ReportExecutor reportExecutor) {
        this.executor = reportExecutor;
    }

    public void setDocument(JasperPrint reportDocument) {
        this.print = reportDocument;
    }

    public GenerationStatus showResults(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        if (this.write) {
            this.writeModelOnDisk();
        }
        Display display = Display.getDefault();
        monitor.setTaskName(Messages.getString(GuiOutputProvider.class, "displayReport.job.name"));
        final JasperPrint document = this.print;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewPart view = GuiOutputProvider.this.window.getActivePage().showView("com.ez.report.application.ReportDisplayView", GuiOutputProvider.this.report.computeIndentifier(), 1);
                    if (view != null) {
                        GuiOutputProvider.this.repView = (ReportDisplayView)view;
                        GuiOutputProvider.this.repView.setTitleImageName(this.getImageName(), this.getBundleName());
                        GuiOutputProvider.this.repView.showInViewer(GuiOutputProvider.this.report, document);
                    }
                }
                catch (PartInitException ex) {
                    MessageDialog.openError((Shell)GuiOutputProvider.this.shell, (String)Messages.getString(GuiOutputProvider.class, "errorMessage.dialog.title"), (String)Messages.getString(GuiOutputProvider.class, "errorOpeningView.dialog.text", new String[]{ex.getMessage()}));
                    L.error("exception at activating report view", (Throwable)ex);
                }
                catch (Throwable t) {
                    L.error("exception ", t);
                }
            }

            private String getImageName() {
                ReportInformation repInfo = ReportsRepository.getReportInformation((int)((GuiOutputProvider)GuiOutputProvider.this).report.identifier);
                String imageName = repInfo.getImageName();
                return imageName;
            }

            private String getBundleName() {
                ReportInformation repInfo = ReportsRepository.getReportInformation((int)((GuiOutputProvider)GuiOutputProvider.this).report.identifier);
                String name = repInfo.getBundleName();
                return name;
            }
        });
        monitor.setWorkRemaining(0);
        return null;
    }

    protected ReportExecutor getExecutor() {
        return this.executor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeModelOnDisk() {
        String projectName = this.report.projectName;
        if (projectName != null && !"".equals(projectName)) {
            this.report.name = AbstractReport.generateName((AbstractReport)this.report);
            String path = Utils.getGeneratedDirectory();
            File f = new File(path.concat(this.report.name));
            this.report.print = this.print;
            this.report.print.setProperty("pdf_metadata_author", "IBM");
            this.report.print.setProperty("pdf_metadata_title", this.report.getMetadataTitle());
            this.writeModel(this.report, f);
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    String reportIdentif = String.valueOf(this.report.identifier);
                    long reportDate = Calendar.getInstance().getTimeInMillis();
                    String value = reportIdentif.concat(",").concat(String.valueOf(reportDate)).concat(",").concat(projectName).concat(",").concat(path);
                    Properties generatedPropFile = this.loadGeneratedConfig();
                    generatedPropFile.setProperty(this.report.name, value);
                    fileOutputStream = new FileOutputStream(Utils.getGeneratedFileProperties());
                    generatedPropFile.store(fileOutputStream, "reportname=report type by identifier,time when was generated,projectName,generatedDir\n");
                    ReportInformation repInfo = ReportsRepository.getReportInformation((String)reportIdentif);
                    String reportType = repInfo.getReportName();
                    RunInGUI runingui = new RunInGUI();
                    runingui.reportName = this.report.name;
                    runingui.reportType = reportType;
                    long time = Calendar.getInstance().getTimeInMillis();
                    DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
                    runingui.reportDate = df.format(new Date(time));
                    Display.getDefault().syncExec((Runnable)runingui);
                    return;
                }
                catch (FileNotFoundException e) {
                    L.error("error at writing report model on disk", (Throwable)e);
                    EZReportErrorLog.err(Messages.getString(GuiOutputProvider.class, "modelNotSavedError.logMessage"), e);
                    try {
                        if (fileOutputStream == null) return;
                        fileOutputStream.close();
                        return;
                    }
                    catch (IOException e2) {
                        L.error("save in rename", (Throwable)e2);
                    }
                    return;
                }
                catch (IOException e) {
                    L.error("error at writing report model on disk", (Throwable)e);
                    EZReportErrorLog.err(Messages.getString(GuiOutputProvider.class, "modelNotSavedError.logMessage"), e);
                    try {
                        if (fileOutputStream == null) return;
                        fileOutputStream.close();
                        return;
                    }
                    catch (IOException e3) {
                        L.error("save in rename", (Throwable)e3);
                    }
                    return;
                }
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    L.error("save in rename", (Throwable)e);
                }
            }
        }
        L.error("null project name?!");
    }

    private void writeModel(Object obj, File fileOut) {
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(fileOut);
            out = new ObjectOutputStream(fos);
            ModelVersion ver = new ModelVersion();
            Class<?> objClass = obj.getClass();
            ver.setVersion(ObjectStreamClass.lookup(objClass).getSerialVersionUID());
            ver.setClassName(objClass.toString());
            out.writeObject(ver);
            out.writeObject(obj);
            out.close();
            fos.close();
            L.debug("~~~~> report wrote into file: {}", (Object)fileOut.getPath());
        }
        catch (IOException ex) {
            L.error("exception at writing model", (Throwable)ex);
            EZReportErrorLog.err(Messages.getString(GuiOutputProvider.class, "modelNotSavedError.logMessage"), ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadGeneratedConfig() {
        Properties generatedProp = new Properties();
        String generatedRepsConfig = Utils.getGeneratedFileProperties();
        FileInputStream reportsFis = null;
        try {
            try {
                reportsFis = new FileInputStream(generatedRepsConfig);
                generatedProp.load(reportsFis);
                return generatedProp;
            }
            catch (FileNotFoundException e) {
                L.error("error at loading generated report config file", (Throwable)e);
                if (reportsFis == null) return generatedProp;
                try {
                    reportsFis.close();
                    return generatedProp;
                }
                catch (IOException e2) {
                    L.warn("could not close stream ", (Throwable)e2);
                }
                return generatedProp;
            }
            catch (IOException e) {
                L.error("error at loading generated report config file", (Throwable)e);
                if (reportsFis == null) return generatedProp;
                try {
                    reportsFis.close();
                    return generatedProp;
                }
                catch (IOException e3) {
                    L.warn("could not close stream ", (Throwable)e3);
                }
                return generatedProp;
            }
        }
        finally {
            if (reportsFis != null) {
                try {
                    reportsFis.close();
                }
                catch (IOException e) {
                    L.warn("could not close stream ", (Throwable)e);
                }
            }
        }
    }

    public void setWindow(IWorkbenchWindow window) {
        this.window = window;
    }

    public void writeModelOnDisk(boolean writeModel) {
        this.write = writeModel;
    }

    public void setReportModel(AbstractReport reportModel) {
        this.report = reportModel;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public ReportDisplayView getView() {
        return this.repView;
    }

    public void closeView() {
        this.cleanMemory();
    }

    private void cleanMemory() {
        if (this.report.print != null && this.report.print.getStylesMap() != null) {
            this.report.print.getStylesMap().clear();
            this.report.print = null;
            this.report.mustRegenerate = false;
        }
        this.report = null;
        this.repView = null;
    }

    class RunInGUI
    implements Runnable {
        String reportName;
        String reportType;
        String reportDate;

        RunInGUI() {
        }

        @Override
        public void run() {
        }
    }
}

