/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports.execution;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.generation.common.ReportInputProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuiInputProvider
implements ReportInputProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GuiInputProvider.class);
    public static final String AVAILABLE_JCL_FORAPPFLOW_QUERY = "SELECT JobName, 22, JobID FROM JCLJob where JobID > 0";
    @Deprecated
    public static final String AVAILABLE_PROGRAMS_4FUJITSU_IN_APPS_QUERY = "SELECT Programs.ProgramName AS ComponentName,  Programs.ProgramTypeID, Applications.ApplicationName, Programs.ProgramID FROM (Components INNER JOIN Programs ON Components.ResourceID = Programs.ProgramID) INNER JOIN \t\t(Applications \t\tINNER JOIN AppToComponents \t\t\tON Applications.ApplicationID = AppToComponents.ApplicationID\t\t) \t\tON Components.ComponentID = AppToComponents.ComponentID WHERE (((Components.ResourceType)=5)) \tand (Programs.OccurID <> 0) \tand (Applications.ApplicationID IN (select * from  #numeric_param_temp)) \tand Programs.ProgramTypeID not in (9, 13, 14, 15, 16,19) ORDER BY Programs.ProgramName;";
    private static final int DIALOG_MIN_HEIGHT = 550;
    private static final int DIALOG_MIN_WIDTH = 700;
    protected PrepareReportWizard wizard = null;
    protected String project;
    protected boolean openProject = true;
    protected Shell shell;

    public void setProject(String prj) {
        this.project = prj;
    }

    public void mustOpenPrj(boolean openPrj) {
        this.openProject = openPrj;
    }

    public void setShell(Shell sh) {
        this.shell = sh;
    }

    public Map<String, Object> getInputs() {
        boolean getModel;
        PrepareReportWizard wizard;
        block21: {
            wizard = this.getWizard();
            getModel = true;
            if (wizard != null) {
                EZSourceConnection bridge = null;
                try {
                    try {
                        bridge = EZSourceConnectionManager.getCurrent();
                        wizard.setProject(this.project);
                        if (this.openProject) {
                            bridge.openConnection();
                        }
                        ReportWizardDialog dialog = new ReportWizardDialog(this.shell, (IWizard)wizard);
                        dialog.create();
                        dialog.setMinimumPageSize(700, 550);
                        dialog.open();
                        if (wizard.isCanceled()) {
                            getModel = false;
                        } else {
                            this.completeSelectedPrograms(wizard, bridge);
                        }
                    }
                    catch (EZSourceConnectionException e) {
                        L.error("error at executing of report", (Throwable)e);
                        EZReportErrorLog.err(Messages.getString(GuiInputProvider.class, "bridgeError.message"), e);
                        getModel = false;
                        if (this.openProject && bridge != null) {
                            try {
                                bridge.closeConnection();
                            }
                            catch (EZSourceConnectionException e2) {
                                L.error("cannot close connection", (Throwable)e2);
                            }
                        }
                        if (bridge != null) {
                            EZSourceConnectionManager.release((EZSourceConnection)bridge);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (this.openProject && bridge != null) {
                        try {
                            bridge.closeConnection();
                        }
                        catch (EZSourceConnectionException e) {
                            L.error("cannot close connection", (Throwable)e);
                        }
                    }
                    if (bridge != null) {
                        EZSourceConnectionManager.release((EZSourceConnection)bridge);
                    }
                    throw throwable;
                }
                if (this.openProject && bridge != null) {
                    try {
                        bridge.closeConnection();
                    }
                    catch (EZSourceConnectionException e) {
                        L.error("cannot close connection", (Throwable)e);
                    }
                }
                if (bridge != null) {
                    EZSourceConnectionManager.release((EZSourceConnection)bridge);
                }
            }
        }
        return getModel ? (wizard != null ? wizard.getValues() : new HashMap()) : null;
    }

    protected void completeSelectedPrograms(PrepareReportWizard wizard, EZSourceConnection bridge) {
        List sel = wizard.getList("selected resources");
        if (sel != null) {
            HashSet<String> parents = new HashSet<String>();
            ArrayList<ProgramInputNoGUI> toComplete = new ArrayList<ProgramInputNoGUI>();
            for (Object input : sel) {
                ProgramInputNoGUI inpt;
                if (!(input instanceof ProgramInputNoGUI) || (inpt = (ProgramInputNoGUI)input).getTypeCode() != 8 && inpt.getTypeCode() != 13) continue;
                parents.add(inpt.getName());
                toComplete.add(inpt);
            }
            if (!parents.isEmpty()) {
                try {
                    String query = "select distinct child.programid, parent.AliasName from programs child join ProgramAliases parent on child.ancestor=parent.AliasName where parent.AliasName in (select * from " + Utils.getTempTableName((EZSourceConnection)bridge, (String)"string_param_temp") + ") " + "order by parent.AliasName";
                    List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[parents.size()]);
                    Collections.fill(types, EZSourceDataType.String);
                    String[][] programs = bridge.executeSQL(query, types, new ArrayList(parents));
                    if (programs != null) {
                        Collections.sort(toComplete);
                        int i = 0;
                        boolean cont = true;
                        while (cont) {
                            String prgName = programs[i][1];
                            ProgramInputNoGUI inpt = null;
                            try {
                                inpt = (ProgramInputNoGUI)toComplete.get(0);
                                L.trace("1. prgName={} ;;; inpt={}", (Object)prgName, (Object)inpt.getName());
                            }
                            catch (Exception e) {
                                L.error("1. not found prg {} to complete!", (Object)prgName, (Object)e);
                                cont = false;
                            }
                            if (inpt == null) continue;
                            int j = 0;
                            while (inpt != null && !inpt.getName().equalsIgnoreCase(prgName)) {
                                try {
                                    inpt = (ProgramInputNoGUI)toComplete.get(j);
                                    L.trace("2. prgName={} ;;; inpt={}", (Object)prgName, (Object)inpt.getName());
                                    ++j;
                                }
                                catch (Exception e) {
                                    L.error("2. not found prg {} to complete!", (Object)prgName, (Object)e);
                                    inpt = null;
                                    cont = false;
                                }
                            }
                            if (inpt == null) continue;
                            toComplete.remove(inpt);
                            while (i < programs.length && programs[i][1].equalsIgnoreCase(prgName)) {
                                String childId = programs[i][0];
                                inpt.addChildId(childId);
                                prgName = programs[i][1];
                                ++i;
                            }
                            boolean bl = cont = i < programs.length;
                        }
                    }
                    parents = null;
                    toComplete = null;
                }
                catch (EZSourceNativeException e) {
                    L.error("exception at getting childrens of assembler programs: {}", parents, (Object)e);
                    throw e;
                }
                catch (Throwable ex) {
                    L.error("completeSelectedPrograms()", ex);
                }
            }
        }
    }

    protected abstract PrepareReportWizard getWizard();
}

