/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports;

import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.editors.adsp.ADSProcessEditor;
import com.ez.mainframe.editors.assembler.AssemblerEditor;
import com.ez.mainframe.editors.cobol.CobolEditor;
import com.ez.mainframe.editors.jcl.JCLEditor;
import com.ez.mainframe.editors.natural.NaturalEditor;
import com.ez.mainframe.editors.pl1.PL1Editor;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.reports.gui.EZReportExportAsDocx;
import com.ez.mainframe.reports.gui.EZReportExportAsPDF;
import com.ez.mainframe.reports.gui.EZReportExportAsRtf;
import com.ez.mainframe.reports.gui.EZReportExportAsXls;
import com.ez.report.generation.common.ui.EZExportAsDocxAction;
import com.ez.report.generation.common.ui.EZExportAsPdfAction;
import com.ez.report.generation.common.ui.EZExportAsXlsAction;
import com.ez.report.generation.common.ui.ExportAsRtfAction;
import com.ez.report.generation.common.ui.ReportIDSegment;
import com.ez.report.generation.common.ui.ReportInfoAdapter;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.jasperassistant.designer.viewer.IReportViewer;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.eclipse.swt.program.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EzReportInfoAdapter
extends ReportInfoAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EzReportInfoAdapter.class);

    public EzReportInfoAdapter(EZEntityID id) {
        super(id);
    }

    protected void addHyperlinkListeners() {
        super.addHyperlinkListeners();
        this.reportViewer.addHyperlinkListener(new JRHyperlinkListener(){

            public void gotoHyperlink(JRPrintHyperlink hyperlink) throws JRException {
                if (hyperlink instanceof JRTemplatePrintText) {
                    String anchorName = ((JRTemplatePrintText)hyperlink).getAnchorName();
                    HyperlinkTypeEnum hyperlinkType = ((JRTemplatePrintText)hyperlink).getHyperlinkTypeValue();
                    if (HyperlinkTypeEnum.REFERENCE.equals((Object)hyperlinkType) || HyperlinkTypeEnum.CUSTOM.equals((Object)hyperlinkType)) {
                        L.debug("type reference");
                        String link = ((JRTemplatePrintText)hyperlink).getHyperlinkReference();
                        L.debug("ref: {}", (Object)link);
                        if (link != null) {
                            link = link.replace("%23", "#");
                            JRPrintHyperlinkParameters p = hyperlink.getHyperlinkParameters();
                            boolean wasOpen = false;
                            if (p != null) {
                                List paramList = p.getParameters();
                                for (JRPrintHyperlinkParameter parameter : paramList) {
                                    if (!parameter.getName().equalsIgnoreCase("isProgramLaunch")) continue;
                                    wasOpen = true;
                                    String[] str = link.split(",");
                                    Program.launch((String)str[1].concat(str[0]));
                                    break;
                                }
                            }
                            if (link.startsWith("./")) {
                                wasOpen = true;
                                String graphsDir = com.ez.report.generation.common.utils.Utils.getGraphsDirectory();
                                link = link.substring(2);
                                Program.launch((String)graphsDir.concat(link));
                            }
                            if (!wasOpen) {
                                String project = null;
                                EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)EzReportInfoAdapter.this.id.getSegment(EZSourceProjectIDSg.class);
                                if (prjSg != null) {
                                    project = prjSg.getProjectName();
                                } else if (EzReportInfoAdapter.this.id.getSegment(ReportIDSegment.class) != null) {
                                    ReportIDSegment repSg = (ReportIDSegment)EzReportInfoAdapter.this.id.getSegment(ReportIDSegment.class);
                                    project = (String)repSg.getAnalysis().getContextValue("project_name");
                                }
                                EzReportInfoAdapter.this.openLink(link, project);
                            }
                        }
                    }
                    if (anchorName != null) {
                        EzReportInfoAdapter.this.registerAnchor(anchorName);
                    }
                }
            }
        });
    }

    private void openLink(String link, String project) {
        String[] strs = link.split(",");
        String path = strs[0].trim();
        String type = strs[1].trim();
        int line = 0;
        if (strs.length > 2 && !strs[2].equals("null")) {
            line = Integer.valueOf(strs[2].trim());
        }
        if (type != null && path != null && path.length() > 0) {
            L.debug("type={}", (Object)type);
            type = type.equalsIgnoreCase("NATURAL") ? NaturalEditor.NATURAL_EDITOR_ID : (type.equalsIgnoreCase("PL1") ? PL1Editor.PL1_EDITOR_ID : (type.equalsIgnoreCase("COBOL") ? CobolEditor.COBOL_EDITOR_ID : (type.equalsIgnoreCase("ASSEMBLER") || type.equalsIgnoreCase("CSECT") || type.equalsIgnoreCase("ASM ENTRY") ? AssemblerEditor.ASSEMBLER_EDITOR_ID : (type.equalsIgnoreCase("ADS Process") ? ADSProcessEditor.ADSP_EDITOR_ID : (type.equalsIgnoreCase("JCL") ? JCLEditor.JCL_EDITOR_ID : "ezeditor.id")))));
            L.debug("editorId={}", (Object)type);
            Utils.openEditor((String)path, (int[])new int[]{line}, (String)type, (String)project);
        }
    }

    protected EZExportAsDocxAction instantiateExportDocxAction() {
        return new EZReportExportAsDocx((IReportViewer)this.reportViewer);
    }

    protected EZExportAsPdfAction instantiateExportPDFAction() {
        return new EZReportExportAsPDF((IReportViewer)this.reportViewer);
    }

    protected EZExportAsXlsAction instantiateXlsExportAction() {
        return new EZReportExportAsXls((IReportViewer)this.reportViewer);
    }

    protected ExportAsRtfAction instantiateExportRtfAction() {
        return new EZReportExportAsRtf((IReportViewer)this.reportViewer);
    }
}

