/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.reports;

import com.tomsawyer.application.swing.export.TSESaveAsImageDialog;
import com.tomsawyer.application.swing.product.TSVisualizationFeatures;
import com.tomsawyer.canvas.TSBaseCanvasInterface;
import com.tomsawyer.canvas.TSCanvas;
import com.tomsawyer.canvas.image.svg.TSSVGImageCanvas;
import com.tomsawyer.canvas.image.svg.TSSVGImageCanvasPreferenceTailor;
import com.tomsawyer.canvas.rendering.TSRenderingPreferenceTailor;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import com.tomsawyer.licensing.TSFeatureID;
import com.tomsawyer.licensing.TSLicenseManager;
import com.tomsawyer.licensing.TSLicenseRuntimeException;
import com.tomsawyer.util.preference.TSPreferenceData;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZExportGraphDialogInternal
extends TSESaveAsImageDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(EZExportGraphDialogInternal.class);
    private File exportFile = null;
    private TSEGraphManager graphManager = null;

    public EZExportGraphDialogInternal(TSEGraphManager graphManager, Frame frame, String s, TSSwingCanvas tsswingcanvas, int i, File file) {
        this(graphManager, frame, s, tsswingcanvas, i);
        this.fileName.setText(file.getName());
        this.exportFile = file;
    }

    public EZExportGraphDialogInternal(TSEGraphManager graphManager, Frame frame, String s, TSSwingCanvas tsswingcanvas, int i) {
        super(frame, s, (TSBaseCanvasInterface)tsswingcanvas, i);
        this.graphManager = graphManager;
    }

    public EZExportGraphDialogInternal(Frame frame, String s, TSSwingCanvas tsswingcanvas, int i) {
        super(frame, s, (TSBaseCanvasInterface)tsswingcanvas, i);
    }

    public void setGraphManager(TSEGraphManager graphManager) {
        this.graphManager = graphManager;
        this.getCanvas().setGraphManager(graphManager);
    }

    public void setExportFile(File exportFile) {
        this.exportFile = exportFile;
    }

    public boolean onOK() {
        boolean flag2 = false;
        boolean flag = true;
        if (TSLicenseManager.checkLicense((TSFeatureID)TSVisualizationFeatures.IMAGE_EXPORT_CLIENT) || TSLicenseManager.checkLicense((TSFeatureID)TSVisualizationFeatures.IMAGE_EXPORT_SERVER)) {
            FileOutputStream fileoutputstream = null;
            try {
                fileoutputstream = new FileOutputStream(this.exportFile);
                TSPreferenceData o = new TSPreferenceData();
                TSSVGImageCanvasPreferenceTailor tssvgimagecanvaspreferencetailor = new TSSVGImageCanvasPreferenceTailor(o);
                double height = this.getCanvas().getGraph().getFrameBounds().getHeight();
                double width = this.getCanvas().getGraph().getFrameBounds().getWidth();
                tssvgimagecanvaspreferencetailor.setWidth(new Double(width).intValue());
                tssvgimagecanvaspreferencetailor.setHeight(new Double(height).intValue());
                tssvgimagecanvaspreferencetailor.setExportAll();
                tssvgimagecanvaspreferencetailor.setScaleByPages();
                tssvgimagecanvaspreferencetailor.setImageColumns(1);
                tssvgimagecanvaspreferencetailor.setImageRows(1);
                TSRenderingPreferenceTailor tsrenderingpreferencetailor = new TSRenderingPreferenceTailor(tssvgimagecanvaspreferencetailor.getPreferenceData());
                tsrenderingpreferencetailor.setDrawSelectedOnly(false);
                boolean flag11 = new TSRenderingPreferenceTailor(this.getCanvas().getPreferenceData()).isDrawNodesBeforeEdges();
                tsrenderingpreferencetailor.setDrawNodesBeforeEdges(flag11);
                tsrenderingpreferencetailor.setDrawSelectionState(false);
                TSSVGImageCanvas tsSVGimagecanvas = new TSSVGImageCanvas(this.graphManager, (OutputStream)fileoutputstream);
                tsSVGimagecanvas.setDisplayCanvas((TSCanvas)this.getCanvas());
                tsSVGimagecanvas.setPreferenceData(o);
                tsSVGimagecanvas.paint();
            }
            catch (FileNotFoundException fileNotFoundException) {
                L.debug("File not found exception.");
                L.debug("Cannot_write_file: {}", (Object)this.exportFile.getAbsolutePath());
                flag = false;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                L.debug("Memory_exceeded.");
                L.debug("Cannot_write_file: {}", (Object)this.exportFile.getAbsolutePath());
                flag2 = true;
                flag = false;
            }
            catch (Exception exception) {
                L.debug("Cannot_write_file: {}", (Object)this.exportFile.getAbsolutePath());
                flag2 = true;
                flag = false;
            }
            try {
                if (fileoutputstream != null) {
                    fileoutputstream.close();
                    if (flag2 && this.exportFile != null) {
                        this.exportFile.delete();
                    }
                }
            }
            catch (IOException iOException) {
                L.debug("Cannot_write_file: {}", (Object)this.exportFile.getAbsolutePath());
                flag = false;
            }
        } else {
            this.callBack(new TSLicenseRuntimeException());
            flag = false;
        }
        return flag;
    }
}

