/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.swt;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public enum DpiScaler {
    INSTANCE;

    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DPI_CURRENT;
    private static final float DPI_DEFAULT = 96.0f;
    private static final float DPI_SCALE;

    static {
        DPI_CURRENT = Display.getDefault().getDPI().x;
        DPI_SCALE = (float)DPI_CURRENT / 96.0f;
    }

    public static int getScaledSize(int length) {
        return Math.round(DPI_SCALE * (float)length);
    }

    public static void scaleControl(Control control) {
        int x = (int)((float)control.getLocation().x * DPI_SCALE);
        int y = (int)((float)control.getLocation().y * DPI_SCALE);
        int w = (int)((float)control.getSize().x * DPI_SCALE);
        int h = (int)((float)control.getSize().y * DPI_SCALE);
        control.setBounds(x, y, w, h);
    }
}

