/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.properties.sections;

import com.ez.common.ui.internal.Messages;
import com.ez.common.ui.properties.AnalysisSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AnalysisSection
extends AbstractPropertySection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int TEXT_WIDTH = 150;
    private Text txtName;
    private Text txtType;
    private Composite composite;
    private AnalysisSelection sel;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection) {
            Object objSel = ((StructuredSelection)selection).getFirstElement();
            this.sel = objSel instanceof AnalysisSelection ? (AnalysisSelection)objSel : null;
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.composite = this.getWidgetFactory().createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        this.getWidgetFactory().createCLabel(this.composite, Messages.getString(AnalysisSection.class, "name.label"));
        this.txtName = this.getWidgetFactory().createText(this.composite, "", 8);
        GridData gridData = new GridData(256);
        gridData.minimumWidth = 150;
        this.txtName.setLayoutData((Object)gridData);
        this.getWidgetFactory().createCLabel(this.composite, Messages.getString(AnalysisSection.class, "type.label"));
        this.txtType = this.getWidgetFactory().createText(this.composite, "", 8);
        gridData = new GridData(256);
        gridData.minimumWidth = 150;
        this.txtType.setLayoutData((Object)gridData);
    }

    public void refresh() {
        if (this.sel != null) {
            if (this.sel.getAnalysisName() != null) {
                this.txtName.setText(this.sel.getAnalysisName());
            } else {
                this.txtName.setText("");
            }
            if (this.sel.getAnalysisType() != null) {
                this.txtType.setText(this.sel.getAnalysisType());
            } else {
                this.txtType.setText("");
            }
        } else {
            this.clearForm();
        }
        this.composite.pack();
    }

    private void clearForm() {
        this.txtName.setText("");
        this.txtType.setText("");
    }

    public void dispose() {
        super.dispose();
    }
}

