/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.properties.sections;

import com.ez.common.ui.guielements.IEzPropertySelection;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractWidgetSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Color selectionColor = Display.getDefault().getSystemColor(26);
    private static final Color whiteColor = Display.getDefault().getSystemColor(27);
    protected IResource displayedResource;
    protected boolean started = false;
    protected int yWidget = 0;
    protected Object currentSelectedItem;
    protected Listener resizeListener;
    protected Listener colorSelectListener;
    private Rectangle currentBounds;

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
    }

    protected void resizeScrolledComposite() {
        if (this.isWidgetAvailable(new Widget[]{this.composite, this.getWidget(), this.scrolledComposite})) {
            if (!this.scrolledComposite.getExpandHorizontal()) {
                this.scrolledComposite.setExpandHorizontal(true);
            }
            if (!this.scrolledComposite.getExpandVertical()) {
                this.scrolledComposite.setExpandVertical(true);
            }
            if (!this.scrolledComposite.getClientArea().equals((Object)this.currentBounds)) {
                this.currentBounds = this.scrolledComposite.getClientArea();
                Composite widget = this.getWidget();
                widget.setVisible(false);
                int height = this.scrolledComposite.getClientArea().height;
                Composite content = (Composite)this.scrolledComposite.getContent();
                content.redraw();
                content.layout(false, false);
                widget.layout(true);
                widget.redraw();
                this.scrolledComposite.redraw();
                Rectangle rectangleWidgetBounds = this.getWidget().getBounds();
                int max = Math.max(rectangleWidgetBounds.height, Math.max(height, content.getBounds().height));
                this.scrolledComposite.setMinHeight(max + 25);
                this.scrolledComposite.layout(true);
                widget.setVisible(true);
                int minHeight = this.getTotalHeight() + 1;
                this.scrolledComposite.setMinHeight(minHeight);
                this.scrolledComposite.getContent().setLocation(0, 0);
                this.scrolledComposite.redraw();
                this.showSelection();
            }
        }
    }

    protected void refreshWidgets() {
        if (this.isWidgetAvailable(new Widget[]{this.composite, this.getWidget(), this.scrolledComposite})) {
            if (!this.scrolledComposite.getExpandHorizontal()) {
                this.scrolledComposite.setExpandHorizontal(true);
            }
            if (!this.scrolledComposite.getExpandVertical()) {
                this.scrolledComposite.setExpandVertical(true);
            }
            Rectangle rectangleWidgetBounds = this.getWidget().getBounds();
            this.currentBounds = this.scrolledComposite.getClientArea();
            Composite widget = this.getWidget();
            widget.setVisible(false);
            this.scrolledComposite.setVisible(false);
            int height = this.scrolledComposite.getClientArea().height;
            Composite content = (Composite)this.scrolledComposite.getContent();
            content.redraw();
            if (rectangleWidgetBounds.y > 15) {
                this.yWidget = rectangleWidgetBounds.y;
            }
            this.scrolledComposite.redraw();
            int max = Math.max(rectangleWidgetBounds.height, Math.max(height, content.getBounds().height));
            this.scrolledComposite.setMinHeight(max);
            this.scrolledComposite.layout(true);
            widget.setVisible(true);
            this.scrolledComposite.setVisible(true);
            this.getWidget().setVisible(true);
        }
        this.showSelection();
    }

    protected abstract float findSelectionPercentage();

    protected abstract int getWidgetItemHeight();

    protected int getTotalHeightOfOtherSections() {
        Composite holder;
        Control[] children;
        int result = 0;
        if (this.isWidgetAvailable(new Widget[]{this.composite}) && (children = (holder = this.composite.getParent().getParent()).getChildren()).length > 1) {
            int i = 0;
            while (i < children.length) {
                Control control = children[i];
                if (control == this.composite.getParent()) break;
                Composite otherSection = control.getParent();
                Rectangle otherBounds = otherSection.getBounds();
                result += otherBounds.height;
                ++i;
            }
        }
        return result;
    }

    protected int getCurrentWidgetHeight() {
        int result = 0;
        if (this.isWidgetAvailable(new Widget[]{this.getWidget()})) {
            this.getWidget().layout(true, true);
            Rectangle rectangle = this.getWidget().getBounds();
            int widgetTotalHeight = rectangle.height;
            float selectionPercentage = this.findSelectionPercentage();
            result = (int)((float)widgetTotalHeight * selectionPercentage);
            if (rectangle.y > 0) {
                result += rectangle.y;
            }
        }
        return result;
    }

    protected int getTotalSelectionHeight() {
        int result = 0;
        result = this.getTotalHeightOfOtherSections() + this.getCurrentWidgetHeight();
        return result;
    }

    protected float findTotalSelectionPercentage() {
        float result = 0.0f;
        Composite holder = this.composite.getParent().getParent();
        Rectangle rectCompositeParentBounds = this.composite.getParent().getBounds();
        int height = this.scrolledComposite.getBounds().height;
        Rectangle rectangle = holder.getBounds();
        if (rectCompositeParentBounds.height > rectangle.height) {
            rectangle = rectCompositeParentBounds;
        }
        height = (height - this.getWidgetItemHeight()) / 2;
        result = rectangle.height != 0 ? (float)this.getTotalSelectionHeight() / (float)(rectangle.height + height) : 0.0f;
        return result;
    }

    protected int getTotalHeight() {
        int result = 0;
        if (this.isWidgetAvailable(new Widget[]{this.composite})) {
            Rectangle rectangle1 = this.composite.getParent().getBounds();
            Rectangle rectangle2 = this.composite.getParent().getParent().getBounds();
            if (rectangle1.height > rectangle2.height) {
                rectangle2 = rectangle1;
            }
            result = rectangle2.height - 25;
        }
        return result;
    }

    protected void showSelection() {
        if (this.isWidgetAvailable(new Widget[]{this.getWidget()})) {
            ScrollBar bar;
            float i = this.findTotalSelectionPercentage();
            if (this.scrolledComposite != null && (bar = this.scrolledComposite.getVerticalBar()) != null) {
                int maxValue = this.getTotalHeight();
                bar.setVisible(true);
                this.scrolledComposite.layout(true, true);
                bar.setMaximum(maxValue);
                bar.setIncrement(10);
                int max = bar.getMaximum();
                int selection = (int)(i * (float)max);
                bar.setSelection(selection);
                Listener[] l = bar.getListeners(13);
                if (l != null && l.length > 0) {
                    int j = 0;
                    while (j < l.length) {
                        Listener li = l[j];
                        Event e = new Event();
                        li.handleEvent(e);
                        ++j;
                    }
                }
            }
        }
    }

    protected void computeWidgetAbscice() {
        if (this.isWidgetAvailable(new Widget[]{this.getWidget()})) {
            Rectangle rectangle = this.getWidget().getBounds();
            this.yWidget = rectangle.y;
            if (this.yWidget < 15) {
                this.yWidget = 0;
            }
        }
    }

    public void dispose() {
        if (this.isWidgetAvailable(new Widget[]{this.scrolledComposite})) {
            this.scrolledComposite.removeListener(11, this.resizeListener);
            this.scrolledComposite.setVisible(false);
        }
        if (this.isWidgetAvailable(new Widget[]{this.getWidget()})) {
            this.getWidget().removeListener(40, this.colorSelectListener);
        }
        super.dispose();
    }

    protected void addSelectionColorToWidget() {
        if (this.isWidgetAvailable(new Widget[]{this.getWidget()})) {
            if (this.colorSelectListener == null) {
                this.colorSelectListener = new Listener(){

                    public void handleEvent(Event event) {
                        event.detail &= 0xFFFFFFDF;
                        if ((event.detail & 2) == 0) {
                            return;
                        }
                        int clientWidth = AbstractWidgetSection.this.getWidget().getClientArea().width;
                        GC gc = event.gc;
                        Color oldBackground = gc.getBackground();
                        gc.setBackground(selectionColor);
                        gc.setForeground(whiteColor);
                        gc.fillRectangle(0, event.y, clientWidth, event.height);
                        gc.setBackground(oldBackground);
                        event.detail &= 0xFFFFFFFD;
                    }
                };
            }
            this.getWidget().addListener(40, this.colorSelectListener);
        }
    }

    protected void findAndSetupScrolledComposite() {
        this.findScrolledComposite();
        this.resolveScrolledComposite();
    }

    private void resolveScrolledComposite() {
        if (this.scrolledComposite.getExpandHorizontal()) {
            this.scrolledComposite.setExpandHorizontal(false);
        }
        if (this.scrolledComposite.getExpandVertical()) {
            this.scrolledComposite.setExpandVertical(false);
        }
        this.scrolledComposite.setAlwaysShowScrollBars(false);
        if (this.scrolledComposite.getVerticalBar().isVisible()) {
            this.scrolledComposite.getVerticalBar().setVisible(false);
        }
        if (this.scrolledComposite.getHorizontalBar().isVisible()) {
            this.scrolledComposite.getHorizontalBar().setVisible(false);
        }
        if (this.resizeListener == null) {
            this.resizeListener = new Listener(){

                public void handleEvent(Event event) {
                    AbstractWidgetSection.this.resizeScrolledComposite();
                }
            };
        }
        this.scrolledComposite.addListener(11, this.resizeListener);
    }

    protected boolean isSelected(Object object) {
        IEzPropertySelection searchResource;
        boolean result = false;
        if (object != null && this.resource != null && this.resource instanceof IEzPropertySelection && (searchResource = (IEzPropertySelection)this.resource).getFoundObject() != null) {
            Object foundObject = searchResource.getFoundObject().getObject();
            result = object.equals(foundObject);
        }
        return result;
    }

    @Override
    public void aboutToBeShown() {
        this.computeWidgetAbscice();
        if (this.isWidgetAvailable(new Widget[]{this.scrolledComposite})) {
            if (!this.hookedListener((Composite)this.scrolledComposite, 11, this.resizeListener)) {
                this.scrolledComposite.addListener(11, this.resizeListener);
            }
            this.started = true;
        }
        super.aboutToBeShown();
    }

    private boolean hookedListener(Composite widget, int type, Listener listener) {
        Listener[] allResizeListener;
        boolean hooked = false;
        if (this.isWidgetAvailable(new Widget[]{widget}) && (allResizeListener = widget.getListeners(type)) != null && allResizeListener.length > 0) {
            int i = 0;
            while (i < allResizeListener.length) {
                if (allResizeListener[i] == listener) {
                    hooked = true;
                }
                ++i;
            }
        }
        return hooked;
    }

    @Override
    public void aboutToBeHidden() {
        if (this.isWidgetAvailable(new Widget[]{this.scrolledComposite})) {
            this.scrolledComposite.removeListener(11, this.resizeListener);
        }
        super.aboutToBeHidden();
    }

    protected abstract Composite getWidget();
}

