/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.properties.sections;

import com.ez.common.ui.guielements.IEzPropertySelection;
import com.ez.common.ui.properties.sections.AbstractWidgetSection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractTreeSection
extends AbstractWidgetSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected Tree tree;
    protected List columns;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gridLayout = new GridLayout();
        this.composite.setLayout((Layout)gridLayout);
        this.findAndSetupScrolledComposite();
        this.page = aTabbedPropertySheetPage;
        this.tree = this.getWidgetFactory().createTree(this.composite, 66304);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        GridData gridData = new GridData(4, 4, true, true);
        this.tree.setLayoutData((Object)gridData);
        this.buildColumns();
        this.hookContextMenu();
        this.resizeScrolledComposite();
        this.addSelectionColorToWidget();
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        if (this.isWidgetAvailable(new Widget[]{this.tree})) {
            if (this.tree.getSelectionCount() > 0) {
                this.showSelection(false, true);
            } else {
                this.tree.deselectAll();
            }
        }
        if (this.currentSelectedItem != null && this.currentSelectedItem == this.selectedItem) {
            if (this.isWidgetAvailable(new Widget[]{this.tree})) {
                this.tree.setVisible(true);
            }
            return;
        }
        if (this.tree != null && this.tree.isDisposed()) {
            return;
        }
        if (this.isWidgetAvailable(new Widget[]{this.tree})) {
            this.tree.deselectAll();
        }
        this.currentSelectedItem = this.selectedItem;
        this.tree.setVisible(false);
        this.scrolledComposite.setVisible(false);
        if (this.displayedResource == null || this.displayedResource != null && this.displayedResource.getFullPath() != this.resource.getFullPath() || this.tree.getItemCount() == 0) {
            this.displayedResource = this.resource;
            this.fillTree();
            Rectangle rectangleTreeBounds = this.getWidget().getBounds();
            rectangleTreeBounds = this.composite.getBounds();
            int totalHeight = this.getTotalHeight();
            if (totalHeight > rectangleTreeBounds.height) {
                rectangleTreeBounds.height = totalHeight;
            }
            if (this.getWidget().getBounds().height < rectangleTreeBounds.height) {
                this.getWidget().setBounds(rectangleTreeBounds);
            }
            if (this.composite.getParent().getParent().getBounds().height < rectangleTreeBounds.height) {
                this.composite.getParent().getParent().setBounds(rectangleTreeBounds);
            }
            this.resizeScrolledComposite();
        }
        this.handleSelection();
        if (!this.started) {
            this.started = true;
            this.computeWidgetAbscice();
            this.scrolledComposite.layout(true, true);
            this.scrolledComposite.redraw();
            this.resizeScrolledComposite();
        }
        this.refreshWidgets();
        this.showSelection();
        this.scrolledComposite.layout(true, true);
        this.scrolledComposite.setVisible(true);
        this.handleSelection();
        Rectangle rect = this.scrolledComposite.getBounds();
        int height = this.getTotalHeight();
        if (height < rect.height) {
            height = rect.height;
        }
        this.scrolledComposite.setMinHeight(height + 1);
        if (this.composite.getParent().getParent().getBounds().height < height + 10) {
            Rectangle rect4 = this.composite.getParent().getParent().getBounds();
            rect4.height = height + 100;
            this.composite.getParent().getParent().setBounds(rect4);
        }
        if (!this.tree.isVisible()) {
            this.tree.setVisible(true);
        }
        this.resizeScrolledComposite();
        this.scrolledComposite.setVisible(true);
        this.refreshWidgets();
        this.scrolledComposite.redraw();
        this.scrolledComposite.getVerticalBar().setVisible(true);
    }

    @Override
    protected int getTotalHeight() {
        int result = 0;
        if (this.isWidgetAvailable(new Widget[]{this.composite})) {
            Rectangle rectangle1 = this.composite.getParent().getBounds();
            Rectangle rectangle2 = this.composite.getParent().getParent().getBounds();
            if (rectangle1.height > rectangle2.height) {
                rectangle2 = rectangle1;
            }
            result = rectangle2.height - 25;
        }
        return result;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object currentSelectedItem = this.selectedItem;
        super.setInput(part, selection);
        if (currentSelectedItem != this.selectedItem && this.selectedItem != null) {
            this.collapseAllItems();
        }
    }

    private void collapseAllItems() {
        if (this.isWidgetAvailable(new Widget[]{this.tree}) && this.tree.getItemCount() > 0) {
            TreeItem[] items = this.tree.getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (item.getExpanded()) {
                    item.setExpanded(false);
                }
                ++i;
            }
        }
    }

    protected void fillTree() {
        this.tree.removeAll();
        for (Object next : this.getOwnedRows()) {
            TreeItem item = new TreeItem(this.tree, 0);
            String[] values = new String[this.columns.size()];
            List valuesForRow = this.getValuesForRow(next);
            int j = 0;
            while (j < this.columns.size()) {
                Object val = valuesForRow.get(j);
                values[j] = (String)val;
                ++j;
            }
            item.setText(values);
            item.setData(next);
            this.buildElements(next, item);
        }
    }

    @Override
    protected void showSelection() {
        super.showSelection();
    }

    protected void showSelection(boolean doLayout, boolean doListeners) {
        if (this.isWidgetAvailable(new Widget[]{this.getWidget()})) {
            ScrollBar bar;
            float i = this.findTotalSelectionPercentage();
            if (this.scrolledComposite != null && (bar = this.scrolledComposite.getVerticalBar()) != null) {
                Listener[] l;
                int maxValue = this.getTotalHeight();
                if (doLayout) {
                    bar.setVisible(true);
                    this.scrolledComposite.layout(true, true);
                }
                bar.setMaximum(maxValue);
                bar.setIncrement(10);
                int max = bar.getMaximum();
                int selection = (int)(i * (float)max);
                bar.setSelection(selection);
                if (doListeners && (l = bar.getListeners(13)) != null && l.length > 0) {
                    int j = 0;
                    while (j < l.length) {
                        Listener li = l[j];
                        Event e = new Event();
                        li.handleEvent(e);
                        ++j;
                    }
                }
            }
        }
    }

    protected void handleSelection() {
        IEzPropertySelection prop;
        ArrayList<TreeItem> selectionList = new ArrayList<TreeItem>();
        TreeItem[] items = this.tree.getItems();
        if (this.resource != null && this.resource instanceof IEzPropertySelection && (prop = (IEzPropertySelection)this.resource).getFoundObject() != null) {
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                Object data = item.getData();
                if (item.getItemCount() > 0) {
                    TreeItem[] children = item.getItems();
                    int j = 0;
                    while (j < children.length) {
                        Object childData = children[j].getData();
                        if (childData != null && this.isSelected(childData)) {
                            if (!item.getExpanded()) {
                                item.setExpanded(true);
                            }
                            selectionList.add(children[j]);
                        }
                        ++j;
                    }
                }
                if (this.isSelected(data)) {
                    selectionList.add(item);
                }
                ++i;
            }
        }
        if (!selectionList.isEmpty()) {
            this.tree.setSelection(selectionList.toArray(new TreeItem[0]));
        } else {
            this.tree.deselectAll();
        }
        if (!selectionList.isEmpty()) {
            this.showSelection();
        }
    }

    private float findPercentage(TreeItem item) {
        int i = this.tree.indexOf(item);
        int pos = -1;
        int itemElementsCount = 0;
        if (i != -1) {
            pos = i + 1;
        } else {
            TreeItem[] items = this.tree.getItems();
            int j = 0;
            while (j < items.length) {
                TreeItem root = items[j];
                i = root.indexOf(item);
                if (i != -1) {
                    pos = j + 1 + (i + 1);
                    itemElementsCount = root.getItemCount();
                    if (root.getExpanded()) break;
                    root.setExpanded(true);
                    break;
                }
                if (root.getExpanded()) {
                    root.setExpanded(false);
                }
                ++j;
            }
        }
        float result = 0.0f;
        if (pos > 0) {
            int totalHeight = this.tree.getItemCount() + itemElementsCount;
            if (this.tree.getHeaderVisible()) {
                ++totalHeight;
                --pos;
            }
            result = (float)pos / (float)totalHeight;
        }
        return result;
    }

    @Override
    protected float findSelectionPercentage() {
        int wholeHeight;
        int clientHeight;
        float result = 0.0f;
        if (this.isWidgetAvailable(new Widget[]{this.tree}) && this.tree.getSelectionCount() > 0) {
            TreeItem item = this.tree.getSelection()[0];
            result = this.findPercentage(item);
        }
        if ((clientHeight = this.scrolledComposite.getClientArea().height) - (wholeHeight = this.tree.getBounds().height) > -5) {
            result = 0.0f;
        }
        return result;
    }

    @Override
    protected int getWidgetItemHeight() {
        int result = 0;
        if (this.isWidgetAvailable(new Widget[]{this.tree})) {
            result = this.tree.getItemHeight();
        }
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected Composite getWidget() {
        return this.tree;
    }

    protected abstract void buildElements(Object var1, TreeItem var2);

    protected abstract List getValuesForRow(Object var1);

    protected abstract Set getOwnedRows();

    protected abstract void buildColumns();

    protected abstract void hookContextMenu();
}

